# H.1 Have anarchists always opposed state socialism?

Yes. Anarchists have always argued that real socialism cannot be created using
a state. The basic core of the argument is simple. Socialism implies equality,
yet the state signifies inequality - inequality in terms of power. As we
argued in [section B.2](secB2.html), anarchists consider one of the defining
aspects of the state is its hierarchical nature. In other words, the
delegation of **power** into the hands of a few. As such, it violates a core
idea of socialism, namely social equality. Those who make up the governing
bodies in a state have more power than those who have elected them (see
[section I.1](secI1.html)).

It is with this perspective that anarchists have combated the idea of state
socialism and Marxism (although we should stress that libertarian forms of
Marxism, such as council communism, have strong similarities to anarchism). In
the case of the Russian Revolution, the anarchists were amongst the first on
the left to be suppressed by the Bolsheviks. Indeed, the history of Marxism
is, in part, a history of its struggles against anarchists just as the history
of anarchism is also, in part, a history of its struggle against the various
forms of Marxism and its offshoots.

While both Stirner and Proudhon wrote many pages against the evils and
contradictions of state socialism, anarchists have only really been fighting
the Marxist form of state socialism since Bakunin. This is because, until the
First International, Marx and Engels were relatively unknown socialist
thinkers. Proudhon was aware of Marx (they had meant in France in the 1840s
and had corresponded) but Marxism was unknown in France during his life time
and so Proudhon did not directly argue against Marxism (he did, however,
critique Louis Blanc and other French state socialists). Similarly, when
Stirner wrote **The Ego and Its Own** Marxism did not exist bar a few works by
Marx and Engels. Indeed, it could be argued that Marxism finally took shape
after Marx and Engels had read Stirner's classic work and produced their
notoriously inaccurate diatribe, **The German Ideology**, against him.
However, like Proudhon, Stirner attacked **other** state socialists and
communists.

Before discussing Bakunin's opposition and critique of Marxism in the [next
section](secH1.html#sech11), we should consider the thoughts of Stirner and
Proudhon on state socialism. These critiques contain may important ideas and
so are worth summarising. However, it is worth noting that when both Stirner
and Proudhon were writing communist ideas were all authoritarian in nature.
Libertarian communism only developed after Bakunin's death in 1876. This means
that when Proudhon and Stirner were critiquing "communism" they were attacking
a specific form of communism, the form which subordinated the individual to
the community. Anarchist communists like Kropotkin and Malatesta also opposed
such kinds of "communism." As Kropotkin put it, _"before and in 1848"_
communism _"was put forward in such a shape as to fully account for Proudhon's
distrust as to its effect upon liberty. The old idea of Communism was the idea
of monastic communities . . . The last vestiges of liberty and of individual
energy would be destroyed, if humanity ever had to go through such a
communism."_ [**Act for Yourselves**, p. 98] Of course, it may be likely that
Stirner and Proudhon would have rejected libertarian communism as well, but
bear in mind that not all forms of "communism" are identical.

For Stirner, the key issue was that communism (or socialism), like liberalism,
looked to the _"human"_ rather than the unique. _"To be looked upon as a mere
**part**, part of society,"_ asserted Stirner, _"the individual cannot bear -
because he is **more**; his uniqueness puts from it this limited conception."_
As such, his protest against socialism was similar to his protest against
liberalism (indeed, he drew attention to their similarity by calling it
_"social liberalism"_). Stirner was aware that capitalism was not the great
defender of freedom it was claimed to be by its supporters. _"Restless
acquisition,"_ he argued, _"does not let us take breath, take a calm
**enjoyment**: we do not get the comfort of our possessions."_ Communism, by
the _"organisation of labour,"_ can _"bear its fruit"_ so that _"we come to an
agreement about **human** labours, that they may not, as under competition,
claim all our time and toil."_ However, communism _"is silent"_ over _"for
whom is time to be gained."_ He, in contrast, stresses that it is for the
individual, _"To take comfort in himself as the unique."_ [**The Ego and Its
Own**, p. 265 and pp. 268-9] Thus state socialism does not recognise that the
purpose of association is to free the individual and instead subjects the
individual to a new tyranny:

> _"it is not another State (such as a 'people's State') that men aim at, but
their **union,** uniting, this ever-fluid uniting of everything standing - A
State exists even without my co-operation . . . the independent establishment
of the State founds my lack of independence; its condition as a 'natural
growth,' its organism, demands that my nature do not grow freely, but be cut
to fit it."_ [**Op. Cit.**, p. 224]

Similarly, Stirner argued that _"Communism, by the abolition of all personal
property, only presses me back still more into dependence on another, to wit,
on the generality or collectivity"_ which is _"a condition hindering my free
movement, a sovereign power over me. Communism rightly revolts against the
pressure that I experience from individual proprietors; but still more
horrible is the might that it puts in the hands of the collectivity."_ [**Op.
Cit.**, p. 257] History has definitely confirmed this fear. By nationalising
property, the various state socialist regimes turned the worker from a servant
of the capitalist into a serf of the state. In contrast, communist-anarchists
argue for free association and workers' self-management as the means of
ensuring that socialised property does not turn into the denial of freedom
rather than as a means of ensuring it. As such, Stirner's attack on what Marx
termed _"vulgar communism"_ is still important and finds echoes in communist-
anarchist writings as well as the best works of Marx and his more libertarian
followers (see [section I.4](secI4.html) on how libertarian communism is not
_"silent"_ on these matters and incorporates Stirner's legitimate concerns and
arguments).

Similar arguments to Stirner's can be found in Proudhon's works against the
various schemes of state socialism that existed in France in the middle of the
nineteenth century. He particularly attacked the ideas of Louis Blanc. Blanc,
whose most famous book was **Organisation du Travail** (**Organisation of
Work**, first published in 1840) argued that social ills resulted from
competition and they could be solved by means of eliminating it via government
initiated and financed reforms. More specifically, Blanc argued that it was
_"necessary to use the whole power of the state"_ to ensure the creation and
success of workers' associations (or _"social workshops"_). Since that _"which
the proletarians lack to free themselves are the tools of labour,"_ the
government _"must furnish them"_ with these. _"The state,"_ in short, _"should
place itself resolutely at the head of industry."_ [quoted by K. Steven
Vincent, **Pierre-Joseph Proudhon and the Rise of French Republican
Socialism**, p. 139] Capitalists would be encouraged to invest money in these
workshops, for which they would be guaranteed interest payments but the
workers would keep the remaining profits generated by the workshops. Such
state-initiated workshops would soon prove to be more efficient than privately
owned industry and, by charging lower prices, force privately owned industry
either out of business or to change into social workshops, so eliminating
competition.

Proudhon objected to this scheme on many levels. He argued that Blanc's scheme
appealed _"to the state for its silent partnership; that is, he gets down on
his knees before the capitalists and recognises the sovereignty of monopoly."_
Given that Proudhon saw the state as an instrument of the capitalist class,
asking that state to abolish capitalism was illogical and impossible.
Moreover, by getting the funds for the "social workshop" from capitalists,
Blanc's scheme was hardly undermining their power. _"Capital and power,"_
Proudhon argued, _"secondary organs of society, are always the gods whom
socialism adores; if capital and power did not exist, it would invent them."_
[**Property is Theft!**, p. 215 and p. 217] He stressed the authoritarian
nature of Blanc's scheme:

> _"M. Blanc is never tired of appealing to authority, and socialism loudly
declares itself anarchistic; M. Blanc places power above society, and
socialism tends to subordinate it to society; M. Blanc makes social life
descend from above, and socialism maintains that it springs up and grows from
below; M. Blanc runs after politics, and socialism is in quest of science. No
more hypocrisy, let me say to M. Blanc: you desire neither Catholicism nor
monarchy nor nobility, but you must have a God, a religion, a dictatorship, a
censorship, a hierarchy, distinctions, and ranks. For my part, I deny your
God, your authority, your sovereignty, your judicial State, and all your
representative mystifications."_ [**Op. Cit.**, p. 205]

Equally, Proudhon opposed the "top-down" nature of Blanc's ideas. As it was
run by the state, the system of workshops would hardly be libertarian as
_"hierarchy would result from the elective principle . . . as in
constitutional politics . . . Who will make the law? The government."_ Such a
regime, Proudhon argued, would be unlikely to function well and the net result
would be _"all reforms ending, now in hierarchical corporation, now in State
monopoly, or the tyranny of community."_ [**Op. Cit.**, p. 21 and p. 207] This
was because of the perspective of state socialists:

> _"As you cannot conceive of society without hierarchy, you have made
yourselves the apostles of authority; worshippers of power, you think only of
strengthening it and muzzling liberty; your favourite maxim is that the
welfare of the people must be achieved in spite of the people; instead of
proceeding to social reform by the extermination of power and politics, you
insist on a reconstruction of power and politics."_ [**Op. Cit.**, pp. 225-6]

Instead of reform from above, Proudhon stressed the need for working class
people to organise themselves for their own liberation. As he put it, the
_"problem before the labouring classes . . . [is] not in capturing, but in
subduing both power and monopoly, - that is, in generating from the bowels of
the people, from the depths of labour, a greater authority, a more potent
fact, which shall envelop capital and the state and subjugate them."_ For,
_"to combat and reduce power, to put it in its proper place in society, it is
of no use to change the holders of power or introduce some variation into its
workings: an agricultural and industrial combination must be found by means of
which power, today the ruler of society, shall become its slave."_ This was
because the state _"finds itself inevitably enchained to capital and directed
against the proletariat."_ Unsurprisingly, Proudhon stressed in 1848 that
_"the proletariat must emancipate itself without the help of the government."_
[**Op. Cit.**, pp. 225-6 and p. 306] In addition, by guaranteeing interest
payments, Blanc's scheme insured the continued exploitation of labour by
capital and, of course, while opposing capitalist competition, Proudhon did
not consider it wise to abolish all forms of the market.

Proudhon argued for a two-way approach to undermining capitalism from below:
the creation of workers associations and the organisation of credit. By
creating mutual banks, which provided credit at cost, workers could create
associations to compete with capitalist firms, drive them out of business and
so eliminate exploitation once and for all by workers' self-management. In
this way, the working class would emancipate itself from capitalism and build
a socialist society from below upwards by their own efforts and activities.
Proudhon, as Marxist Paul Thomas notes, _"believed fervently . . . in the
salvation of working men, by their own efforts, through economic and social
action alone . . . Proudhon advocated, and to a considerable extent inspired,
the undercutting of this terrain [of the state] from without by means of
autonomous working-class associations."_ [**Karl Marx and the Anarchists**,
pp. 177-8] Rejecting violent revolution (as well as strikes as counter-
productive), Proudhon argued for economic means to end economic exploitation
and, as such, he saw anarchism as coming about by reform (unlike later social
anarchists, who were generally revolutionaries and argued that capitalism
cannot be reformed away and so supported strikes and other forms of collective
working class direct action, struggle and combative organisation).

Unsurprisingly, Proudhon's ideas were shaped by the society he lived and
agitated in. In the mid-nineteenth century, the bulk of the French working
class were artisans and peasants and so such an approach reflected the social
context in which it was proposed. With a predominance of small-scale industry,
the notion of free credit provided by mutual banks as the means of securing
working class people access to the means of production is theoretically
feasible. It was this social context which informed Proudhon's ideas (see
[section H.2.3](secH2.html#sech23)). He never failed to stress that
association would be tyranny if imposed upon peasants and artisans (rather, he
thought that associations would be freely embraced by these workers if they
thought it was in their interests to do so). However, he did not ignore the
rise of large-scale industry and explicitly proposed workers' associations
(i.e., co-operatives) for those industries which objectively needed it (i.e.
capitalist industry) and for those other toilers who desired it. The net
effect was the same, though, namely to abolish wage labour.

It was this opposition to wage labour which drove Proudhon's critique of state
socialism. He continually stressed that state ownership of the means of
production was a danger to the liberty of the worker and simply the
continuation of capitalism with the state as the new boss. As he put it in
1848, he _"did not want to see the State confiscate the mines, canals and
railways; that would add to monarchy, and more wage slavery. We want the
mines, canals, railways handed over to democratically organised workers'
associations . . . these associations [will] be models for agriculture,
industry and trade, the pioneering core of that vast federation of companies
and societies woven into the common cloth of the democratic social Republic."_
He contrasted workers' associations run by and for their members to those
_"subsidised, commanded and directed by the State,"_ which would crush _"all
liberty and all wealth, precisely as the great limited companies are doing."_
[**No Gods, No Masters**, vol. 1, p. 62 and p. 105]

Marx, of course, had replied to Proudhon's work **System of Economic
Contradictions** with his **Poverty of Philosophy**. However, Marx's work
aroused little interest when published although Proudhon did carefully read
and annotate his copy of it, claiming it to be _"a libel"_ and a _"tissue of
abuse, calumny, falsification and plagiarism"_ (he even called Marx _"the
tapeworm of Socialism."_) [quoted by Woodcock, **Op. Cit.**, p. 102] Sadly,
Proudhon did not reply publicly to Marx's work due to an acute family crisis
and then the start of the 1848 revolution in France. However, given his views
of Louis Blanc and other socialists who saw socialism being introduced after
the seizing of state power, he would hardly have been supportive of Marx's
ideas.

So while none of Proudhon's and Stirner's arguments were directly aimed at
Marxism, their critiques are applicable to much of mainstream Marxism as this
inherited many of the ideas of the state socialism they attacked. Much of
their analysis was incorporated in the collectivist and communist ideas of the
anarchists that followed them (some directly, as from Proudhon, some by co-
incidence as Stirner's work was quickly forgotten and only had an impact on
the anarchist movement when he was rediscovered in the 1890s). This can be
seen from the fact that Proudhon's ideas on the management of production by
workers' associations, opposition to nationalisation as state-capitalism and
the need for action from below by working people themselves, all found their
place in communist-anarchism and anarcho-syndicalism and in their critique of
mainstream Marxism (such as social democracy) and Leninism. Echoes of these
critiques can be found Bakunin's comments of 1868:

> _"I hate Communism because it is the negation of liberty and because for me
humanity is unthinkable without liberty. I am not a Communist, because
Communism concentrates and swallows up in itself for the benefit of the State
all the forces of society, because it inevitably leads to the concentration of
property in the hands of the State . . . I want to see society and collective
or social property organised from below upwards, by way of free associations,
not from above downwards, by means of any kind of authority whatsoever . . .
That is the sense in which I am a Collectivist and not a Communist."_ [quoted
by K.J. Kenafick, **Michael Bakunin and Karl Marx**, pp. 67-8]

It is with Bakunin that Marxism and Anarchism came into direct conflict as it
was Bakunin who lead the struggle against Marx in the **International
Workingmen's Association** between 1868 and 1872. It was in these exchanges
that the two schools of socialism (the libertarian and the authoritarian)
clarified themselves. With Bakunin, the anarchist critique of Marxism (and
state socialism in general) starts to reach its mature form. We discuss
Bakunin's critique in the [next section](secH1.html#sech11).

## H.1.1 What was Bakunin's critique of Marxism?

Bakunin and Marx famously clashed in the first **International Working Men's
Association** between 1868 and 1872. This conflict helped clarify the
anarchist opposition to the ideas of Marxism and can be considered as the
first major theoretical analysis and critique of Marxism by anarchists. Later
critiques followed, of course, particularly after the degeneration of Social
Democracy into reformism and the failure of the Russian Revolution (both of
which allowed the theoretical critiques to be enriched by empirical evidence)
but the Bakunin/Marx conflict laid the ground for what came after. As such, an
overview of Bakunin's critique is essential as anarchists continued to develop
and expand upon it (particularly after the experiences of actual Marxist
movements and revolutions confirmed it).

First, however, we must stress that Marx and Bakunin had many similar ideas.
They both stressed the need for working people to organise themselves to
overthrow capitalism by a social revolution. They argued for collective
ownership of the means of production. They both constantly stressed that the
emancipation of the workers must be the task of the workers themselves. They
differed, of course, in exactly how these common points should be implemented
in practice. Both, moreover, had a tendency to misrepresent the opinions of
the other on certain issues (particularly as their struggle reached its
climax). Anarchists, unsurprisingly, argue Bakunin has been proved right by
history, so confirming the key aspects of his critique of Marx.

So what was Bakunin's critique of Marxism? There are six main areas. Firstly,
there is the question of current activity (i.e. whether the workers' movement
should participate in "politics" and the nature of revolutionary working class
organisation). Secondly, there is the issue of the form of the revolution
(i.e. whether it should be a political **then** an economic one, or whether it
should be both at the same time). Thirdly, there is the prediction that state
socialism will be exploitative, replacing the capitalist class with the state
bureaucracy. Fourthly, there is the issue of the "dictatorship of the
proletariat." Fifthly, there is the question of whether political power
**can** be seized by the working class as a whole or whether it can only be
exercised by a small minority. Sixthly, there was the issue of whether the
revolution be centralised or decentralised in nature. We shall discuss each in
turn.

On the issue of current struggle, the differences between Marx and Bakunin are
clear. For Marx, the proletariat had to take part in bourgeois elections as an
organised political party. As the resolution of the (gerrymandered) Hague
Congress of First International put it: _"In its struggle against the
collective power of the propertied classes the proletariat cannot act as a
class except by constituting itself a political party, distinct from and
opposed to, all old parties formed by the propertied classes . . . The
conquest of political power has therefore become the great duty of the working
class."_ [**Collected Works**, vol. 23, p. 243]

This political party must stand for elections and win votes. As Marx argued in
the preamble of the French Workers' Party, the workers must turn the franchise
_"from a means of deception . . . into an instrument of emancipation."_ This
can be considered as part of the process outlined in the **Communist
Manifesto**, where it was argued that the _"immediate aim of the Communists is
the same as that of all the other proletarian parties,"_ namely the _"conquest
of political power by the proletariat,"_ the _"first step in the revolution by
the working class"_ being _"to raise the proletariat to the position of ruling
class, to win the battle of democracy."_ Engels later stressed (in 1895) that
the _"**Communist Manifesto** had already proclaimed the winning of universal
suffrage, of democracy, as one of the first and most important tasks of the
militant proletariat"_ and that German Social Democracy had showed workers of
all countries _"how to make use of universal suffrage."_ [**Marx and Engels
Reader**, p. 566, p. 484, p. 490 and p. 565]

With this analysis in mind, Marxist influenced political parties have
consistently argued for and taken part in election campaigns, seeking office
as a means of spreading socialist ideas and as a means of pursuing the
socialist revolution. The Social Democratic parties which were the first
Marxist parties (and which developed under the watchful eyes of Marx and
Engels) saw revolution in terms of winning a majority within Parliamentary
elections and using this political power to abolish capitalism (once this was
done, the state would "wither away" as classes would no longer exist). In
effect, as we discuss in [section H.3.10](secH3.html#sech310), these parties
aimed to reproduce Marx's account of the forming of the Paris Commune on the
level of the national Parliament.

Bakunin, in contrast, argued that while the communists _"imagine they can
attain their goal by the development and organisation of the political power
of the working classes . . . aided by bourgeois radicalism"_ anarchists
_"believe they can succeed only through the development and organisation of
the non-political or anti-political power of the working classes."_ The
Communists _"believe it necessary to organise the workers' forces in order to
seize the political power of the State,"_ while anarchists _"organise for the
purpose of destroying it."_ Bakunin saw this in terms of creating new organs
of working class power in opposition to the state, organised _"from the bottom
up, by the free association or federation of workers, starting with the
associations, then going on to the communes, the region, the nations, and,
finally, culminating in a great international and universal federation."_ In
other words, a system of workers' councils. As such, he constantly argued for
workers, peasants and artisans to organise into unions and join the
**International Workingmen's Association**, so becoming _"a real force . . .
which knows what to do and is therefore capable of guiding the revolution in
the direction marked out by the aspirations of the people: a serious
international organisation of workers' associations of all lands capable of
replacing this departing world of **states.**"_ [**Bakunin on Anarchism**, pp.
262-3, p. 270 and p. 174] To Marx's argument that workers should organise
politically (i.e., send their representations to Parliament) Bakunin realised
that when _"common workers"_ are sent _"to Legislative Assemblies"_ the result
is that the _"worker-deputies, transplanted into a bourgeois environment, into
an atmosphere of purely bourgeois ideas, will in fact cease to be workers and,
becoming Statesmen, they will become bourgeois . . . For men do not make their
situations; on the contrary, men are made by them."_ [**The Basic Bakunin**,
p. 108]

As far as history goes, the experience of Social Democracy confirmed Bakunin's
analysis. A few years after Engels death in 1895, German Social Democracy was
racked by the "revisionism" debate. This debate did not spring from the minds
of a few leaders, isolated from the movement, but rather expressed
developments **within** the movement itself. In effect, the revisionists
wanted to adjust the party rhetoric to what the party was actually doing and
so the battle against the revisionists basically represented a battle between
what the party **said** it was doing and its actual practice. As one of the
most distinguished historians of this period put it, the _"distinction between
the contenders remained largely a subjective one, a difference of ideas in the
evaluation of reality rather than a difference in the realm of action."_ [C.
Schorske, **German Social Democracy**, p. 38] By the start of the First World
War, the Social Democrats had become so corrupted by their activities in
bourgeois institutions they supported its state (and ruling class) and voted
for war credits rather than denounce the war as Imperialist slaughter for
profits. Clearly, Bakunin was proved right. (see also [section
J.2.6](secJ2.html#secj26) for more discussion on the effect of electioneering
on radical parties).

However, we must stress that because Bakunin rejected participating in
bourgeois politics, it did not mean that he rejected "politics" or "political
struggle" in general (see [section J.2.10](secJ2.html#secj210)). Bakunin
clearly advocated what would later be termed a syndicalist strategy (see
[section H.2.8](secH2.html#sech28)). This union movement would be complemented
by a specific anarchist organisation which would work within it to influence
it towards anarchist aims by the _"natural influence"_ of its members (see
[section J.3.7](secJ3.html#secj37)).

Comparing Bakunin and Marx, it is clear whom history has validated. Even that
anti-anarchist Stalinist hack Eric Hobsbawn could not avoid admitting _"the
remarkable achievement of Spanish anarchism which was to create a working-
class movement that remained genuinely revolutionary. Social democratic and .
. . even communist trade unions have rarely been able to escape either
schizophrenia [i.e., revolutionary rhetoric hiding reformist practice] or
betrayal of their socialist convictions."_ [**Revolutionaries**, p. 104] This
is probably the only accurate comment made in his various diatribes on
anarchism but, of course, he did not allow the implications of his statement
to bother his faith in Leninist ideology. So given the long history of
reformism and betrayal of socialist principles by radicals utilising elections
and political parties, it comes as no surprise that anarchists consider both
Bakunin's critique and alternative to be confirmed by experience ([section
J.2](secJ2.html) discusses direct action and electioneering).

Which brings us to the second issue, namely the nature of the revolution
itself. For Bakunin, a revolution meant a **social** revolution from below.
This involved both the abolition of the state **and** the expropriation of
capital. In his words, _"the revolution must set out from the first radically
and totally to destroy the State."_ The _"natural and necessary consequences"_
of which will be the _"confiscation of all productive capital and means of
production on behalf of workers' associations, who are to put them to
collective use . . . the federative Alliance of all working men's associations
. . . will constitute the Commune."_ There _"can no longer be any successful
political . . . revolution unless the political revolution is transformed into
social revolution."_ [**Michael Bakunin: Selected Writings**, p. 170 and p.
171]

Which, incidentally, disproves Engels' claims that Bakunin _"does not regard
capital . . . but the **state** as the main evil to be abolished"_ after which
_"capitalism will go to blazes of itself."_ [**The Marx-Engels Reader**, p.
728] This misrepresents Bakunin's position, as he always stressed that
economic and political transformation _"must be accomplished together and
simultaneously."_ [**The Basic Bakunin**, p. 106] Given that Bakunin thought
the state was the protector of capitalism, no economic change could be
achieved until such time as it was abolished. This also meant that Bakunin
considered a political revolution before an economic one to mean the continued
slavery of the workers. As he argued, _"[t]o win political freedom first can
signify no other thing but to win this freedom only, leaving for the first
days at least economic and social relations in the same old state, - that is,
leaving the proprietors and capitalists with their insolent wealth, and the
workers with their poverty."_ With capitalists' economic power intact, could
the workers' **political** power remain strong? As such, _"every political
revolution taking place prior to and consequently without a social revolution
must necessarily be a bourgeois revolution, and a bourgeois revolution can
only be instrumental in bringing about bourgeois Socialism - that is, it is
bound to end in a new, more hypocritical and more skilful, but no less
oppressive, exploitation of the proletariat by the bourgeois."_ [**The
Political Philosophy of Bakunin**, p. 294 and p. 289]

Did Marx and Engels hold this position? Apparently so. Discussing the Paris
Commune, Marx noted that it was _"the political form at last discovered under
which to work out the economic emancipation of labour,"_ and as the
_"political rule of the producer cannot coexist with the perpetuation of his
social slavery"_ the Commune was to _"serve as a lever for uprooting the
economic foundations upon which rests the existence of classes."_ Engels
argued that the _"proletariat seizes the public power, and by means of this
transforms the . . . means of production . . . into public property."_ In the
**Communist Manifesto** they argued that _"the first step in the revolution by
the working class"_ is _"rais[ing] the proletariat to the position of ruling
class, to win the battle of democracy."_ The proletariat _"will use its
political supremacy to wrest, by degrees, all capital from the bourgeois, to
centralise all instruments of production in the hands of the State, i.e. of
the proletariat organised as the ruling class."_ [**Op. Cit.**, p. 635, p. 717
and p. 490]

This is made even clearer in Engels' _"Principles of Communism"_ (often
considered as a draft of the **Manifesto**). That document stressed that it
was not possible for _"private property to be abolished at one stroke"_,
arguing that _"the proletarian revolution will transform existing society
gradually."_ The revolution _"will establish a **democratic constitution**,
and through this, the direct or indirect dominance of the proletariat. Direct
in England, where the proletarians are already a majority of the people."_
_"Democracy"_, Engels went on, _"would be quite useless to the proletariat if
it were not immediately used as a means of carrying through further measures
directly attacking private ownership."_ [**Collected Works**, vol. 6, p. 350]
Decades later, when Marx discussed what the "dictatorship of the proletariat"
meant, he argued (in reply to Bakunin's question of _"over whom will the
proletariat rule?"_) that it simply meant _"that so long as other classes
continue to exist, the capitalist class in particular, the proletariat fights
it (for with the coming of the proletariat to power, its enemies will not yet
have disappeared), it must use measures of **force**, hence governmental
measures; if it itself still remains a class and the economic conditions on
which the class struggle and the existence of classes have not yet
disappeared, they must be forcibly removed or transformed, and the process of
their transformation must be forcibly accelerated."_ [**The Marx-Engels
Reader**, pp. 542-3] Note, "capitalists," not "former capitalists," so
implying that the members of the proletariat are, in fact, still proletarians
after the "socialist" revolution and so still subject to wage slavery under
economic masters. Which makes perfect sense, as otherwise the term
_"dictatorship of the proletariat"_ would be meaningless.

Then there is the issue of when the working class could seize political power.
As Engels put it, the conflict _"between bourgeoisie and proletariat can only
be fought out in a republic"_ as this is _"the form in which the struggle must
be fought out."_ Workers would have to create a republic in countries without
one (such as Germany at the time). [Marx and Engels, **The Socialist
Revolution**, p. 264] Decades previously, Engels had argued that the _"first,
fundamental condition for the introduction of community of property is the
political liberation of the proletariat through a democratic constitution."_
[**Collected Works**, vol. 6, p. 102] Thus the bourgeois revolution would come
first, then the proletarian one. The **Communist Manifesto** had raised the
possibility of a bourgeois revolution in Germany being _"but a prelude to an
immediately following proletarian revolution."_ [**Selected Writings**, p. 63]
Within two years, Marx and Engels argued that this was wrong, that a socialist
revolution was not possible in Continental Europe for some time. Even in the
1880s, Engels was still arguing that a proletarian revolution was not
immediately possible in Germany and the first results of any revolution would
be a bourgeois republic within which the task of social democracy was to build
its forces and influence.

Clearly, then, Marx and Engels considered the creation of a republic in a well
developed capitalist economy as the basis for seizing of state power as the
key event and, later, the expropriation of the expropriators would occur. Thus
the economic power of the capitalists would remain, with the proletariat
utilising political power to combat and reduce it. Anarchists argue that if
the proletariat does not hold economic power, its political power would at
best be insecure and would in fact degenerate. Would the capitalists just sit
and wait while their economic power was gradually eliminated by political
action? And what of the proletariat during this period? Will they patiently
obey their bosses, continue to be oppressed and exploited by them until such
time as the end of their "social slavery" has been worked out (and by whom)?
Would they be happy to fight for a bourgeois republic first, then wait for an
unspecified period of time before the party leadership proclaimed that the
time was ripe to introduce socialism?

As the experience of the Russian Revolution showed, the position of Marx and
Engels proved to be untenable. Bakunin's perspective was repeated by a Russian
worker in 1906 when he expressed his impatience with Menshevik strategy:

> _"Here [the Mensheviks] . . . tells us that the workers' congress is the
best means of assuring the independence of the proletariat in the bourgeois
revolution; otherwise, we workers will play the role of cannon fodder in it.
So I ask: what is the insurance for? Will we really make the bourgeois
revolution? Is it possible that we will spill blood twice - once for the
victory of the bourgeois revolution, and the time for the victory of our
proletarian revolution? No, comrades, it is not to be found in the party
programme [that this must be so]; but if we workers are to spill blood, then
only once, for freedom and socialism."_ [quoted by Abraham Ascher, **The
Mensheviks in the Russian Revolution**, p. 43]

In 1917, this lesson was well learned and the Russian workers initially
followed Bakunin's path (mostly spontaneously and without significant
influence by anarchists and anarcho-syndicalists). The Mensheviks repeated
their mistakes of 1905 as they _"proved unable to harness this revolutionary
potential to any practical purpose. They were blinded by their rigid marxist
formula of 'bourgeois revolution first, socialist revolution later' and tried
to restrain the masses. They preached self-abnegation to them, told them to
stand aside until such times as the bourgeoisie had built a solid capitalist
system. This made no sense to workers and peasants - why should they renounce
the power that was in their hands already?"_ Leading Menshevik Fedor Dan
_"admitted in 1946 that the Menshevik concept of the bourgeois revolution
rested on 'illusions'"_ [Vera Broido, **Lenin and the Mensheviks**, p 14 and
p. 15] Once Lenin returned to Russia, the Bolsheviks broke with this
previously shared perspective and started to support and encourage the
radicalisation of the workers and so managed to gain popular support. However,
they did so partially and incompletely and, as a consequence, finally held
back and so fatally undermined the revolution.

After the February revolution paralysed the state, the workers organised
factory committees and raised the idea and practice of workers self-management
of production. The Russian anarchists supported this movement whole-heartedly,
arguing that it should be pushed as far as it would go. In contrast, Lenin
argued for _"workers' control over the capitalists."_ [**The Lenin
Anthology**, p. 402] This was, unsurprisingly, the policy applied immediately
after the Bolshevik seizure of power. However, as one Leninist writer admits,
_"[t]wo overwhelmingly powerful forces obliged the Bolsheviks to abandon this
'reformist' course."_ One was the start of the civil war, the other _"was the
fact that the capitalists used their remaining power to make the system
unworkable. At the end of 1917 the All Russian Congress of employers declared
that those 'factories in which the control is exercised by means of active
interference in the administration will be closed.' The workers' natural
response to the wave of lockouts which followed was to demand that their
[sic!] state nationalise the factories."_ [John Rees, _"In Defence of
October"_, pp. 3-82, **International Socialism**, no. 52, p. 42] By July 1918,
only one-fifth of nationalised firms had been done so by the state, the rest
by local committees from below (which, incidentally, shows the
unresponsiveness of centralised power). Clearly, the idea that a social
revolution can come after a political was shown to be a failure - the
capitalist class used its powers to disrupt the economic life of Russia.

Faced with the predictable opposition by capitalists to their system of
"control" the Bolsheviks nationalised the means of production. Sadly,
**within** the nationalised workplace the situation of the worker remained
essentially unchanged. Lenin had been arguing for one-man management
(appointed from above and armed with "dictatorial" powers) since late April
1918 (see [section H.3.14](secH3.html#sech314)). This aimed at replacing the
capitalists with state appointed managers, **not** workers self-management. In
fact, as we discuss in [section H.6.2](secH6.html#sech62) the party leaders
repeatedly overruled the factory committees' suggestions to build socialism
based on their management of the economy in favour of centralised state
control. Bakunin's fear of what would happen if a political revolution
preceded a social one came true. The working class continued to be exploited
and oppressed as before, first by the bourgeoisie and then by the new
bourgeoisie of state appointed managers armed with all the powers of the old
ones (plus a few more). Russia confirmed Bakunin's analysis that a revolution
must immediately combine political and economic goals in order for it to be
successful.

The experience of Bolshevik Russia also confirms Bakunin's prediction that
state socialism would simply be state capitalism. As Bakunin stressed, the
state _"is the government from above downwards of an immense number of men
[and women], very different from the point of view of the degree of their
culture, the nature of the countries or localities that they inhabit, the
occupations they follow, the interests and aspirations directing them - the
State is the government of all these by one or another minority."_ The state
_"has always been the patrimony of some privileged class"_ and _"when all
other classes have exhausted themselves"_ it _"becomes the patrimony of the
bureaucratic class."_ The Marxist state _"will not content itself with
administering and governing the masses politically"_ it will _"also administer
the masses economically, concentrating in the hands of the State the
production and distribution of wealth."_ This will result in _"a new class, a
new hierarchy of real and counterfeit scientists and scholars, and the world
will be divided into a minority ruling in the name of knowledge, and an
immense ignorant majority. And then, woe unto the mass of ignorant ones!"_
Thus exploitation by a new bureaucratic class would be the only result when
the state becomes _"the sole proprietor"_ and _"the only banker, capitalist,
organiser, and director of all national labour, and the distributor of all its
products."_ [**Bakunin on Anarchism**, pp. 317-8, p. 318 and p. 217]
Subsequent anarchists have tended to call such a regime **state capitalism**
(see [section H.3.13](secH3.html#sech313)).

The Bolshevik leadership's rejection of the factory committees and their
vision of socialism also confirmed Bakunin's fear that Marxism urges the
people _"not only not abolish the State, but, on the contrary, they must
strengthen it and enlarge it, and turn it over to . . . the leaders of the
Communist party . . . who will then liberate them in their own way."_ The
economic regime imposed by the Bolsheviks, likewise, confirmed Bakunin
critique as the state _"control[led] all the commerce, industry, agriculture,
and even science. The mass of the people will be divided into two armies, the
agricultural and the industrial under the direct command of the state
engineers, who will constitute the new privileged political-scientific
class."_ Unsurprisingly, this new state-run economy was a disaster which,
again, confirmed his warning that unless this minority _"were endowed with
omniscience, omnipresence, and the omnipotence which the theologians attribute
to God, [it] could not possibly know and foresee the needs of its people, or
satisfy with an even justice those needs which are most legitimate and
pressing."_ [**Op. Cit.**, p. 332, pp. 332-3 and p. 318]

Which brings us to the "dictatorship of the proletariat." While many Marxists
basically use this term to describe the defence of the revolution and so argue
that anarchists do not see the need for that, this is incorrect. Anarchists
from Bakunin onwards have argued that a revolution would have to defend itself
from counter revolution and yet we reject the concept totally (see [section
H.2.1](secH2.html#sech21) for a refutation of claims that anarchists think a
revolution does not need defending). To understand why Bakunin rejected the
concept, we must provide some historical context.

Anarchists in the nineteenth century rejected the idea of the "dictatorship of
the proletariat" in part because the proletariat was a **minority** of working
class people at the time. To argue for a dictatorship of the proletariat meant
to argue for the dictatorship of a **minority** class, a class which excluded
the majority of toiling people. When Marx and Engels wrote the **Communist
Manifesto**, for example, over 80% of the population of France and Germany
were peasants or artisans - what they termed the "petit-bourgeois". This meant
that their claim that the _"proletarian movement is the self-conscious,
independent movement of the immense majority, in the interests of the immense
majority"_ was simply not true. Rather, for Marx's life-time (and for many
decades afterwards) the proletarian movement was like _"[a]ll previous
movements,"_ namely _"movements of minorities, or in the interests of
minorities."_ Not that Marx and Engels were unaware of this for they also
noted that _"[i]n countries like France"_ the peasants _"constitute far more
than half of the population."_ In 1875 Marx commented that _"the majority of
the 'toiling people' in Germany consists of peasants, and not of
proletarians."_ He stressed elsewhere around the same time that _"the peasant
. . . forms a more of less considerable majority . . . in the countries of the
West European continent."_ [**The Marx-Engels Reader**, p. 482, p. 493, p. 536
and p. 543]

Clearly, then, Marx and Engels vision of proletarian revolution was one which
involved a minority dictating to the majority and so Bakunin rejected it. His
opposition rested on the fact that a "dictatorship of the proletariat," at the
time, actually meant a dictatorship by a **minority** of working people and so
a "revolution" which excluded the majority of working people (i.e. artisans
and peasants). As he argued in 1873:

> _"If the proletariat is to be the ruling class . . . then whom will it rule?
There must be yet another proletariat which will be subject to this new rule,
this new state. It may be the peasant rabble . . . which, finding itself on a
lower cultural level, will probably be governed by the urban and factory
proletariat."_ [**Statism and Anarchy**, pp. 177-8]

For Bakunin, to advocate the "dictatorship of the proletariat" in an
environment where the vast majority of working people were peasants would be a
disaster. It is only when we understand this social context that we can
understand Bakunin's opposition to Marx's "dictatorship of the proletariat" -
it would be a dictatorship of a minority class over the rest of the working
population (he took it as a truism that the capitalist and landlord classes
should be expropriated and stopped from destroying the revolution!). Bakunin
continually stressed the need for a movement and revolution of **all** working
class people (see [section H.2.7](secH2.html#sech27)) and that the peasants
_"will join cause with the city workers as soon as they become convinced that
the latter do not pretend to impose their will or some political or social
order invented by the cities for the greater happiness of the villages; they
will join cause as soon as they are assured that the industrial workers will
not take their lands away."_ For an _"uprising by the proletariat alone would
not be enough; with that we would have only a political revolution which would
necessarily produce a natural and legitimate reaction on the part of the
peasants, and that reaction, or merely the indifference of the peasants, would
strangle the revolution of the cities."_ [**The Political Philosophy of
Bakunin**, p. 401 and p. 378]

This explains why the anarchists at the St. Imier Congress argued that _"every
political state can be nothing but organised domination for the benefit of one
class, to the detriment of the masses, and that should the proletariat itself
seize power, it would in turn become a new dominating and exploiting class."_
As the proletariat was a minority class at the time, their concerns can be
understood. For anarchists then and now, a social revolution has to be truly
popular and involve the majority of the population in order to succeed.
Unsurprisingly, the congress stressed the role of the proletariat in the
struggle for socialism, arguing that _"the proletariat of all lands . . . must
create the solidarity of revolutionary action . . . independently of and in
opposition to all forms of bourgeois politics."_ Moreover, the aim of the
workers' movement was _"free organisations and federations . . . created by
the spontaneous action of the proletariat itself, [that is, by] the trade
bodies and the autonomous communes."_ [quoted in **Bakunin on Anarchism**, p.
438, p. 439 and p. 438]

Hence Bakunin's comment that _"the designation of the proletariat, the world
of the workers, as **class** rather than as **mass**"_ was _"deeply
antipathetic to us revolutionary anarchists who unconditionally advocate full
popular emancipation."_ To do so, he argued, meant _"[n]othing more or less
than a new aristocracy, that of the urban and industrial workers, to the
exclusion of the millions who make up the rural proletariat and who . . . will
in effect become subjects of this great so-called popular State."_ [**Michael
Bakunin: Selected Writings**, pp. 253-4]

Again, the experiences of the Russian Revolution confirm Bakunin's worries.
The Bolsheviks implemented the dictatorship of the city over the countryside,
with disastrous results (see [section H.6.2](secH6.html#sech62) for more
details).

One last point on this subject. While anarchists reject the "dictatorship of
the proletariat" we clearly do not reject the key role the proletariat must
play in any social revolution (see [section H.2.2](secH2.html#sech22) on why
the Marxist assertion anarchists reject class struggle is false). We only
reject the idea that the proletariat must dictate over other working people
like peasants and artisans. We do not reject the need for working class people
to defend a revolution, nor the need for them to expropriate the capitalist
class nor for them to manage their own activities and so society.

Then there is the issue of whether, even if the proletariat **does** seize
political power, whether the whole class can actually exercise it. Bakunin
raised the obvious questions:

> _"For, even from the standpoint of that urban proletariat who are supposed
to reap the sole reward of the seizure of political power, surely it is
obvious that this power will never be anything but a sham? It is bound to be
impossible for a few thousand, let alone tens or hundreds of thousands of men
to wield that power effectively. It will have to be exercised by proxy, which
means entrusting it to a group of men elected to represent and govern them,
which in turn will unfailingly return them to all the deceit and subservience
of representative or bourgeois rule. After a brief flash of liberty or
orgiastic revolution, the citizens of the new State will wake up slaves,
puppets and victims of a new group of ambitious men."_ [**Op. Cit.**, pp.
254-5]

He repeated this argument: _"What does it mean, 'the proletariat raised to a
governing class?' Will the entire proletariat head the government? The Germans
number about 40 million. Will all 40 millions be members of the government?
The entire nation will rule, but no one will be ruled. Then there will be no
government, no state; but if there is a state, there will also be those who
are ruled, there will be slaves."_ Bakunin argued that Marxism resolves this
dilemma _"in a simple fashion. By popular government they mean government of
the people by a small number of representatives elected by the people. So-
called popular representatives and rulers of the state elected by the entire
nation on the basis of universal suffrage - the last word of the Marxists, as
well as the democratic school - is a lie behind which the despotism of a
ruling minority is concealed, a lie all the more dangerous in that it
represents itself as the expression of a sham popular will."_ [**Statism and
Anarchy**, p. 178]

So where does Marx stand on this question. Clearly, the self-proclaimed
followers of Marx support the idea of "socialist" governments (indeed, many,
including Lenin and Trotsky, went so far as to argue that party dictatorship
was essential for the success of a revolution - see [next
section](secH1.html#sech12)). Marx, however, is less clear. He argued, in
reply to Bakunin's question if all Germans would be members of the government,
that _"[c]ertainly, because the thing starts with the self-government of the
township."_ However, he also commented that _"[c]an it really be that in a
trade union, for example, the entire union forms its executive committee,"_
suggesting that there **will** be a division of labour between those who
govern and those who obey in the Marxist system of socialism. [**The Marx-
Engels Reader**, p. 545 and p. 544] Elsewhere he talks about _"a socialist
government"_ coming _"to the helm in a country"_. [**Collected Works**, vol.
46, p. 66] As we discuss in [section H.3.10](secH3.html#sech310), both Marx
and Engels saw universal suffrage in a republic as expressing the political
power of the working class.

So Bakunin's critique holds, as Marx clearly saw the "dictatorship of the
proletariat" involving a socialist government having power. For Bakunin, like
all anarchists, if a political party is the government, then clearly its
leaders are in power, not the mass of working people they claim to represent.
Anarchists have, from the beginning, argued that Marx made a grave mistake
confusing working class power with the state. This is because the state is the
means by which the management of people's affairs is taken from them and
placed into the hands of a few. It signifies **delegated** power**.** As such,
the so-called "workers' state" or "dictatorship of the proletariat" is a
contradiction in terms. Instead of signifying the power of the working class
to manage society it, in fact, signifies the opposite, namely the handing over
of that power to a few party leaders at the top of a centralised structure.
This is because _"all State rule, all governments being by their very nature
placed outside the people, must necessarily seek to subject it to customs and
purposes entirely foreign to it. We therefore declare ourselves to be foes . .
. of all State organisations as such, and believe that the people can be happy
and free, when, organised from below upwards by means of its own autonomous
and completely free associations, without the supervision of any guardians, it
will create its own life."_ [Bakunin, **Marxism, Freedom and the State**, p.
63] Hence Bakunin's constant arguments for a decentralised, federal system of
workers councils organised from the bottom-up. Again, the transformation of
the Bolshevik government into a dictatorship **over** the proletariat during
the early stages of the Russian Revolution supports Bakunin's critique of
Marxism.

Related to this issue is Bakunin's argument that Marxism created a privileged
position for socialist intellectuals in both the current social movement and
in the social revolution. This was because Marx stressed that his theory was a
"scientific socialism" and, Bakunin argued, that implied _"because thought,
theory and science, at least in our times, are in the possession of very few,
these few ought to be the leaders of social life"_ and they, not the masses,
should organise the revolution _"by the dictatorial powers of this learned
minority, which presumes to express the will of the people."_ This would be
_"nothing but a despotic control of the populace by a new and not at all
numerous aristocracy of real and pseudoscientists"_ and so there would _"be a
new [ruling] class, a new hierarchy of real and counterfeit scientists and
scholars, and the world will be divided into a minority ruling in the name of
knowledge, and an immense ignorant majority. And then, woe unto the mass of
ignorant ones!"_ Thus _"every state, even the pseudo-People's State concocted
by Mr. Marx, is in essence only a machine ruling the masses from above,
through a privileged minority of conceited intellectuals who imagine that they
know what the people need and want better than do the people themselves."_ The
Russian anarchist predicted that _"the organisation and the rule of the new
society by socialist savants"_ would be _"the worse of all despotic
governments!"_ [**Bakunin on Anarchism**, pp. 328-9, p. 331, p. 319, p. 338
and p. 295] History proved Bakunin right, with the Bolshevik regime being
precisely that. As we discuss in [section H.5](secH5.html), Lenin's
vanguardism did produce such a result, with the argument that the party
leadership knew the objective needs of working class people better than they
themselves did being used to justify party dictatorship and the strict
centralisation of social life in the hands of its leadership.

Which brings us to the last issue, namely whether the revolution will be
decentralised or centralised. For Marx, the issue is somewhat confused by his
support for the Paris Commune and its federalist programme (written, we must
note, by a follower of Proudhon). However, in 1850, Marx stood for extreme
centralisation of power, arguing that the workers _"must not only strive for a
single and indivisible German republic, but also within this republic for the
most determined centralisation of power in the hands of the state authority."_
He argued that in a nation like Germany _"where there are so many relics of
the Middle Ages to be abolished"_ it _"must under no circumstances be
permitted that every village, every town and every province should put a new
obstacle in the path of revolutionary activity, which can proceed with full
force from the centre."_ He stressed that _"[a]s in France in 1793 so today in
Germany it is the task of the really revolutionary party to carry through the
strictest centralisation."_ [**The Marx-Engels Reader**, pp. 509-10] Lenin
followed this aspect of Marx's ideas, arguing that _"Marx was a centralist"_
and applying this perspective both in the party and once in power [**The
Essential Works of Lenin**, p. 310]

Obviously, this issue dove-tails into the question of whether the whole class
exercises power under the "dictatorship of the proletariat." In a centralised
system, obviously, power **has to be** exercised by a few (as Marx's argument
in 1850 showed). Centralism, by its very nature excludes the possibility of
extensive participation in the decision making process. Moreover, the
decisions reached by such a body could not reflect the real needs of society.
In the words of Bakunin:

> _"What man, what group of individuals, no matter how great their genius,
would dare to think themselves able to embrace and understand the plethora of
interests, attitudes and activities so various in every country, every
province, locality and profession."_ [**Michael Bakunin: Selected Writings**,
p. 240]

He stressed that _"the revolution should be and should everywhere remain
independent of the central point, which must be its expression and product -
not its source, guide and cause . . . the awakening of all local passions and
the awakening of spontaneous life at all points, must be well developed in
order for the revolution to remain alive, real and powerful."_ Anarchists
reject centralisation because it destroys the mass participation a revolution
requires in order to succeed. Therefore we do _"not accept, even in the
process of revolutionary transition, either constituent assemblies,
provisional governments or so-called revolutionary dictatorships; because we
are convinced that revolution is only sincere, honest and real in the hands of
the masses, and that when it is concentrated in those of a few ruling
individuals it inevitably and immediately becomes reaction."_ Rather, the
revolution _"everywhere must be created by the people, and supreme control
must always belong to the people organised into a free federation of
agricultural and industrial associations . . . organised from the bottom
upwards by means of revolutionary delegation."_ [**Op. Cit.**, pp. 179-80, p.
237 and p. 172]

This, we must stress, does not imply isolation. Bakunin always emphasised the
importance of federal organisation to co-ordinate struggle and defence of the
revolution. As he put it, all revolutionary communes would need to federate in
order _"to organise the necessary common services and arrangements for
production and exchange, to establish the charter of equality, the basis of
all liberty - a charter utterly negative in character, defining what has to be
abolished for ever rather than the positive forms of local life which can be
created only by the living practice of each locality - and to organise common
defence against the enemies of the Revolution."_ [**Op. Cit.**, p. 179]

Ironically, it is a note by Engels to the 1885 edition of Marx's 1850 article
which shows the fallacy of the standard Marxist position on centralisation and
the validity of Bakunin's position. As Engels put it, _"this passage is based
on a misunderstanding"_ and it was now _"a well known fact that throughout the
whole [Great French] revolution . . . the whole administration of the
departments, arrondissements and communes consisted of authorities elected by
the respective constituents themselves, and that these authorities acted with
complete freedom within general state laws [and] that precisely this
provincial and local self-government . . . became the most powerful lever of
the revolution."_ [**The Marx-Engels Reader**, p. 510f] Marx's original
comments imply the imposition of freedom by the centre on a population not
desiring it (and how could the centre be representative of the majority in
such a case?). Moreover, how could a revolution be truly social if it was not
occurring in the grassroots across a country? Unsurprisingly, local autonomy
has played a key role in every real revolution.

As such, Bakunin has been proved right. Centralism has always killed a
revolution and, as he always argued, real socialism can only be worked from
below, by the people of every village, town, and city. The problems facing the
world or a revolution cannot be solved by a few people at the top issuing
decrees. They can only be solved by the active participation of the mass of
working class people, the kind of participation centralism and government by
their nature exclude.

Given Marx's support for the federal ideas of the Paris Commune, it can be
argued that Marxism is not committed to a policy of strict centralisation
(although Lenin, of course, argued that Marx **was** a firm supporter of
centralisation). What is true is, to quote Daniel Guérin, that Marx's comments
on the Commune differ _"noticeably from Marx's writings of before and after
1871"_ while Bakunin's were _"in fact quite consistent with the lines he
adopted in his earlier writings."_ [**No Gods, No Masters**, vol. 1, p. 167]
Indeed, as Bakunin himself noted, while the Marxists _"saw all their ideas
upset by the uprising"_ of the Commune, they _"found themselves compelled to
take their hats off to it. They went even further, and proclaimed that its
programme and purpose were their own, in face of the simplest logic and their
own true sentiments."_ This modification of ideas by Marx in the light of the
Commune was not limited just to federalism, he also praised its system of
mandating recallable delegates. This was a position which Bakunin had been
arguing for a number of years previously but which Marx had never advocated.
In 1868, for example, Bakunin was talking about a _"Revolutionary Communal
Council"_ composed of _"delegates . . . vested with plenary but accountable
and removable mandates."_ [**Michael Bakunin: Selected Writings**, p. 261 and
pp. 170-1] As such, the Paris Commune was a striking confirmation of Bakunin's
ideas on many levels, **not** Marx's (who adjusted his ideas to bring them in
line with Bakunin's!).

Since Bakunin, anarchists have deepened this critique of Marxism and, with the
experience of both Social-Democracy and Bolshevism, argue that he predicted
key failures in Marx's ideas. Given that his followers, particularly Lenin and
Trotsky, have emphasised (although, in many ways, changed them) the
centralisation and "socialist government" aspects of Marx's thoughts,
anarchists argue that Bakunin's critique is as relevant as ever. Real
socialism can only come from below.

For more on Bakunin's critique of Marxism, Mark Leier's excellent biography of
the Russian Anarchist (**Bakunin: The Creative Passion**) is worth consulting,
as is Brian Morris's **Bakunin: The Philosophy of Freedom**. John Clark has
two useful essays on this subject in his **The Anarchist Moment** while
Richard B. Saltman's **The Social and Political Thought of Michael Bakunin**
contains an excellent chapter on Bakunin and Marx. A good academic account can
be found in Alvin W. Gouldner's _"Marx's Last Battle: Bakunin and the First
International"_ (**Theory and Society**, Vol. 11, No. 6) which is a revised
and shortened version of a chapter of his **Against Fragmentation: the Origins
of Marxism and the Sociology of Intellectuals**. Obviously, though, Bakunin's
original writings should be the first starting point.

## H.1.2 What are the key differences between Anarchists and Marxists?

There are, of course, important similarities between anarchism and Marxism.
Both are socialist, oppose capitalism and the current state, support and
encourage working class organisation and action and see class struggle as the
means of creating a social revolution which will transform society into a new
one. However, the differences between these socialist theories are equally
important. In the words of Errico Malatesta:

> _"The important, fundamental dissension [between anarchists and Marxists] is
[that] . . . [Marxist] socialists are authoritarians, anarchists are
libertarians. _

> _"Socialists want power . . . and once in power wish to impose their
programme on the people. . . Anarchists instead maintain, that government
cannot be other than harmful, and by its very nature it defends either an
existing privileged class or creates a new one; and instead of inspiring to
take the place of the existing government anarchists seek to destroy every
organism which empowers some to impose their own ideas and interests on
others, for they want to free the way for development towards better forms of
human fellowship which will emerge from experience, by everyone being free
and, having, of course, the economic means to make freedom possible as well as
a reality."_ [**Errico Malatesta: His Life and Ideas**, p. 142]

The other differences derive from this fundamental one. So while there are
numerous ways in which anarchists and Marxists differ, their root lies in the
question of power. Socialists seek power (in the name of the working class and
usually hidden under rhetoric arguing that party and class power are the
same). Anarchists seek to destroy hierarchical power in all its forms and
ensure that everyone is free to manage their own affairs (both individually
and collectively). From this comes the differences on the nature of a
revolution, the way the working class movement should organise and the tactics
it should apply and so on. A short list of these differences would include the
question of the "dictatorship of the proletariat", the standing of
revolutionaries in elections, centralisation versus federalism, the role and
organisation of revolutionaries, whether socialism can only come _"from
below"_ or whether it is possible for it come _"from below"_ and _"from
above"_ and a host of others (i.e. some of the differences we indicated in the
[last section](secH1.html#sech11) during our discussion of Bakunin's critique
of Marxism). Indeed, there are so many it is difficult to address them all
here. As such, we can only concentrate on a few in this and the following
sections.

One of the key issues is on the issue of confusing party power with popular
power. The logic of the anarchist case is simple. In any system of
hierarchical and centralised power (for example, in a state or governmental
structure) then those at the top are in charge (i.e. are in positions of
power). It is **not** "the people," nor "the proletariat," nor "the masses,"
it is those who make up the government who have and exercise real power. As
Malatesta argued, government means _"the delegation of power, that is the
abdication of initiative and sovereignty of all into the hands of a few"_ and
_"if . . . , as do the authoritarians, one means government action when one
talks of social action, then this is still the resultant of individual forces,
but only of those individuals who form the government."_ [**Anarchy**, p. 40
and p. 36] Therefore, anarchists argue, the replacement of party power for
working class power is inevitable because of the nature of the state. In the
words of Murray Bookchin:

> _"Anarchist critics of Marx pointed out with considerable effect that any
system of representation would become a statist interest in its own right, one
that at best would work against the interests of the working classes
(including the peasantry), and that at worst would be a dictatorial power as
vicious as the worst bourgeois state machines. Indeed, with political power
reinforced by economic power in the form of a nationalised economy, a
'workers' republic' might well prove to be a despotism (to use one of
Bakunin's more favourite terms) of unparalleled oppression . . . _

> _"Republican institutions, however much they are intended to express the
interests of the workers, necessarily place policy-making in the hands of
deputies and categorically do not constitute a 'proletariat organised as a
ruling class.' If public policy, as distinguished from administrative
activities, is not made by the people mobilised into assemblies and
confederally co-ordinated by agents on a local, regional, and national basis,
then a democracy in the precise sense of the term does not exist. The powers
that people enjoy under such circumstances can be usurped without difficulty .
. . [I]f the people are to acquire real power over their lives and society,
they must establish - and in the past they have, for brief periods of time
established - well-ordered institutions in which they themselves directly
formulate the policies of their communities and, in the case of their regions,
elect confederal functionaries, revocable and strictly controllable, who will
execute them. Only in this sense can a class, especially one committed to the
abolition of classes, be mobilised as a class to manage society."_ [_"The
Communist Manifesto: Insights and Problems"_, pp. 14-17, **Black Flag**, no.
226, pp. 16-7]

This is why anarchists stress direct democracy (self-management) in free
federations of free associations. It is the only way to ensure that power
remains in the hands of the people and is not turned into an alien power above
them. Thus Marxist support for statist forms of organisation will inevitably
undermine the liberatory nature of the revolution.

Thus the **real** meaning of a workers state is simply that the **party** has
the real power, not the workers. That is the nature of a state. Marxist
rhetoric tends to hide this reality. As an example, we can point to Lenin's
comments in October, 1921. In an essay marking the fourth anniversary of the
Bolshevik Revolution, Lenin stated that the Soviet system _"provides the
maximum of democracy for the workers and peasants; at the same time, it marks
a break with **bourgeois** democracy and the rise of a new, epoch-making type
of democracy, namely, proletarian democracy, or the dictatorship of the
proletariat."_ [**Collected Works**, vol. 33, p. 55] Yet Lenin's comments came
just a few months after factions within the Communist Party had been banned
and after the Kronstadt rebellion and a wave of strikes calling for free
soviet elections had been repressed. It was written years after Lenin had
asserted that _"[w]hen we are reproached with having established a
dictatorship of one party . . . we say, 'Yes, it is a dictatorship of one
party! This is what we stand for and we shall not shift from that position . .
.'"_ [**Op. Cit.**, vol. 29, p. 535] And, of course, they had not shifted from
that position! Clearly, the term _"proletarian democracy"_ had a drastically
different meaning to Lenin than to most people!

The identification of party power and working class power reaches its height
(or, more correctly, depth) in the works of Lenin and Trotsky. Lenin, for
example, argued that _"the Communists' correct understanding of his tasks"_
lies in _"correctly gauging the conditions and the moment when the vanguard of
the proletariat can successfully assume power, when it will be able - during
and after the seizure of power - to win adequate support from sufficiently
broad strata of the working class and of the non-proletarian working masses,
and when it is able thereafter to maintain, consolidate, and extend its rule
by educating, training and attracting ever broader masses of the working
people."_ Note, the vanguard (the party) seizes power, **not** the masses.
Indeed, he stressed that the _"mere presentation of the question -
'dictatorship of the party **or** dictatorship of the class: dictatorship
(party) of the leaders **or** dictatorship (party) of the masses?' - testifies
to most incredible and hopelessly muddled thinking"_ and _"[t]o go so far . .
. as to contrast, **in general**, the dictatorship of the masses with a
dictatorship of the leaders is ridiculously absurd, and stupid."_ [**The Lenin
Anthology**, p. 575, p. 567 and p. 568]

Lenin stressed this idea numerous times. For example, he argued that _"the
dictatorship of the proletariat cannot be exercised through an organisation
embracing the whole of the class, because in all capitalist countries (and not
only over here, in one of the most backward) the proletariat is still so
divided, so degraded, and so corrupted in parts . . . that an organisation
taking in the whole proletariat cannot directly exercise proletarian
dictatorship. It can be exercised only by a vanguard . . . Such is the basic
mechanism of the dictatorship of the proletariat, and the essentials of
transition from capitalism to communism . . . for the dictatorship of the
proletariat cannot be exercised by a mass proletarian organisation."_
[**Collected Works**, vol. 32, p. 21] This position had become Communist
orthodoxy both in Russia and internationally since early 1919. The American
socialist John Reed, author of **Ten Days that Shook the World**, was a
defender of _"the value of centralisation"_ and _"the dictatorship of a
revolutionary minority"_ (noting that _"the Communist Party is supreme in
Russia"_). [**Shaking the World**, p. 238] Similarly with the likes of Amedeo
Bordiga, the first leader of the Communist Party in Italy.

Victor Serge, the ex-anarchist and enthusiastic convert to Bolshevism, argued
this mainstream Bolshevik position until the mid-1930s. In 1919, it was a case
that _"dictatorship"_ was not some kind of "proletarian" dictatorship by the
masses. He, like the leading Bolsheviks, explicitly argued against this. Yes,
he wrote, _"if we are looking at what should, that is at what **ought to**, be
the case"_ but this _"seems doubtful"_ in reality. _"For it appears that by
force of circumstances one group is obliged to impose itself on the others and
to go ahead of them, breaking them if necessary, in order then to exercise
exclusive dictatorship."_ The militants _"leading the masses . . . cannot rely
on the consciousness, the goodwill or the determination of those they have to
deal with; for the masses who will follow them or surround them will be warped
by the old regime, relatively uncultivated, often unaware, torn by feelings
and instincts inherited from the past."_ So _"revolutionaries will have to
take on the dictatorship without delay."_ The experience of Russia _"reveals
an energetic and innovative minority which is compelled to make up for the
deficiencies in the education of the backward masses by the use of
compulsion."_ And so the party _"is in a sense the nervous system of the
class. Simultaneously the consciousness and the active, physical organisation
of the dispersed forces of the proletariat, which are often ignorant of
themselves and often remain latent or express themselves contradictorily."_
And what of the masses? What was their role? Serge was equally blunt. While
the party is _"supported by the entire working population,"_ strangely enough,
_"it maintains its unique situation in dictatorial fashion"_ while the workers
are _"[b]ehind"_ the communists, _"sympathising instinctively with the party
and carrying out the menial tasks required by the revolution."_ [**Revolution
in Danger**, p. 106, p. 92, p. 115, p. 67, p. 66 and p. 6]

Such are the joys of socialist liberation. The party thinks for the worker
while they carry out the _"menial tasks"_ of the revolution. Like doing the
work and following the orders - as in any class system.

Trotsky agreed with this lesson and in 1926 opined that the _"dictatorship of
the party does not contradict the dictatorship of the class either
theoretically or practically; but is the expression of it, if the regime of
workers' democracy is constantly developed more and more."_ [**The Challenge
of the Left Opposition (1926-27)**, p. 76] The obvious contradictions and
absurdities of this assertion are all too plain. Needless to say, when
defending the concept of _"the dictatorship of the party"_ he linked it to
Lenin (and so to Leninist orthodoxy):

> _"Of course, the foundation of our regime is the dictatorship of a class.
But this in turn assumes . . . it is a class that has come to self-
consciousness through its vanguard, which is to say, through the party.
Without this, the dictatorship could not exist . . . Dictatorship is the most
highly concentrated function of a class, and therefore the basic instrument of
a dictatorship is a party. In the most fundamental aspects a class realises
its dictatorship through a party. That is why Lenin spoke not only of the
dictatorship of the class but also the dictatorship of the party and, **in a
certain sense**, made them identical."_ [**Op. Cit.**, pp. 75-6]

He repeated this position on party dictatorship into the late 1930s, long
after it had resulted in the horrors of Stalinism:

> _"The revolutionary dictatorship of a proletarian party is for me not a
thing that one can freely accept or reject: It is an objective necessity
imposed upon us by the social realities - the class struggle, the
heterogeneity of the revolutionary class, the necessity for a selected
vanguard in order to assure the victory. The dictatorship of a party belongs
to the barbarian prehistory as does the state itself, but we can not jump over
this chapter, which can open (not at one stroke) genuine human history. . .
The revolutionary party (vanguard) which renounces its own dictatorship
surrenders the masses to the counter-revolution . . . Abstractly speaking, it
would be very well if the party dictatorship could be replaced by the
'dictatorship' of the whole toiling people without any party, but this
presupposes such a high level of political development among the masses that
it can never be achieved under capitalist conditions. The reason for the
revolution comes from the circumstance that capitalism does not permit the
material and the moral development of the masses."_ [**Writings of Leon
Trotsky 1936-37**, pp. 513-4]

Significantly, this was the year after his apparent (and much belated) embrace
of soviet democracy in **The Revolution Betrayed**. Moreover, as we discuss in
[section H.3.8](secH3.html#sech38), he was just repeating the same arguments
he had made while in power during the Russian Revolution. Nor was he the only
one. Zinoviev, another leading Bolshevik, argued in 1920 along the same lines:

> _"soviet rule in Russia could not have been maintained for three years - not
even three weeks - without the iron dictatorship of the Communist Party. Any
class conscious worker must understand that the dictatorship of the working
class can be achieved only by the dictatorship of its vanguard, i.e., by the
Communist Party . . . All questions of economic reconstruction, military
organisation, education, food supply - all these questions, on which the fate
of the proletarian revolution depends absolutely, are decided in Russia before
all other matters and mostly in the framework of the party organisations . . .
Control by the party over soviet organs, over the trade unions, is the single
durable guarantee that any measures taken will serve not special interests,
but the interests of the entire proletariat."_ [quoted by Oskar Anweiler,
**The Soviets**, pp. 239-40]

Three years later, at the Communist Party's congress, he made light of
_"comrades who think that the dictatorship of the party is a thing to be
realised in practice but not spoken about."_ He went on to argue that what was
needed was _"a **single** powerful central committee which is leader of
everything . . . in this is expressed the dictatorship of the party."_ The
Congress itself resolved that _"the dictatorship of the working class cannot
be assured otherwise than in the form of a dictatorship of its leading
vanguard, i.e., the Communist Party."_ [quoted by E.H. Carr, **The Bolshevik
Revolution 1917-1923**, vol. 1, p. 236, pp. 236-7 and p. 237]

How these positions can be reconciled with workers' democracy, power or
freedom is not explained. As such, the idea that Leninism (usually considered
as mainstream Marxism) is inherently democratic or a supporter of power to the
people is clearly flawed. Equally flawed are the attempts by Leninists to
distance themselves from, and rationalise, these positions in terms of the
"objective circumstances" (such as civil war) facing the Russian Revolution.
As we discuss in [section H.6](secH6.html), Bolshevik authoritarianism started
**before** these problems began and continued long after they ended (in part
because the policies pursued by the Bolshevik leadership had roots in their
ideology and, as a result, that ideology itself played a key role in the
failure of the revolution).

Ultimately, though, the leading lights of Bolshevism concluded from their
experiences that the dictatorship of the proletariat could only be achieved by
the dictatorship of the party and they generalised this position for **all**
revolutions. Even in the prison camps in the late 1920s and early 1930s,
_"almost all the Trotskyists continued to consider that 'freedom of party'
would be 'the end of the revolution.' 'Freedom to choose one's party - that is
Menshevism,' was the Trotskyists' final verdict."_ [Ante Ciliga, **The Russian
Enigma**, p. 280] While few Leninists today would subscribe to this position,
the fact is when faced with the test of revolution the founders of their
ideology not only practised the dictatorship of the party, they raised it to
an ideological truism. Sadly, most modern day Trotskyists ignore this awkward
fact in favour of inaccurate claims that Trotsky's **Left Opposition**
_"framed a policy along [the] lines"_ of _"returning to genuine workers'
democracy"_. [Chris Harman, **Bureaucracy and Revolution in Eastern Europe**,
p. 19] In reality, as "Left Oppositionist" Victor Serge pointed out, _"the
greatest reach of boldness of the Left Opposition in the Bolshevik Party was
to demand the restoration of inner-Party democracy, and it never dared dispute
the theory of single-party government - by this time, it was too late."_
[**The Serge-Trotsky Papers**, p. 181]

Significantly, this position on party rule has its roots in the uneven
political development within the working class (i.e. that the working class
contains numerous political perspectives within it). As the party (according
to Leninist theory) contains the most advanced ideas and (again according to
Leninist theory) the working class cannot reach beyond a trade union
consciousness by its own efforts, the party must take power to ensure that the
masses do not make "mistakes" or "waver" (show "vacillation") during a
revolution. From such a perspective to the position of party dictatorship is
not far (and a journey that all the leading Bolsheviks, including Lenin and
Trotsky did in fact take).

These arguments by leading Bolsheviks confirm Bakunin's fear that the Marxists
aimed for _"a tyranny of the minority over a majority in the name of the
people - in the name of the stupidity of the many and the superior wisdom of
the few."_ [**Marxism, Freedom and the State**, p. 63]

In contrast, anarchists argue that precisely because of political differences
we need the fullest possible democracy and freedom to discuss issues and reach
agreements. Only by discussion and self-activity can the political
perspectives of those in struggle develop and change. In other words, the fact
Bolshevism uses to justify its support for party power is the strongest
argument against it. For anarchists, the idea of a revolutionary government is
a contradiction. As Malatesta put it, _"if you consider these worthy electors
as unable to look after their own interests themselves, how is it that they
will know how to choose for themselves the shepherds who must guide them? And
how will they be able to solve this problem of social alchemy, of producing a
genius from the votes of a mass of fools?"_ [**Anarchy**, pp. 53-4] As such,
anarchists think that power should be in the hands of the masses themselves.
Only freedom or the struggle for freedom can be the school of freedom. That
means that, to quote Bakunin, _"since it is the people which must make the
revolution everywhere . . . the ultimate direction of it must at all times be
vested in the people organised into a free federation of agricultural and
industrial organisations . . . organised from the bottom up through
revolutionary delegation."_ [**No God, No Masters**, vol. 1, pp. 155-6]

Clearly, then, the question of state/party power is one dividing anarchists
and most Marxists. Again, though, we must stress that libertarian Marxists
agree with anarchists on this subject and reject the whole idea that
rule/dictatorship of a party equals the dictatorship of the working class. As
such, the Marxist tradition as a whole does not confuse this issue, although
the majority of it does. So not all Marxists are Leninists. A few (council
communists, Situationists, and so on) are far closer to anarchism. They also
reject the idea of party power/dictatorship and the use of elections and
instead argue for direct action, the abolition of wage slavery by workers'
self-management of production and so on. They represent the best in Marx's
work and should not be lumped with the followers of Bolshevism. Sadly, they
are in the minority.

Finally, we should indicate other important areas of difference as summarised
by Lenin in his work **The State and Revolution**:

> _"The difference between the Marxists and the anarchists is this: 1) the
former, while aiming at the complete abolition of the state, recognise that
this aim can only be achieved after classes have been abolished by the
socialist revolution, as the result of the establishment of socialism which
leads to the withering away of the state. The latter want to abolish the state
completely overnight, failing to understand the conditions under which the
state can be abolished 2) the former recognise that after the proletariat has
conquered political power it must utterly destroy the old state machine and
substitute for it a new one consisting of the organisation of armed workers,
after the type of the Commune. The latter, while advocating the destruction of
the state machine, have absolutely no idea of **what** the proletariat will
put in its place and **how** it will use its revolutionary power; the
anarchists even deny that the revolutionary proletariat should utilise its
state power, its revolutionary dictatorship; 3) the former demand that the
proletariat be prepared for revolution by utilising the present state; the
latter reject this."_ [**Essential Works of Lenin**, p. 358]

We will discuss each of these points in the next three sections. Point one
will be discussed in [section H.1.3](secH1.html#sech13), the second in
[section H.1.4](secH1.html#sech14) and the third and final one in [section
H.1.5](secH1.html#sech15).

## H.1.3 Why do anarchists wish to abolish the state _"overnight"_?

As indicated at the end of the [last section](secH1.html#sech12), Lenin argued
that while Marxists aimed _"at the complete abolition of the state"_ they
_"recognise that this aim can only be achieved after classes have been
abolished by the socialist revolution"_ while anarchists _"want to abolish the
state completely overnight."_ This issue is usually summarised by Marxists
arguing that a new state is required to replace the destroyed bourgeois one.
This new state is called by Marxists **_"the dictatorship of the
proletariat"_** or a workers' state. Anarchists reject this transitional state
while Marxists embrace it. Indeed, according to Lenin _"a Marxist is one who
**extends** the acceptance of the class struggle to the acceptance of the
**dictatorship of the proletariat**."_ [**Essential Works of Lenin**, p. 358
and p. 294]

So what does the "dictatorship of the proletariat" actually mean? Generally,
Marxists seem to imply that this term simply means the defence of the
revolution and so the anarchist rejection of the dictatorship of the
proletariat means, for Marxists, the denial of the need to defend a
revolution. This particular straw man was used by Lenin in **The State and
Revolution** when he quoted Marx's article _"Indifference to Politics"_ to
suggest that anarchists advocated workers _"laying down their arms"_ after a
successful revolution. Such a _"laying down [of] their arms"_ would mean
_"abolishing the state"_ while keeping their arms _"in order to crush the
resistance of the bourgeoisie"_ would mean _"giv[ing] the state a
revolutionary and transitory form,"_ so setting up _"their revolutionary
dictatorship in place of the dictatorship of the bourgeoisie."_ [Marx, quoted
by Lenin, **Op. Cit.**, p. 315]

That such an argument can be made, never mind repeated, suggests a lack of
honesty. It assumes that the Marxist and Anarchist definitions of "the state"
are identical. They are not. For anarchists the state, government, means _"the
delegation of power, that is the abdication of initiative and sovereignty of
all into the hands of a few."_ [Malatesta, **Anarchy**, p. 41] For Marxists,
the state is _"an organ of class **rule**, an organ for the **oppression** of
one class by another."_ [Lenin, **Op. Cit.**, p. 274] That these definitions
are in conflict is clear and unless this difference is made explicit,
anarchist opposition to the "dictatorship of the proletariat" cannot be
clearly understood.

Anarchists, of course, agree that the current state is the means by which the
bourgeois class enforces its rule over society. In Bakunin's words, _"the
political state has no other mission but to protect the exploitation of the
people by the economically privileged classes."_ [**The Political Philosophy
of Bakunin**, p. 221] _"Throughout history, just as in our time, government is
either the brutal, violent, arbitrary rule of the few over the many or it is
an organised instrument to ensure that domination and privilege will be in the
hands of those who . . . have cornered all the means of life."_ Under
capitalism, as Malatesta succulently put, the state is _"the bourgeoisie's
servant and **gendarme**."_ [**Op. Cit.**, p. 21 and p. 23] The reason why the
state is marked by centralised power is due to its role as the protector of
(minority) class rule. As such, a state cannot be anything but a defender of
minority power as its centralised and hierarchical structure is designed for
that purpose. If the working class really were running society, as Marxists
claim they would be in the "dictatorship of the proletariat," then it would
not be a state. As Bakunin put it: _"Where all rule, there are no more ruled,
and there is no State."_ [**Op. Cit.**, p. 223]

The idea that anarchists, by rejecting the "dictatorship of the proletariat,"
also reject defending a revolution is false. We do not equate the
"dictatorship of the proletariat" with the need to defend a revolution or
expropriating the capitalist class, ending capitalism and building socialism.
Anarchists from Bakunin onwards have taken both of these necessities for
granted. As we discuss this particular Marxist straw man in [section
H.2.1](secH2.html#sech21), we will leave our comments on anarchist awareness
of the need to defend a revolution at this.

Anarchists, then, do not reject defending a revolution and our opposition to
the so-called "revolutionary" or "socialist" state is not based on this,
regardless of what Marx and Lenin asserted. Rather, we argue that the state
can and must be abolished "overnight" during a social revolution because any
state, including the so-called "dictatorship of the proletariat", is marked by
hierarchical power and can only empower the few at the expense of the many.
The state will not "wither away" as Marxists claim simply because it excludes,
by its very nature, the active participation of the bulk of the population and
ensures a new class division in society: those in power (the party) and those
subject to it (the working class). Georges Fontenis sums up anarchist concerns
on this issue:

> _"The formula 'dictatorship of the proletariat' has been used to mean many
different things. If for no other reason it should be condemned as a cause of
confusion. With Marx it can just as easily mean the centralised dictatorship
of the party which claims to represent the proletariat as it can the
federalist conception of the Commune. _

> _"Can it mean the exercise of political power by the victorious working
class? No, because the exercise of political power in the recognised sense of
the term can only take place through the agency of an exclusive group
practising a monopoly of power, separating itself from the class and
oppressing it. And this is how the attempt to use a State apparatus can reduce
the dictatorship of the proletariat to the dictatorship of the party over the
masses. _

> _"But if by dictatorship of the proletariat is understood collective and
direct exercise of 'political power', this would mean the disappearance of
'political power' since its distinctive characteristics are supremacy,
exclusivity and monopoly. It is no longer a question of exercising or seizing
political power, it is about doing away with it all together! _

> _"If by dictatorship is meant the domination of the majority by a minority,
then it is not a question of giving power to the proletariat but to a party, a
distinct political group. If by dictatorship is meant the domination of a
minority by the majority (domination by the victorious proletariat of the
remnants of a bourgeoisie that has been defeated as a class) then the setting
up of dictatorship means nothing but the need for the majority to efficiently
arrange for its defence its own social Organisation. _

> _[...] _

> _"The terms 'domination', 'dictatorship' and 'state' are as little
appropriate as the expression 'taking power' for the revolutionary act of the
seizure of the factories by the workers. _

> _We reject then as inaccurate and causes of confusion the expressions
'dictatorship of the proletariat', 'taking political power', 'workers state',
'socialist state' and 'proletarian state'."_ [**Manifesto of Libertarian
Communism**, pp. 22-3]

So anarchists argue that the state has to be abolished "overnight" simply
because a state is marked by hierarchical power and the exclusion of the bulk
of the population from the decision making process. It cannot be used to
implement socialism simply because it is not designed that way. To extend and
defend a revolution a state is not required. Indeed, it is a hindrance:

> _"The mistake of authoritarian communists in this connection is the belief
that fighting and organising are impossible without submission to a
government; and thus they regard anarchists . . . as the foes of all
organisation and all co-ordinated struggle. We, on the other hand, maintain
that not only are revolutionary struggle and revolutionary organisation
possible outside and in spite of government interference but that, indeed,
that is the only effective way to struggle and organise, for it has the active
participation of all members of the collective unit, instead of their
passively entrusting themselves to the authority of the supreme leaders. _

> _"Any governing body is an impediment to the real organisation of the broad
masses, the majority. Where a government exists, then the only really
organised people are the minority who make up the government; and . . . if the
masses do organise, they do so against it, outside it, or at the very least,
independently of it. In ossifying into a government, the revolution as such
would fall apart, on account of its awarding that government the monopoly of
organisation and of the means of struggle."_ [Luigi Fabbri, _"Anarchy and
'Scientific' Communism"_, pp. 13-49, **The Poverty of Statism**, Albert
Meltzer (ed.), p. 27]

This is because of the hierarchical nature of the state, its delegation of
power into the hands of the few and so a so-called "revolutionary" government
can have no other result than a substitution of the few (the government) for
the many (the masses). This, in turn, undermines the mass participation and
action from below that a revolution needs to succeed and flourish. _"Instead
of acting for themselves,"_ Kropotkin argued, _"instead of marching forward,
instead of advancing in the direction of the new order of things, the people,
confiding in their governors, entrusted to them the charge of taking the
initiative."_ However, social change is the product of _"the people in
action"_ and _"the brain of a few individuals [are] absolutely incapable of
finding solutions"_ to the problems it will face _"which can only spring from
the life of the people."_ For anarchists, a revolution _"is not a simple
change of governors. It is the taking possession by the people of all social
wealth"_ and this cannot be achieved _"be decrees emanating from a
government."_ This _"economic change"_ will be _"so immense and so profound"_
that it is _"impossible for one or any individual to elaborate the different
social forms which must spring up in the society of the future. This
elaboration of new social forms can only be made by the collective work of the
masses"_ and _"[a]ny authority external to it will only be an obstacle_, a
_"drag on the action of the people."_ A revolutionary state, therefore,
_"becomes the greatest obstacle to the revolution"_ and to _"dislodge it"_
requires the people _"to take up arms, to make another revolution."_
[**Anarchism**, p. 240, p. 241, pp. 247-8, p. 248, p. 249, p. 241 and p. 242]
Which, we should stress, was exactly what happened in Russia, where anarchists
and others (such as the Kronstadt rebels) called for a _"Third Revolution"_
against the Bolshevik state and the party dictatorship and state capitalism it
had created.

For anarchists, the abolition of the state does not mean rejecting the need to
extend or defend a revolution (quite the reverse!). It means rejecting a
system of organisation designed by and for minorities to ensure their rule. To
create a state (even a "workers' state") means to delegate power away from the
working class and eliminate their power in favour of party power (_"the
principle error of the [Paris] Commune, an unavoidable error, since it derived
from the very principle on which power was constituted, was precisely that of
being a government, and of substituting itself for the people by force of
circumstances."_ [Elisée Reclus, quoted John P. Clark and Camille Martin,
**Anarchy, Geography, Modernity**, p. 72]).

In place of a state anarchists' argue for a free federation of workers'
organisations as the means of conducting a revolution (and the framework for
its defence). Most Marxists seem to confuse centralism and federalism, with
Lenin stating that _"if the proletariat and the poor peasants take state power
into their own hands, organise themselves quite freely in communes, and unite
the action of all the communes in striking at capital . . . won't that be
centralism? Won't that be the most consistent democratic centralism and,
moreover, proletarian centralism?"_ No, it would be federalism, the most
consistent federalism as advocated by Proudhon and Bakunin and, under the
influence of the former, suggested by the Paris Commune. Lenin argued that
some _"simply cannot conceive of the possibility of voluntary centralism, of
the voluntary fusion of the proletarian communes, for the sole purpose of
destroying bourgeois rule and the bourgeois state machine."_ [**The Lenin
Anthology**, p. 348] Yet _"voluntary centralism"_ is, at best, just another
why of describing federalism - assuming that "voluntary" really means that, of
course. At worst, and in practice, such centralism simply places all the
decision making at the centre, at the top, and all that is left is for the
communes to obey the decisions of a few party leaders.

As we discuss in the [next section](secH1.html#sech14), anarchists see this
federation of workers' associations and communes (the framework of a free
society) as being based on the organisations working class people create in
their struggle against capitalism. These self-managed organisations, by
refusing to become part of a centralised state, will ensure the success of a
revolution.

## H.1.4 Do anarchists have _"absolutely no idea"_ of what to put in place of
the state?

Lenin's second claim was that anarchists, _"while advocating the destruction
of the state machine, have absolutely no idea of **what** the proletariat will
put in its place"_ and compared this to the Marxists who argued for a new
state machine _"consisting of armed workers, after the type of the [Paris]
Commune."_ [**Essential Works of Lenin**, p. 358]

For anarchists, Lenin's assertion simply shows his unfamiliarity with
anarchist literature and need not be taken seriously - anyone familiar with
anarchist theory would simply laugh at such comments. Sadly, most Marxists are
**not** familiar with that theory, so we need to explain two things. Firstly,
anarchists have very clear ideas on what to "replace" the state with (namely a
federation of communes based on working class associations). Secondly, that
this idea is based on the idea of armed workers, inspired by the Paris Commune
(although predicted by Bakunin).

Moreover, for anarchists Lenin's comment seems somewhat incredulous. As George
Barrett put it, in reply to the question _"if you abolish government, what
will you put it its place,"_ this _"seems to an Anarchist very much as if a
patient asked the doctor, 'If you take away my illness, what will you give me
in its place?' The Anarchist's argument is that government fulfils no useful
purpose . . . It is the headquarters of the profit-makers, the rent-takers,
and of all those who take from but who do not give to society. When this class
is abolished by the people so organising themselves to run the factories and
use the land for the benefit of their free communities, i.e. for their own
benefit, then the Government must also be swept away, since its purpose will
be gone. The only thing then that will be put in the place of government will
be the free organisation of the workers. When Tyranny is abolished, Liberty
remains, just as when disease is eradicated health remains."_ [**Objections to
Anarchism**, p. 356]

Barrett's answer contains the standard anarchist position on what will be the
organisational basis of a revolutionary society, namely that the _"only thing
then that will be put in the place of government will be the free organisation
of the workers."_ This is a concise summary of anarchist theory and cannot be
bettered. This vision, as we discuss in [section I.2.3](secI2.html#seci23) in
some detail, can be found in the work of Bakunin, Kropotkin, Malatesta and a
host of other anarchist thinkers. Since anarchists from Bakunin onwards have
stressed that a federation of workers' associations would constitute the
framework of a free society, to assert otherwise (as Lenin did) is little more
than a joke or a slander. To quote Bakunin:

> _"The future social organisation must be made solely from the bottom up, by
the free association or federation of workers, firstly in their unions, then
in the communes, regions, nations and finally in a great federation,
international and universal."_ [**Michael Bakunin: Selected Writings**, p.
206]

Similar ideas can easily be found in the works of other anarchists. While the
actual names and specific details of these federations of workers'
associations may change (for example, the factory committees and soviets in
the Russian Revolution, the collectives in Spain, the section assemblies in
the French Revolution are a few of them) the basic ideas are the same. Bakunin
also pointed to the means of defence, a workers' militia (the people armed, as
per the Paris Commune - [section H.2.1](secH2.html#sech21)).

A major difference between anarchism and Marxism which Lenin points to is,
clearly, false. Anarchists are well aware of what should _"replace"_ the
bourgeois state and have always been so. The **real** difference is simply
that anarchists say what they mean while Lenin's "new" state did not, in fact,
mean working class power but rather party power.

As for Lenin's comment that we have _"absolutely no ideas"_ of how the working
class _"will use its revolutionary power"_ suggests more ignorance, as we have
urged working people to expropriate the expropriators, reorganise production
under workers' self-management and start to construct society from the bottom
upwards (a quick glance at Kropotkin's **Conquest of Bread**, for example,
would soon convince any reader of the inaccuracy of Lenin's comment). This
summary by the anarchist Jura Federation (written in 1880) gives a flavour of
anarchist ideas on this subject:

> _"The bourgeoisie's power over the popular masses springs from economic
privileges, political domination and the enshrining of such privileges in the
laws. So we must strike at the wellsprings of bourgeois power, as well as its
various manifestations. _

> _"The following measures strike us as essential to the welfare of the
revolution, every bit as much as armed struggle against its enemies: _

> _"The insurgents must confiscate social capital, landed estates, mines,
housing, religious and public buildings, instruments of labour, raw materials,
gems and precious stones and manufactured products: _

> _"All political, administrative and judicial authorities are to be deposed .
. . What should the organisational measures of the revolution be? _

> _"Immediate and spontaneous establishment of trade bodies: provisional
assumption by those of . . . social capital . . .: local federation of a
trades bodies and labour organisation: _

> _"Establishment of neighbourhood groups and federations of same . . . _

> _"Organisation of the insurgent forces . . . the federation of all the
revolutionary forces of the insurgent Communes . . . Federation of Communes
and organisation of the masses, with an eye to the revolution's enduring until
such time as all reactionary activity has been completely eradicated . . .
Once trade bodies have been have been established, the next step is to
organise local life. The organ of this life is to be the federation of trades
bodies and it is this local federation which is to constitute the future
Commune."_ [**No Gods, No Masters**, vol. 1, pp. 246-7]

Clearly, anarchists do have some ideas on what the working class will
_"replace"_ the state with and how it will use its _"revolutionary power"_!

Similarly, Lenin's statement that _"the anarchists even deny that the
revolutionary proletariat should utilise its state power, its revolutionary
dictatorship"_ again distorts the anarchist position. As we argued in [the
last section](secH1.html#sech13), our objection to the "state power" of the
proletariat is precisely **because** it cannot, by its very nature as a state,
actually allow the working class to manage society directly (and, of course,
it automatically excludes other sections of the working masses, such as the
peasantry and artisans). We argued that, in practice, it would simply mean the
dictatorship of a few party leaders. This position, we must stress, was one
Lenin himself was arguing in the year after completing **State and
Revolution** and so the leading Bolsheviks confirmed the anarchist argument
that the "dictatorship of the proletariat" would, in fact, become a
dictatorship **over** the proletariat by the party.

Italian anarchist Camillo Berneri summed up the differences well:

> _"The Marxists . . . foresee the natural disappearance of the State as a
consequence of the destruction of classes by the means of 'the dictatorship of
the proletariat,' that is to say State Socialism, whereas the Anarchists
desire the destruction of the classes by means of a social revolution which
eliminates, with the classes, the State. The Marxists, moreover, do not
propose the armed conquest of the Commune by the whole proletariat, but they
propose the conquest of the State by the party which imagines that it
represents the proletariat. The Anarchists allow the use of direct power by
the proletariat, but they understand by the organ of this power to be formed
by the entire corpus of systems of communist administration-corporate
organisations [i.e. industrial unions], communal institutions, both regional
and national-freely constituted outside and in opposition to all political
monopoly by parties and endeavouring to a minimum administrational
centralisation."_ [_"Dictatorship of the Proletariat and State Socialism"_,
pp. 51-2, **Cienfuegos Press Anarchist Review**, no. 4, p. 52]

Clearly, Lenin's assertions are little more than straw men. Anarchists are not
only well aware of the need for a federation of working class associations
(workers' councils or soviets) to replace the state, they were advocating it
long before Lenin took up this perspective in 1917 (as we discuss in [section
H.3.10](secH3.html#sech310)). The key difference being, of course, anarchists
meant it while Lenin saw it as a means of securing Bolshevik party power.

Lastly, it should also be noted that Marxists, having taken so long to draw
the same conclusions as anarchists like Proudhon and Bakunin, have tended to
make a fetish of workers councils. As an example, we find Chris Harman of the
British SWP complaining that the Argentinean masses organised themselves in
the wrong way as part of their revolt against neo-liberalism which started in
December 2001. He states that the _"neighbourhood committees and popular
assemblies"_ created by the revolt _"express the need of those who have
overthrown presidents to organise themselves"_ and notes _"they have certain
similarities with the characteristic forms of mass self organisation that
arose in the great working class struggles of the 20th century - the workers'
councils or soviets."_ But, he stressed, _"they also have very important
differences from these."_ Yet Harman's complaints show his own confusions,
seriously arguing that _"the popular assemblies are not yet bodies of
delegates. The people at them represent themselves, but do not have an organic
connection with some group of people who they represent - and who can recall
them if they do not carry out their will."_ [_"Argentina: rebellion at the
sharp end of the world crisis"_, pp. 3-48, **International Socialism**, vol.
94, p. 25] That, of course, is the whole point - they are popular
**assemblies**! A popular assembly does not "represent" anyone because its
members govern themselves, i.e. are directly democratic. They are the
elemental bodies which recall any delegates who do not implement their
mandate! But given that Leninism aims at party power, this concern for
representation is perfectly understandable, if lamentable.

So rather than celebrate this rise in mass self-management and self-
organisation, Harman complains that these _"popular assemblies are not
anchored in the workplaces where millions of Argentineans are still drawn
together on a daily basis to toil."_ Need it be said that such an SWP approved
organisation will automatically exclude the unemployed, housewives, the
elderly, children and other working class people who were taking part in the
struggle? In addition, any capitalist crisis is marked by rising unemployment,
firms closing and so on. While workplaces must and have been seized by their
workers, it is a law of revolutions that the economic disruption they cause
results in increased unemployment (in this Kropotkin's arguments in **The
Conquest of Bread** have been confirmed time and time again). Significantly,
Harman admits that they include _"organisations of unemployed workers"_ as
well as _"that in some of the assemblies an important leading role is played
by unemployed activists shaped by their role in past industrial struggles."_
He does not, however, note that creating workers' councils would end their
active participation in the revolt. [**Op. Cit.**, p. 25]

That the Argentine working class formed organs of power which were not totally
dependent on the workplace was, therefore, a good sign. Factory assemblies and
federations must be formed but as a complement to, rather than as a
replacement of, the community assemblies. Harman states that the assemblies
were _"closer to the sections - the nightly district mass meetings - of the
French Revolution than to the workers' councils of 1905 and 1917 in Russia"_
and complains that a _"21st century uprising was taking the form of the
archetypal 18th century revolution!"_ [**Op. Cit.**. p. 25 and p. 22] Did the
Argentineans not realise that a 21st century uprising should mimic _"the great
working class struggles of the 20th century"_, particularly that which took
place in a mostly pre-capitalist Tsarist regime which was barely out of the
18th century itself? Did they not realise that the leaders of the vanguard
party know better than themselves how they should organise and conduct their
struggles? That the people of the 21st century knew best how to organise their
own revolts is lost on Harman, who prefers to squeeze the realities of modern
struggles into the forms which Marxists took so long to recognise in the first
place. Given that anarchists have been discussing the possibilities of
community assemblies for some time, perhaps we can expect Leninists to
recognise their importance in a few decades? After all, the Bolsheviks in
Russia were slow to realise the significance of the soviets in 1905 so
Harman's position is hardly surprising.

So, it is easy to see what anarchists think of Lenin's assertion that
_"Anarchism had failed to give anything even approaching a true solution of
the concrete political problems, **viz**., must the old state machine be
**smashed**? and **what** should supersede it?"_ [**Op. Cit.**, p. 350] We
simply point out that Lenin was utterly distorting the anarchist position on
social revolution. Revolutionary anarchists had, since the 1860s, argued that
workers' councils (soviets) could be both a weapon of class struggle against
capitalism and the state as well as the framework of the future (libertarian)
socialist society. Lenin only came to superficially similar conclusions in
1917. Which means that when he talked of workers' councils, Lenin was only
repeating Bakunin - the difference being we anarchists mean it!

## H.1.5 Why do anarchists reject _"utilising the present state"_?

This is another key issue, the question of Marxists demanding (in the words of
Lenin) _"that the proletariat be prepared for revolution by utilising the
present state"_ while anarchists _"reject this."_ [**Essential Works of
Lenin**, p. 358] By this, Lenin meant the taking part of socialists in
bourgeois elections, standing candidates for office and having socialist
representatives in Parliament and other local and national state bodies. In
other words, what Marx termed _"political action"_ and the Bolsheviks
_"revolutionary Parliamentarianism."_

For anarchists, the use of elections does not "prepare" the working class for
revolution (i.e. managing their own affairs and society). Rather, it prepares
them to follow leaders and let others act for them. In the words of Rudolf
Rocker:

> _"Participation in the politics of the bourgeois States has not brought the
labour movement a hair's-breadth nearer to Socialism, but thanks to this
method, Socialism has almost been completely crushed and condemned to
insignificance . . . Participation in parliamentary politics has affected the
Socialist Labour movement like an insidious poison. It destroyed the belief in
the necessity of constructive Socialist activity, and, worse of all, the
impulse to self-help, by inoculating people with the ruinous delusion that
salvation always comes from above."_ [**Anarcho-Syndicalism**, p. 54]

While electoral ("political") activity ensures that the masses become
accustomed to following leaders and letting them act on their behalf,
anarchists' support direct action as _"the best available means for preparing
the masses to manage their own personal and collective interests; and besides,
anarchists feel that even now the working people are fully capable of handling
their own political and administrative interests."_ Political action, in
contrast, needs centralised _"authoritarian organisations"_ and results in
_"ceding power by all to someone, the delegate, the representative"_. "For
direct pressure put against the ruling classes by the masses, the Socialist
Party has substituted representation" and _"instead of fostering the class
struggle . . . it has adopted class collaboration in the legislative arena,
without which all reforms would remain a vain hope."_ [Luigi Galleani, **The
End of Anarchism?**, pp. 13-4, p. 14 and p. 12]

Anarchists, therefore, argue that we need to reclaim the power which has been
concentrated into the hands of the state. That is why we stress direct action.
Direct action means action by the people themselves, that is action directly
taken by those directly affected. Through direct action, we dominate our own
struggles, it is we who conduct it, organise it, manage it. We do not hand
over to others our own acts and task of self-liberation. That way, we become
accustomed to managing our own affairs, creating alternative, libertarian,
forms of social organisation which can become a force to resist the state, win
reforms and, ultimately, become the framework of a free society. In other
words, direct action creates organs of self-activity (such as community
assemblies, factory committees, workers' councils, and so on) which, to use
Bakunin's words, are _"creating not only the ideas but also the facts of the
future itself."_

The idea that socialists standing for elections somehow prepares working class
people for revolution is simply wrong. Utilising the state, standing in
elections, only prepares people for following leaders - it does not encourage
the self-activity, self-organisation, direct action and mass struggle required
for a social revolution. Moreover, as Bakunin predicted, participation in
elections has a corrupting effect on those who do so. The history of radicals
using elections has been a long one of betrayal and the transformation of
revolutionary parties into reformist ones (see [section
J.2.6](secJ2.html#secj26) for more discussion). Using the existing state
ensures that the division at the heart of existing society (namely a few who
govern and the many who obey) is reproduced in the movements trying to abolish
it. It boils down to handing effective leadership to special people, to
"leaders," just when the situation requires working people to solve their own
problems and take matters into their own hands:

> _"The Social Question will be put . . . long before the Socialists have
conquered a few seats in Parliament, and thus the solution of the question
will be actually in the hands of the workmen [and women] themselves . . . _

> _"Under the influence of government worship, they may try to nominate a new
government . . . and they may entrust it with the solution of all
difficulties. It is so simple, so easy, to throw a vote into the ballot-box,
and to return home! So gratifying to know that there is somebody who will
arrange your own affairs for the best, while you are quietly smoking your pipe
and waiting for orders which you have only to execute, not to reason about."_
[Kropotkin, **Act for Yourselves**, p. 34]

Only the struggle for freedom (or freedom itself) can be the school for
freedom, and by placing power into the hands of leaders, utilising the
existing state ensures that socialism is postponed rather than prepared for.
As such, strikes and other forms of direct action _"are of enormous value;
they create, organise, and form a workers' army, an army which is bound to
break down the power of the bourgeoisie and the State, and lay the ground for
a new world."_ [Bakunin, **The Political Philosophy of Bakunin**, pp. 384-5]
In contrast, utilising the present state only trains people in following
leaders and so socialism _"lost its creative initiative and became an ordinary
reform movement . . . content with success at the polls, and no longer
attributed any importance to social upbuilding."_ [Rocker, **Op. Cit.**, p.
55]

Which highlights another key problem with the notion of utilising the present
state as Marxist support for electioneering is somewhat at odds with their
claims of being in favour of collective, mass action. There is nothing more
isolated, atomised and individualistic than voting. It is the act of one
person in a box by themselves. It is the total opposite of collective
struggle. The individual is alone before, during and after the act of voting.
Indeed, unlike direct action, which, by its very nature, throws up new forms
of organisation in order to manage and co-ordinate the struggle, voting
creates no alternative social structures. Nor can it as it is not based on nor
does it create collective action or organisation. It simply empowers an
individual (the elected representative) to act on behalf of a collection of
other individuals (the voters). This will hinder collective organisation and
action as the voters expect their representative to act and fight for them -
if they did not, they would not vote for them in the first place!

Given that Marxists usually slander anarchists as "individualists" the irony
is delicious!

If we look at the anti-Poll-Tax campaign in the UK in the late 1980s and early
1990s, we can see what would happen to a mass movement which utilised
electioneering. Various left-wing parties spent a lot of time and effort
lobbying Labour Councillors not to implement the tax (with no success). Let us
assume they had succeeded and the Labour Councillors had refused to implement
the tax (or "socialist" candidates had been elected to stop it). What would
have happened? Simply that there would not have been a mass movement or mass
organisation based on non-payment, nor self-organised direct action to resist
warrant sales, nor community activism of any form. Rather, the campaign would
have consisted of supporting the councillors in their actions, mass rallies in
which the leaders would have informed us of their activities on our behalf
and, perhaps, rallies and marches to protest any action the government had
inflicted on them. The leaders may have called for some form of mass action
but this action would not have come from below and so not be a product of
working class self-organisation, self-activity and self-reliance. Rather, it
would have been purely re-active and a case of follow the leader, without the
empowering and liberating aspects of taking action by yourself, as a conscious
and organised group. It would have replaced the struggle of millions with the
actions of a handful of leaders.

Of course, even discussing this possibility indicates how remote it is from
reality. The Labour Councillors were not going to act - they were far too
"practical" for that. Years of working within the system, of using elections,
had taken their toll decades ago. Anarchists, of course, saw the usefulness of
picketing the council meetings, of protesting against the Councillors and
showing them a small example of the power that existed to resist them if they
implemented the tax. As such, the picket would have been an expression of
direct action, as it was based on showing the power of our direct action and
class organisations. Lobbying, however, was building illusions in "leaders"
acting for us and based on pleading rather than defiance. But, then again,
Militant desired to replace the current leaders with themselves and so had an
interest in promoting such tactics and focusing the struggle on leaders and
whether they would act for people or not.

Unfortunately, the Socialists never really questioned **why** they had to
lobby the councillors in the first place - if utilising the existing state
**was** a valid radical or revolutionary tactic, why has it always resulted in
a de-radicalising of those who use it? This would be the inevitable result of
any movement which "complements" direct action with electioneering. The focus
of the movement will change from the base to the top, from self-organisation
and direct action from below to passively supporting the leaders. This may not
happen instantly, but over time, just as the party degenerates by working
within the system, the mass movement will be turned into an electoral machine
for the party - even arguing against direct action in case it harms the
election chances of the leaders. Just as the trade union leaders have done
again and again in Britain and elsewhere.

So anarchists point to the actual record of Marxists _"utilising the present
state"_. Murray Bookchin's comments about the German Social Democrats are
appropriate here:

> _"the party's preoccupation with parliamentarism was taking it ever away
from anything Marx had envisioned. Instead of working to overthrow the
bourgeois state, the SPD, with its intense focus on elections, had virtually
become an engine for getting votes and increasing its Reichstag representation
within the bourgeois state . . . The more artful the SPD became in these
realms, the more its membership and electorate increased and, with the growth
of new pragmatic and opportunistic adherents, the more it came to resemble a
bureaucratic machine for acquiring power under capitalism rather than a
revolutionary organisation to eliminate it."_ [**The Third Revolution**, vol.
2, p. 300]

The reality of working within the state soon transformed the party and its
leadership, as Bakunin predicted. If we look at Leninism, we discover a
similar failure to consider the evidence:

> _"From the early 1920s on, the Leninist attachment to pre-WWI social
democratic tactics such as electoral politics and political activity within
pro-capitalist labour unions dominated the perspectives of the so-called
Communists. But if these tactics were correct ones, why didn't they lead to a
less dismal set of results? We must be materialists, not idealists. What was
the actual outcome of the Leninist strategies? Did Leninist strategies result
in successful proletarian revolutions, giving rise to societies worthy of the
human beings that live in them? The revolutionary movement in the inter-war
period was defeated."_ [Max Anger, _"The Spartacist School of Falsification"_,
pp. 50-2, **Anarchy: A Journal of Desire Armed**, no. 43, pp. 51-2]

As Scottish Anarchist Ethel McDonald argued in 1937, the tactics urged by
Lenin were a disaster in practice:

> _"At the Second Congress of the Third International, Moscow, a comrade who
is with us now in Spain, answering Zinoviev, urged faith in the syndicalist
movement in Germany and the end of parliamentary communism. He was ridiculed.
Parliamentarianism, communist parliamentarianism, but still parliamentarianism
would save Germany. And it did . . . Saved it from Socialism. Saved it for
Fascism. Parliamentary social democracy and parliamentary communism have
destroyed the socialist hope of Europe, has made a carnage of human liberty.
In Britain, parliamentarianism saved the workers from Socialism . . . Have you
not had enough of this huge deception? Are you still prepared to continue in
the same old way, along the same old lines, talking and talking and doing
nothing?"_ [_"The Volunteer Ban"_, pp. 72-5, **Workers City**, Farquhar McLay
(ed.), p. 74]

When the Nazis took power in 1933 in Germany the 12 million Socialist and
Communist voters and 6 million organised workers took no action. In Spain, it
was the anarcho-syndicalist CNT which lead the battle against fascism on the
streets and helped create one of the most important social revolutions the
world has seen. The contrast could not be more clear. And many Marxists urge
us to follow Lenin's advice today!

All in all, the history of socialists actually using elections has been a
dismal failure and was obviously a failure long before 1917. Subsequent
experience has only confirmed that conclusion. Rather than prepare the masses
for revolution, it has done the opposite. As we argue in [section
J.2](secJ2.html), this is to be expected. That Lenin could still argue along
these lines even after the rise of reformism ("revisionism") in the 1890s and
the betrayal of social democracy in 1914 indicates a lack of desire to learn
the lessons of history.

The negative effects of _"utilising"_ the present state are, sometimes,
acknowledged by Marxists although this rarely interferes with their support
for standing in elections. Thus we find that advocate of "revolutionary"
parliamentarianism, Trotsky, noting that _[i]f parliamentarianism served the
proletariat to a certain extent as a training school for revolution, then it
also served the bourgeoisie to a far greater extent as the school of counter-
revolutionary strategy. Suffice it to say that by means of parliamentarianism
the bourgeoisie was able so to educate the Social Democracy that it is today
[1924] the main prop of private property."_ [**Lessons of October**, pp.
170-1] Of course, the followers of Lenin and Trotsky are made of sterner stuff
than those of Marx and Engels and so utilising the same tactics will have a
different outcome. As one-time syndicalist William Gallacher put it in reply
to Lenin's question _"[i]f the workers sent you to represent them in
Parliament, would you become corrupt?"_: _"No, I'm sure that under no
circumstances could the bourgeoisie corrupt me."_ [quoted by Mark Shipway,
**Anti-Parliamentary Communism**, p. 21] Mere will-power, apparently, is
sufficient to counteract the pressures and influences of parliamentarianism
which Marx and Engels, unlike Bakunin, failed to predict but whose legacy
still haunts the minds of those who claim to be _"scientific socialists"_ and
so, presumably, base their politics on facts and experience rather than
wishful thinking.

This is why anarchists reject the notion of radicals utilising the existing
state and instead urge direct action and solidarity outside of bourgeois
institutions. Only this kind of struggle creates the spirit of revolt and new
popular forms of organisation which can fight and replace the hierarchical
structures of capitalist society. Hence anarchists stress the need of working
class people to _"rely on themselves to get rid of the oppression of Capital,
without expecting that the same thing can be done for them by anybody else.
The emancipation of the workmen [and women] must be the act of the workmen
[and women] themselves."_ [Kropotkin, **Op. Cit.**, p. 32] Only this kind of
movement and struggle can maximise the revolutionary potential of struggles
for reforms within capitalism. As history shows, the alternative has
repeatedly failed.

It should be noted, however, that not all Marxists have refused to recognise
the lessons of history. Libertarian Marxists, such as council communists, also
reject _"utilising the present state"_ to train the proletariat for revolution
(i.e. for socialists to stand for elections). Lenin attacked these Marxists
who had drawn similar conclusions as the anarchists (**after** the failure of
social-democracy) in his 1920 diatribe **Left-wing Communism: An Infantile
Disorder**. In that pamphlet he used the experiences of the Bolsheviks in
semi-Feudal Tsarist Russia to combat the conclusions drawn by socialists in
the advanced capitalist countries with sizeable social democratic parties.
Lenin's arguments for revolutionary Parliamentarianism did not convince the
anti-Parliamentarians who argued that its _"significance lies not in its
content, but in the person of the author, for the arguments are scarcely
original and have for the most part already been used by others . . . their
fallacy resides mainly in the equation of the conditions, parties,
organisations and parliamentary practice of Western Europe with their Russian
counterparts."_ [Anton Pannekoek, **Pannekoek and Gorter's Marxism**, p. 143]
While anarchists would disagree with the underlying assumption that Marx was
right in considering parliamentarianism as essential and it only became
problematic later, we would agree whole-heartedly with the critique presented
(unsurprisingly, as we made it first).

Pannekoek's article along with Herman Gorter's **Open Letter to Comrade
Lenin** are essential reading for those who are taken in with Lenin's
arguments, along with the chapter on _"Socialism"_ in Alexander Berkman's
**What is Anarchism?**. Interestingly, the Comintern asked Berkman to
translate Lenin's **Left-Wing Communism** and he agreed until he read its
contents. He then said he would continue if he could write a rebuttal, a
request which was rejected. For anarchists, placing the word "revolutionary"
in front of "parliamentarianism" does not provide a shield against the
negative influences and pressures which naturally arise by utilising that
tactic. Given the sorry history of radicals doing so, this is unsurprising.
What is surprising is how so many Marxists are willing to ignore that history
in favour of Lenin's pamphlet.

## H.1.6 Why do anarchists try to _"build the new world in the shell of the
old"_?

Another key difference between anarchists and Marxists is on how the movement
against capitalism should organise in the here and now. Anarchists argue that
it should prefigure the society we desire - namely it should be self-managed,
decentralised, built and organised from the bottom-up in a federal structure.
This perspective can be seen from the justly famous _"Circular of the
Sixteen"_ issued at the Sonvillier congress by the libertarian wing of the
First International:

> _"The future society must be nothing else than the universalisation of the
organisation that the International has formed for itself. We must therefore
take care to make this organisation as close as possible to our ideal. How
could one want an equalitarian and free society to issue from an authoritarian
organisation? It is impossible. The International, the embryo of the future
human society is held to be henceforward, the faithful image of our principles
of liberty and of federation, and is considered to reject any principle
tending to authority and dictatorship."_ [quoted by K.J. Kenafick, **Michael
Bakunin and Karl Marx**, pp. 262-3]

Anarchists apply this insight to all organisations they take part in,
stressing that the only way we can create a self-managed society is by self-
managing our own struggles and organisations today. It is an essential part of
our politics that we encourage people to _"learn how to participate in the
life of the organisation and to do without leaders and permanent officials"_
and _"practice direct action, decentralisation, autonomy and free
initiative."_ This flows logically from our politics, as it is _"obvious that
anarchists should seek to apply to their personal and political lives this
same principle upon which, they believe, the whole of human society should be
based."_ [Malatesta, **The Anarchist Revolution**, p. 94] In this way we turn
our class organisations (indeed, the class struggle itself) into practical and
effective _"schools of anarchism"_ in which we learn to manage our own affairs
without hierarchy and bosses and so popular organisations become the cells of
the new society:

> _"Libertarian forms of organisation have the enormous responsibility of
trying to resemble the society they are seeking to develop. They can tolerate
no disjunction between ends and means. Direct action, so integral to the
management of a future society, has its parallel in the use of direct action
to change society. Communal forms, so integral to the structure of a future
society, have their parallel in the use of communal forms - collectives,
affinity groups, and the like - to change society. The ecological ethics,
confederal relationships, and decentralised structures we would expect to find
in a future society, are fostered by the values and networks we try to use in
achieving an ecological society."_ [Murray Bookchin, **The Ecology of
Freedom**, pp. 446-7]

Marxists reject this argument. Instead they stress the importance of
centralisation and consider the anarchist argument as utopian. For effective
struggle, strict centralisation is required as the capitalist class and state
is also centralised. In other words, to fight for socialism there is a need to
organise in a way which the capitalists have utilised - to fight fire with
fire. Unfortunately they forget to extinguish a fire you have to use water.
Adding more flame will only increase the combustion, **not** put it out!

Of course, Marx and Engels misrepresented the anarchist position. They
asserted that the anarchist position implied that the Paris Communards _"would
not have failed if they had understood that the Commune was 'the embryo of the
future human society' and had cast away all discipline and all arms, that is,
the things which must disappear when there are no more wars!"_ [**Collected
Works**, vol. 23, p. 115] Needless to say this is simply a slander on the
anarchist position particularly as anarchists are well aware of the need to
defend a revolution (see [section H.2.1](secH2.html#sech21)) and the need for
**self**-discipline (see [section H.4](secH4.html)). Anarchists, as the
Circular makes clear, recognise that we cannot totally reflect the future and
so the current movement can only be _"as near as possible to our ideal."_ Thus
we have to do things, such as fighting the bosses, rising in insurrection,
smashing the state or defending a revolution, which we would not have to do in
a socialist society. However, we can do these things in a manner which is
consistent with our values and our aims. For example, a strike can be run in
two ways. Either it can be managed via assemblies of strikers and co-ordinated
by councils of elected, mandated and recallable delegates or it can be run
from the top-down by a few trade union leaders. The former, of course, is the
anarchist way and it reflects _"the future human society"_ (and, ironically,
is paid lip-service to by Marxists).

Such common sense, unfortunately, was lacking in Marx and Engels, who instead
decided to utter nonsense for a cheap polemical point. Neither answered the
basic point - how do people become able to manage society if they do not
directly manage their own organisations and struggles today? How can a self-
managed society come about unless people practice it in the here and now? Can
people create a socialist society if they do not implement its basic ideas in
their current struggles and organisations? Equally, it would be churlish to
note that the Commune's system of federalism by mandated delegates had been
advocated by Bakunin for a number of years before 1871 and, unsurprisingly, he
took the revolt as a striking, if incomplete, confirmation of anarchism (see
[section A.5.1](secA5.html#seca51)).

The Paris Commune, it must be stressed, brought the contradictions of the
Marxist attacks on anarchism to the surface. It is deeply sad to read, say,
Engels attacking anarchists for holding certain positions yet praising the
1871 revolution when it implemented exactly the same ideas. For example, in
his deeply inaccurate diatribe _"The Bakuninists at Work"_, Engels was keen to
distort the federalist ideas of anarchism, dismissing _"the so-called
principles of anarchy, free federation of independent groups."_ [**Collected
Works**, vol. 23, p. 297] Compare this to his praise for the Paris Commune
which, he gushed, refuted the Blanquist notion of a revolution sprung by a
vanguard which would create _"the strictest, dictatorial centralisation of all
power in the hands of the new revolutionary government."_ Instead the Commune
_"appealed to [the provinces] to form a free federation of all French Communes
. . . a national organisation which for the first time was really created by
the nation itself. It was precisely the oppressing power of the former
centralised government . . . which was to fall everywhere, just as it had
fallen in Paris."_ [**Selected Writings**, pp. 256-7]

Likewise, Engels praised the fact that, to combat the independence of the
state from society, the Commune introduced wages for officials the same as
that _"received by other workers"_ and the use of _"the binding mandate to
delegates to representative bodies."_ [**Op. Cit.**, p. 258] Compare this to
Engels attack on anarchist support for binding mandates (which, like our
support for free federation, pre-dated the Commune). Then it was a case of
this being part of Bakunin's plans to control the international _"for a secret
society . . . there is nothing more convenient than the imperative mandate"_
as all its members vote one way, while the others will _"contradict one
another."_ Without these binding mandates, _"the common sense of the
independent delegates will swiftly unite them in a common party against the
party of the secret society."_ Obviously the notion that delegates from a
group should reflect the wishes of that group was lost on Engels. He even
questioned the utility of this system for _"if all electors gave their
delegates imperative mandates concerning all points in the agenda, meetings
and debates of the delegates would be superfluous."_ [**Collected Works**,
vol. 22, p. 281 and p. 277] It should be noted that Trotsky shared Engels
dislike of "representatives" being forced to actually represent the views of
their constituents within the party. [**In Defense of Marxism**, pp. 80-1]

Clearly a _"free federation"_ of Communes and binding mandates are bad when
anarchists advocate them but excellent when workers in revolt implement them!
Why this was the case Engels failed to explain. However, it does suggest that
the anarchist idea that we must reflect the future in how we organise today is
no hindrance to revolutionary change and, in fact, reflects what is required
to turn a revolt into a genuine social revolution.

Engels asserted that the anarchist position meant that _"the proletariat is
told to organise not in accordance with the requirements of the struggle . . .
but according to the vague notions of a future society entertained by some
dreamers."_ [**Op. Cit.**, vol. 23, p. 66] In this he was wrong, as he failed
to understand that the anarchist position was produced by the class struggle
itself. He failed to understand how that struggle reflects our aspirations for
a better world, how we see what is wrong with modern society and seek to
organise to end such abuses rather than perpetuate them in new forms. Thus the
trade unions which Bakunin argued would be the basis of a free society are
organised from the bottom-up and based upon the direct participation of the
workers. This form of organisation was not forced upon the workers by some
intellectuals thinking they were a good idea. Rather they were created to
fight the bosses and reflected the fact that workers were sick of being
treating as servants and did not wish to see that repeated in their own
organisations.

As Bakunin argued, when a union delegates authority to its officials it may be
_"very good for the committees, but [it is] not at all favourable for the
social, intellectual, and moral progress of the collective power of the
International."_ The committees _"substituted their own will and their own
ideas for that of the membership"_ while the membership expressed
_"indifference to general problems"_ and left _"all problems to the decisions
of committees."_ This could only be solved by _"call[ing] general membership
meetings,"_ that is _"popular assemblies."_ Bakunin goes on to argue that the
_"organisation of the International, having as its objective not the creation
of new despotism but the uprooting of all domination, will take on an
essentially different character than the organisation of the State."_ This
must be the _"organisation of the trade sections and their representation by
the Chambers of Labour"_ and these _"bear in themselves the living seeds of
the new society which is to replace the old world. They are creating not only
the ideas, but also the facts of the future itself."_ [**Bakunin on
Anarchism**, pp. 246-7 and p. 255]

Ou Shengbai, a Chinese anarchist, argued that libertarians _"deeply feel that
the causes of popular misery are these: (1) Because of the present political
system power is concentrated in a few hands with the result that the majority
of the people do not have the opportunity for free participation. (2) Because
of the capitalist system all means of production are concentrated in the hands
of the capitalists with the results that the benefits that ought to accrue to
labourers are usurped by capitalists._ [quoted by Arif Dirlik, **Anarchism in
the Chinese Revolution**, p. 235] Does it make much sense to organise in ways
which reflect these problems? Surely the reason why people become socialists
is because they seek to change society, to give the mass of the population an
opportunity for free participation and to manage their own affairs. Why
destroy those hopes and dreams by organising in a way which reflects the
society we oppose rather than the one we desire?

Ultimately, Engels dismissed the practical experiences of working class
people, dismissed our ability to create a better world and our ability to
dream. In fact, he seems to think there is some division of labour between
_"the proletariat"_ who do the struggling and _"some dreamers"_ who provide
the ideas. The notion that working class people can both struggle **and**
dream was lost on him, as was the notion that our dreams shape our struggles
and our struggles shape our dreams. People resist oppression and exploitation
because we want to determine what goes on in our lives and to manage our own
affairs. In that process, we create new forms of organisation which allows
that to happen, ones that reflect our dreams of a better world. This is not in
opposition to the needs of the struggle, as Engels asserted, but is rather an
expression of it. To dismiss this process, to advocate organisational methods
which are the very antithesis of what working class people have shown,
repeatedly, that they want, is the height of arrogance and, ultimately, little
more than a dismissal of the hopes, dreams and creative self-activity of
working class people. As libertarian socialist Cornelius Castoriadis put it:

> _"the organisation's inspiration can come only from the socialist structures
created by the working class in the course of its own history. It must let
itself be guided by the principles on which the soviet and the factory council
were founded . . . the principles of workers' management must govern the
operation and structure of the organisation. Apart from them, there are only
capitalist principles, which, as we have seen, can only result in the
establishment of capitalist relationships."_ [**Political and Social
Writings**, vol. 2, pp. 217-8]

Ironically enough, given their own and their followers claims of Marxism's
proletarian core, it was Marx and Engels who were at odds with the early
labour movement, **not** Bakunin and the anarchists. Historian Gwyn A.
Williams notes in the early British labour movement there were _"to be no
leaders"_ and the organisations were _"consciously modelled on the civil
society they wished to create."_ [**Artisans and Sans-Culottes**, p. 72]
Lenin, unsurprisingly, dismissed the fact that the British workers _"thought
it was an indispensable sign of democracy for all the members to do all the
work of managing the unions"_ as _"primitive democracy"_ and _"absurd."_ He
also complained about _"how widespread is the 'primitive' conception of
democracy among the masses of the students and workers"_ in Russia.
[**Essential Works of Lenin**, pp. 162-3] Clearly, the anarchist perspective
reflects the ideas of the workers' movement before it degenerates into
reformism and bureaucracy while Marxism reflects it during this process of
degeneration. Needless to say, the revolutionary nature of the early union
movement clearly shows who was correct!

Anarchists, in other words, simply generalised the experiences of the workers
in struggle and Bakunin and his followers were expressing a common position
held by many in the International. Even Marx paid lip-service to this when he
stated _"in contrast to old society . . . a new society is springing up"_ and
the _"Pioneer of that new society is the International Working Men's
Association."_ [**Selected Works**, p. 263] Clearly, considering the
International as the embryo of the future society is worthy only of scorn as
the correct position is to consider it merely as a pioneer!

As such, libertarians _"lay no claims to originality in proposing this [kind
of prefigurative organisation]. In every revolution, during most strikes and
daily at the level of workshop organisation, the working class resorts to this
type of direct democracy."_ [Maurice Brinton, **For Workers' Power**, p. 48]
Given how Marxists pay lip-service to such forms of working class self-
organisation, it seems amusing to hear them argue that this is correct for
everyone else but not themselves and their own organisations! Apparently, the
same workers who are expected to have the determination and consciousness
necessary to overthrow capitalism and create a new world in the future are
unable to organise themselves in a socialist manner today. Instead, we have to
tolerate so-called "revolutionary" organisations which are just as
hierarchical, top-down and centralised as the system which provoked our anger
at its injustice in the first and which we are trying to end!

Related to this is the fact that Marxists (particularly Leninists) favour
centralisation while anarchists favour decentralisation within a federal
organisation. Anarchists do not think that decentralisation implies isolation
or narrow localism. We have always stressed the importance of federalism to
co-ordinate decisions. Power would be decentralised, but federalism ensures
collective decisions and action. Under centralised systems, anarchists argue,
power is placed into the hands of a few leaders. Rather than the real
interests and needs of the people being co-ordinated, centralism simply means
the imposition of the will of a handful of leaders, who claim to "represent"
the masses. Co-ordination from below, in other words, is replaced by coercion
from above in the centralised system and the needs and interests of all are
replaced by those of a few leaders at the centre.

Such a centralised, inevitably top-down, system can only be counter-
productive, both practically and in terms of generating socialist
consciousness:

> _"Bolsheviks argue that to fight the highly centralised forces of modern
capitalism requires an equally centralised type of party. This ignores the
fact that capitalist centralisation is based on coercion and force and the
exclusion of the overwhelming majority of the population from participating in
any of its decisions . . . _

> _"The very structure of these organisations ensures that their personnel do
not think for themselves, but unquestioningly carry out the instructions of
their superiors . . . _

> _"Advocates of 'democratic centralism' insist that it is the only type of
organisations which can function effectively under conditions of illegality.
This is nonsense. The 'democratic centralist' organisation is particularly
vulnerable to police persecution. When all power is concentrated in the hands
of the leaders, their arrest immediately paralyses the whole organisation.
Members trained to accept unquestioningly the instruction of an all-wise
Central Committee will find it very difficult to think and act for themselves.
The experiences of the German Communist Party [under the Nazis] confirm this.
With their usual inconsistency, the Trotskyists even explain the demise of
their Western European sections during World War II by telling people how
their leaders were murdered by the Gestapo!"_ [Maurice Brinton, **Op. Cit.**,
p. 43]

As we discuss in depth in [section H.5](secH5.html) the Leninist vanguard
party does, ironically, create in embryo a new world simply because once in
power it refashions society in **its** image. However, no anarchist would
consider such a centralised, hierarchical top-down class system rooted in
bureaucratic power as being remotely desirable or remotely socialist.

Therefore anarchists _"recognised neither the state nor pyramidal
organisation"_ Kropotkin argued, while Marxists _"recognised the state and
pyramidal methods of organisation"_ which _"stifled the revolutionary spirit
of the rank-and-file workers."_ [**Conquest of Bread and Other Writings**, p.
212] The Marxist perspective inevitably places power into the hands of a few
leaders, who then decree which movements to support and encourage based on
what is best for the long term benefit of the party itself rather than the
working class. Thus we find Engels arguing while Marxists were _"obliged to
support every **real** popular movement"_ they also had to ensure _"that the
scarcely formed nucleus of our proletarian Party is not sacrificed in vain and
that the proletariat is not decimated in futile local revolts,"_ for example
_"a blood-letting like that of 1871 in Paris."_ [Marx and Engels, **The
Socialist Revolution**, p. 294 and p. 320] This produces a conservative
approach to social struggle, with mass actions and revolutionary situations
ignored or warned against because of the potential harm it could inflict on
the party. Unsurprisingly, every popular revolution has occurred against the
advice of the so-called "revolutionary" Marxist leadership including the Paris
Commune and the 1917 February revolution in Russia (even the October seize of
power was done in the face of resistance from the Bolshevik party machine).

It is for these reasons that anarchists _"[a]s much as is humanly possible . .
. try to reflect the liberated society they seek to achieve"_ and _"not
slavishly duplicate the prevailing system of hierarchy, class and authority."_
Rather than being the abstract dreams of isolated thinkers, these
_"conclusions . . . emerge from an exacting study of past revolutions, of the
impact centralised parties have had on the revolutionary process"_ and history
has more than confirmed the anarchist warning that the _"revolutionary party,
by duplicating these centralistic, hierarchical features would reproduce
hierarchy and centralism in the post revolutionary society."_ [Murray
Bookchin, **Post-Scarcity Anarchism**, p. 138, p. 139 and p. 137] Moreover, we
base our arguments on how social movements should organise on the experiences
of past struggles, of the forms of organisation spontaneously produced by
those struggles and which, therefore, reflect the needs of those struggles and
the desire for a better way of life which produced them. Ultimately, no one
knows when a revolution turns the hopes and aspirations of today into
tomorrow's reality and it would be wise to have some experience of managing
our own affairs before hand.

By failing to understand the importance of applying a vision of a free society
to the current class struggle, Marxists help ensure that society never is
created. By copying bourgeois methods within their "revolutionary"
organisations (parties and unions) they ensure bourgeois ends (inequality and
oppression).

## H.1.7 Haven't you read Lenin's _"State and Revolution"_?

This question is often asked of people who critique Marxism, particularly its
Leninist form. Lenin's **State and Revolution** is often considered his most
democratic work and Leninists are quick to point to it as proof that Lenin and
those who follow his ideas are not authoritarian. As such, it is an important
question. So how do anarchists reply when people point them to Lenin's work as
evidence of the democratic (even libertarian) nature of Marxism? Anarchists
reply in two ways.

Firstly, we argue many of the essential features of Lenin's ideas are to be
found in anarchist theory and, in fact, had been aspects of anarchism for
decades **before** Lenin put pen to paper. Bakunin, for example, talked about
mandated delegates from workplaces federating into workers' councils as the
framework of a (libertarian) socialist society in the 1860s as well as popular
militias to defend a revolution. Moreover, he was well aware that revolution
was a **process** rather than an event and so would take time to develop and
flourish. Hence Murray Bookchin:

> _"Bakunin, Kropotkin, and Malatesta were not so naive as to believe that
anarchism could be established over night. In imputing this notion to Bakunin,
Marx and Engels wilfully distorted the Russian anarchist's views. Nor did the
anarchists . . . believe that abolition of the state involved 'laying down of
arms' immediately after the revolution, to use Marx's obscurantist choice of
terms, thoughtlessly repeated by Lenin in **State and Revolution**. Indeed,
much that passes for 'Marxism' in **State and Revolution** is pure anarchism -
for example, the substitution of revolutionary militias for professional armed
bodies and the substitution of organs of self-management for parliamentary
bodies. What is authentically Marxist in Lenin's pamphlet is the demand for
'strict centralism,' the acceptance of a 'new' bureaucracy, and the
identification of soviets with a state."_ [**Post-Scarcity Anarchism**, p.
137]

That this is the case is hidden in Lenin's work as he deliberately distorts
anarchist ideas in it (see sections [H.1.3](secH1.html#sech13) and
[H.1.4](secH1.html#sech14) for example). Therefore, when Marxists ask whether
anarchists have read Lenin's **State and Revolution** we reply by arguing that
most of Lenin's ideas were first expressed by anarchists and his work just
strikes anarchists as little more than a re-hash of many of our own ideas but
placed in a statist context which totally and utterly undermines them in
favour of party rule.

Secondly, anarchists argue that regardless of what Lenin argued for in **State
and Revolution**, he did not apply those ideas in practice (indeed, he did the
exact opposite). Therefore, the question of whether we have read Lenin's work
simply drives home the ideological nature and theoretical bankruptcy of
Leninism. This is because the person is asking you to evaluate their politics
based on what they say rather than on what they do, like any politician.

To use an analogy, what would you say to a politician who has cut welfare
spending by 50% and increased spending on the military and who argues that
this act is irrelevant and that you should look at their manifesto which
states that they were going to do the opposite? You would dismiss this
argument as laughable and them as liars as you would evaluate them by their
actions, not by what they say. Leninists, by urging you to read Lenin's
**State and Revolution** are asking you to evaluate them by what their
manifesto says and ignore what they did. Anarchists, on the other hand, ask
you to evaluate the Leninist manifesto by comparing it to what they actually
did in power. Such an evaluation is the only means by which we can judge the
validity of Leninist claims and politics.

As we discuss the role of Leninist ideology in the fate of the Russian
Revolution in [section H.6](secH6.html) we will provide a summary of Lenin's
claims in his famous work **State and Revolution** and what he did in practice
here. Suffice to say the difference between reality and rhetoric was extremely
large and, therefore, it is a damning indictment of Bolshevism. Post-October,
the Bolsheviks not only failed to introduce the ideas of Lenin's book, they in
fact introduced the exact opposite. As one historian puts it:

> _"To consider 'State and Revolution' as the basic statement of Lenin's
political philosophy - which non-Communists as well as Communists usually do -
is a serious error. Its argument for a utopian anarchism never actually became
official policy. The Leninism of 1917 . . . came to grief in a few short
years; it was the revived Leninism of 1902 which prevailed as the basis for
the political development of the USSR."_ [Robert V. Daniels, **The Conscience
of the Revolution**, pp. 51-2]

Daniels is being far too lenient with the Bolsheviks. It was not, in fact, _"a
few short years"_ before the promises of 1917 were broken. In some cases, it
was a few short hours. In others, a few short months. However, in a sense
Daniels is right. It did take until 1921 before all hope for saving the
Russian Revolution finally ended.

Simply put, if the **State and Revolution** is the manifesto of Bolshevism,
then not a single promise in that work was kept by the Bolsheviks when they
got into power. As such, Lenin's work cannot be used to evaluate Bolshevik
ideology as Bolshevism paid no attention to it once it had taken state power.
While Lenin and his followers chant rhapsodies about the Soviet State (this
'highest and most perfect system of democracy") they quickly turned its
democratic ideas into a fairy-tale, and an ugly fairy-tale at that, by simply
ignoring it in favour of party power (and party dictatorship). To state the
obvious, to quote theory and not relate it to the practice of those who claim
to follow it is a joke. If you look at the actions of the Bolsheviks after the
October Russian Revolution you cannot help draw the conclusion that Lenin's
**State and Revolution** has nothing to do with Bolshevik policy and presents
a false image of what Leninists desire. As such, we must present a comparison
between rhetoric and realty.

In order to show that this is the case, we need to summarise the main ideas
contained in Lenin's work. Moreover, we need to indicate what the Bolsheviks
did, in fact, do. Finally, we need to see if the various rationales justifying
these actions hold water.

So what did Lenin argue for in **State and Revolution**? Writing in the mid-
1930s, anarchist Camillo Berneri summarised the main ideas of that work as
follows:

> _"The Leninist programme of 1917 included these points: the discontinuance
of the police and standing army, abolition of the professional bureaucracy,
elections for all public positions and offices, revocability of all officials,
equality of bureaucratic wages with workers' wages, the maximum of democracy,
peaceful competition among the parties within the soviets, abolition of the
death penalty."_ [_"The Abolition and Extinction of the State,"_ pp. 50-1,
**Cienfuegos Press Anarchist Review**, no. 4, p. 50]

As he noted, _"[n]ot a single one of the points of this programme has been
achieved."_ This was, of course, under Stalinism and most Leninists will
concur with Berneri. However what Leninists tend not to mention is that by the
end of the 7 month period of Bolshevik rule before the start of the civil war
(i.e., from November 1917 to May 1918) none of these points existed. So, as an
example of what Bolshevism "really" stands for it seems strange to harp on
about a work which was never really implemented when the its author was in a
position to do so (i.e. before the onslaught of a civil war Lenin thought was
inevitable anyway!). Similarly, if **State and Revolution** indicates the
features a "workers' state" must have then, by May 1918, Russia did not have
such a state and so, logically, it can be considered as such only if we assume
that the good intentions of its rulers somehow overcome its political and
economic structure (which, sadly, **is** the basic Trotskyist defence of
Leninism against Stalinism!).

To see that Berneri's summary is correct, we need to quote Lenin directly.
Obviously the work is a wide ranging defence of Lenin's interpretation of
Marxist theory on the state. As it is an attempt to overturn decades of
Marxist orthodoxy, much of the work is quotes from Marx and Engels and Lenin's
attempts to enlist them for his case (we discuss this issue in [section
H.3.10](secH3.html#sech310)). Equally, we need to ignore the numerous straw
men arguments about anarchism Lenin inflicts on his reader. Here we simply
list the key points as regards Lenin's arguments about his "workers' state"
and how the workers would maintain control of it:

> 1) Using the Paris Commune as a prototype, Lenin argued for the abolition of
_"parliamentarianism"_ by turning _"representative institutions from mere
'talking shops' into working bodies."_ This would be done by removing _"the
division of labour between the legislative and the executive."_ [**Essential
Works of Lenin**, p. 304 and p. 306]

> 2) _"All officials, without exception, to be elected and subject to recall
**at any time**"_ and so _"directly responsible to their constituents."_
[**Op. Cit.**, p. 302 and p. 306]

> 3) The _"immediate introduction of control and superintendence by **all,**
so that **all** shall become 'bureaucrats' for a time and so that, therefore,
**no one** can become a 'bureaucrat'."_ Proletarian democracy would _"take
immediate steps to cut bureaucracy down to the roots . . . to the complete
abolition of bureaucracy"_ as the _"**essence** of bureaucracy"_ is officials
becoming transformed_" into privileged persons divorced from the masses and
**superior to** the masses."_ [**Op. Cit.**, p. 355 and p. 360]

> 4) There should be no _"special bodies of armed men"_ standing apart from
the people _"since the majority of the people itself suppresses its
oppressors, a 'special force' is no longer necessary."_ Using the example of
the Paris Commune, Lenin suggested this meant _"abolition of the standing
army"_ by the _"armed masses."_ [**Op. Cit.**, p. 275, p. 301 and p. 339]

> 5) The new (workers) state would be _"the organisation of violence for the
suppression of . . . the exploiting class, i.e. the bourgeoisie. The toilers
need a state only to overcome the resistance of the exploiters"_ who are _"an
insignificant minority,"_ that is _"the landlords and the capitalists."_ This
would see _"an immense expansion of democracy . . . for the poor, democracy
for the people"_ while, simultaneously, imposing _"a series of restrictions on
the freedom of the oppressors, the exploiters, the capitalists . . . their
resistance must be broken by force: it is clear that where there is
suppression there is also violence, there is no freedom, no democracy."_
[**Op. Cit.**, p. 287 and pp. 337-8]

This would be implemented after the current, bourgeois, state had been
smashed. This would be the _"dictatorship of the proletariat"_ and be _"the
introduction of complete democracy for the people."_ [**Op. Cit.**, p. 355]
However, the key practical ideas on what the new "semi-state" would be are
contained in these five points. He generalised these points, considering them
valid for all countries.

The first point was the combining of legislative and executive functions in
"working bodies". The first body to be created by the Bolshevik revolution was
the "Council of People's Commissars" (CPC) This was a government separate from
and above the Central Executive Committee (CEC) of the soviets congress which,
in turn, was separate from and above the national soviet congress. It was an
executive body elected by the soviet congress, but the soviets themselves were
not turned into "working bodies." The promises of Lenin's **State and
Revolution** did not last the night.

The Bolsheviks, it must be stressed, clearly recognised that the Soviets had
alienated their power to this body with the party's Central Committee arguing
in November 1917 that _"it is impossible to refuse a purely Bolshevik
government without treason to the slogan of the power of the Soviets, since a
majority at the Second All-Russian Congress of Soviets . . . handed power over
to this government."_ [contained in Robert V. Daniels (ed.), **A Documentary
History of Communism**, vol. 1, pp. 128-9] However, it could be argued that
Lenin's promises were kept as the new government simply gave itself
legislative powers four days later. Sadly, this is not the case. In the Paris
Commune the delegates of the people took executive power into their own hands.
Lenin reversed this and his executive took legislative power from the hands of
the people's delegates. As we discuss in [section H.6.1](secH6.html#sech61),
this concentration of power into executive committees occurred at all levels
of the soviet hierarchy.

What of the next principle, namely the election and recall of all officials?
This lasted slightly longer, namely around 5 months. By March of 1918, the
Bolsheviks started a systematic campaign against the elective principle in the
workplace, in the military and even in the soviets. In the workplace, Lenin
was arguing for appointed one-man managers _"vested with dictatorial powers"_
by April 1918 (see [section H.3.14](secH3.html#sech314)). In the military,
Trotsky simply decreed the end of elected officers in favour of appointed
officers. As far as the soviets go, the Bolsheviks were refusing to hold
elections because they _"feared that the opposition parties would show
gains."_ When elections were held, _"Bolshevik armed force usually overthrew
the results"_ in provincial towns. Moreover, the Bolsheviks _"pack[ed] local
soviets"_ with representatives of organisations they controlled _"once they
could not longer count on an electoral majority."_ [Samuel Farber, **Before
Stalinism**, p. 22, p. 24 and p. 33] This kind of packing was even practised
at the national level when the Bolsheviks gerrymandered a Bolshevik majority
at the Fifth Congress of Soviets. So much for competition among the parties
within the soviets! And as far as the right of recall went, the Bolsheviks
only supported this when the workers were recalling the opponents of the
Bolsheviks, not when the workers were recalling them.

Then there was the elimination of bureaucracy. The new state soon had a new
bureaucratic and centralised system quickly emerge around it. Rather than
immediately cutting the size and power of the bureaucracy, it _"grew by leaps
and bounds. Control over the new bureaucracy constantly diminished, partly
because no genuine opposition existed. The alienation between 'people' and
'officials,' which the soviet system was supposed to remove, was back again.
Beginning in 1918, complaints about 'bureaucratic excesses,' lack of contact
with voters, and new proletarian bureaucrats grew louder and louder."_ [Oskar
Anweiler, **The Soviets**, p. 242] So the rise of a state bureaucracy started
immediately with the seizure of power by the Bolsheviks, particularly as the
state's functions grew to include economic decisions as well as political
ones. Instead of the state starting to _"wither away"_ it grew:

> _"The old state's political apparatus was 'smashed,' but in its place a new
bureaucratic and centralised system emerged with extraordinary rapidity. After
the transfer of government to Moscow in March 1918 it continued to expand . .
. As the functions of the state expanded so did the bureaucracy, and by August
1918 nearly a third of Moscow's working population were employed in offices.
The great increase in the number of employees . . . took place in early to
mid-1918 and, thereafter, despite many campaigns to reduce their number, they
remained a steady proportion of the falling population"_ [Richard Sakwa, _"The
Commune State in Moscow in 1918,"_ pp. 429-449, **Slavic Review**, vol. 46,
no. 3/4, pp. 437-8]

This, anarchists would stress, is an inherent feature of centralised systems.
As such, this rise of bureaucracy confirmed anarchist predictions that
centralisation will recreate bureaucracy. After all, some means were required
to gather, collate and provide information by which the central bodies made
their decisions. Overtime, this permanent collection of bodies would become
the real power in the state, with the party members nominally in charge really
under the control of an unelected and uncontrolled officialdom. Thus a
necessary side-effect of Bolshevik centralism was bureaucracy and it soon
became the real power in the state (and, ultimately, in the 1920s became the
social base for the rise of Stalin). This is to be expected as any state _"is
already a privileged class and cut off from the people"_ and would _"seek to
extend its powers, to be beyond public control, to impose its own policies and
to give priority to special interests."_ Moreover, _"what an all-powerful,
oppressive, all-absorbing oligarchy must be one which has at its services,
that is at its disposal, all social wealth, all public services."_ [Malatesta,
**Anarchy**, p. 36 and p. 37]

Then there is the fourth point, namely the elimination of the standing army,
the suppression of _"special bodies of armed men"_ by the _"armed masses."_
This promise did not last two months. On the 20th of December, 1917, the
Council of People's Commissars decreed the formation of a political (secret)
police force, the _"Extraordinary Commission to Fight Counter-Revolution."_
This was more commonly known by the Russian initials of the first two terms of
its official name: The Cheka.

While it was initially a small organisation, as 1918 progressed it grew in
size and activity. The Cheka soon became a key instrument of Bolshevik rule
and it was most definitely a _"special body of armed men"_ and not the same as
the _"armed workers."_ In other words, Lenin's claims in **State and
Revolution** did not last two months and in under six months the Bolshevik
state had a mighty group of _"armed men"_ to impose its will. This is not all.
The Bolsheviks also conducted a sweeping transformation of the military within
the first six months of taking power. During 1917, the soldiers and sailors
(encouraged by the Bolsheviks and other revolutionaries) had formed their own
committees and elected officers. In March 1918, Trotsky simply abolished all
this by decree and replaced it with appointed officers (usually ex-Tsarist
ones). In this way, the Red Army was turned from a workers' militia (i.e. an
armed people) into a _"special body"_ separate from the general population.

So instead of eliminating a _"special force"_ above the people, the Bolsheviks
did the opposite by creating a political police force (the Cheka) and a
standing army (in which elections were a set aside by decree). These were
special, professional, armed forces standing apart from the people and
unaccountable to them. Indeed, they were used to repress strikes and working
class unrest which refutes the idea that Lenin's "workers' state" would simply
be an instrument of violence directed at the exploiters. As the Bolsheviks
lost popular support, they turned the violence of the "worker's state" against
the workers (and, of course, the peasants). When the Bolsheviks lost soviet
elections, force was used to disband them. Faced with strikes and working
class protest during this period, the Bolsheviks responded with state violence
(see [section H.6.3](secH6.html#sech63)). So, as regards the claim that the
new ("workers") state would repress only the exploiters, the truth was that it
was used to repress whoever opposed Bolshevik power, including workers and
peasants. If, as Lenin stressed, _"where there is suppression there is also
violence, there is no freedom, no democracy"_ then there cannot be working
class freedom or democracy if the "workers' state" is suppressing that class.

As can be seen, after the first six months of Bolshevik rule not a single
measure advocated by Lenin in **State and Revolution** existed in
"revolutionary" Russia. Some of the promises were broken quite quickly
(overnight, in one case). Most took longer. Yet Leninists may object by noting
that many Bolshevik degrees did, in fact, reflect **State and Revolution**.
For example, the democratisation of the armed forces was decreed in late
December 1917. However, this was simply acknowledging the existing
revolutionary gains of the military personnel. Similarly, the Bolsheviks
passed a decree on workers' control which, again, simply acknowledged the
actual gains by the grassroots (and, in fact, limited them for further
development).

Yet this cannot be taken as evidence of the democratic nature of Bolshevism as
most governments faced with a revolutionary movement will acknowledge and
"legalise" the facts on the ground (until such time as they can neutralise or
destroy them). For example, the Provisional Government created after the
February Revolution also legalised the revolutionary gains of the workers (for
example, legalising the soviets, factory committees, unions, strikes and so
forth). The real question is whether Bolshevism continued to encourage these
revolutionary gains once it had consolidated its power. It did not. Indeed, it
can be argued that the Bolsheviks simply managed to do what the Provisional
Government it replaced had failed to do, namely destroy the various organs of
popular self-management created by the revolutionary masses. So the
significant fact is not that the Bolsheviks recognised the gains of the masses
but that their toleration of the application of what their followers say were
their real principles did not last long and, significantly, the leading
Bolsheviks did not consider the abolition of such principles as harming the
"communist" nature of the regime.

We have stressed this period for a reason. This was the period **before** the
out-break of major Civil War and thus the policies applied show the actual
nature of Bolshevism, it's essence if you like. This is a significant period
as most Leninists blame the failure of Lenin to live up to his promises on
this event. In reality, the civil war was **not** the reason for these
betrayals - simply because it had not started yet. Each of the promises were
broken in turn months before the civil war happened. _"All Power to the
Soviets"_ became, very quickly, "All Power to the Bolsheviks." Unsurprisingly,
as this was Lenin's aim all along and so we find him in 1917 continually
repeating this basic idea (see [section H.3.3](secH3.html#sech33)).

Given this, the almost utter non-mention of the party and its role in **State
and Revolution** is deeply significant. Given the emphasis that Lenin had
always placed on the party, it's absence is worrying. When the party is
mentioned in that work, it is done so in an ambiguous manner. For example,
Lenin noted that _"[b]y educating the workers' party, Marxism educates the
vanguard of the proletariat which is capable of assuming power and of
**leading the whole people** to socialism, of directing and organising the new
order."_ It is not clear whether it is the vanguard or the proletariat as a
whole which assumes power. Later, he stated that _"the dictatorship of the
proletariat"_ was _"the organisation of the vanguard of the oppressed as the
ruling class for the purpose of crushing the oppressors."_ [**Essential Works
of Lenin**, p. 288 and p. 337] Based on subsequent Bolshevik practice after
the party seized power, it seems clear that it is the vanguard which assumes
power rather than the whole class.

As such, given this clear and unambiguous position throughout 1917 by Lenin,
it seems incredulous, to say the least, for Leninist Tony Cliff to assert that
_"[t]o start with Lenin spoke of the **proletariat,** the **class** \- not the
Bolshevik Party - assuming state power."_ [**Lenin**, vol. 3, p. 161] Surely
the title of one of Lenin's most famous pre-October essays, usually translated
as _"Can the Bolsheviks Retain State Power?"_, should have given the game
away? As would, surely, quoting numerous calls by Lenin for the Bolsheviks to
seize power? Apparently not.

Where does that leave Lenin's **State and Revolution**? Well, modern-day
Leninists still urge us to read it, considering it his greatest work and the
best introduction to what Leninism really stands for. For example, we find
Leninist Tony Cliff calling that book _"Lenin's real testament"_ while, at the
same time, acknowledging that its _"message . . . which was the guide for the
first victorious proletarian revolution, was violated again and again during
the civil war."_ Not a very good _"guide"_ or that convincing a _"message"_ if
it was not applicable in the very circumstances it was designed to be applied
in (a bit like saying you have an excellent umbrella but it only works when it
is not raining). Moreover, Cliff is factually incorrect. As we discuss in
[section H.6](secH6.html), the Bolsheviks _"violated"_ that _"guide"_ before
the civil war started (i.e. when _"the victories of the Czechoslovak troops
over the Red Army in June 1918, that threatened the greatest danger to the
Soviet republic,"_ to quote Cliff). [**Op. Cit.**, p. 161 and p. 18]
Similarly, much of the economic policies implemented by the Bolsheviks had
their roots in that book and the other writings by Lenin from 1917.

The conclusions of dissident Marxist Samuel Farber seem appropriate here. As
he puts it, _"the very fact that a Sovnarkom had been created as a separate
body from the CEC [Central Executive Committee] of the soviets clearly
indicates that, Lenin's **State and Revolution** notwithstanding, the
separation of at least the top bodies of the executive and the legislative
wings of the government remained in effect in the new Soviet system."_ This
suggests _"that **State and Revolution** did not play a decisive role as a
source of policy guidelines for 'Leninism in power.'"_ After all,
_"immediately after the Revolution the Bolsheviks established an executive
power . . . as a clearly separate body from the leading body of the
legislature . . . Therefore, some sections of the contemporary Left appear to
have greatly overestimated the importance that **State and Revolution** had
for Lenin's government. I would suggest that this document . . . can be better
understood as a distant, although doubtless sincere [!], socio-political
vision . . . as opposed to its having been a programmatic political statement,
let alone a guide to action, for the period immediately after the successful
seizure of power."_ [**Op. Cit.**, pp. 20-1 and p. 38]

That is **one** way of looking at it. Another would be to draw the conclusion
that a _"distant . . . socio-political vision"_ drawn up to sound like a
_"guide to action"_ which was then immediately ignored is, at worse, little
more than a deception, or, at best, a theoretical justification for seizing
power in the face of orthodox Marxist dogma. Whatever the rationale for Lenin
writing his book, one thing is true - it was never implemented. Strange, then,
that Leninists today urge us to read it to see what "Lenin really wanted."
Particularly given that so few of its promises were actually implemented
(those that were just recognised the facts on the ground) and **all** of them
were no longer applied in less than six months after the seize of power.

It will be objected in defence of Leninism that it is unfair to hold Lenin
responsible for the failure to apply his ideas in practice. The terrible Civil
War, in which Soviet Russia was attacked by numerous armies, and the resulting
economic chaos meant that the objective circumstances made it impossible to
implement his democratic ideas. This argument contains flaws. Firstly, as we
indicated above, the undemocratic policies of the Bolsheviks started
**before** the start of the Civil War (so suggesting that the hardships of the
Civil War were not to blame). Secondly, Lenin himself mocked those who argued
that revolution was out of the question because of difficult circumstances and
so to blame these for the failure of the Bolsheviks to apply the ideas in
**State and Revolution** means to argue that those ideas are inappropriate for
a revolution (which, we must stress, is what the leading Bolsheviks actually
**did** end up arguing by their support for party dictatorship). You cannot
have it both ways.

Lenin at no time indicated in **State and Revolution** that it was impossible
or inapplicable to apply those ideas during a revolution in Russia (quite the
reverse!). Given that Marxists, including Lenin, argue that a "dictatorship of
the proletariat" is required to defend the revolution against capitalist
resistance it seems incredulous to argue that Lenin's major theoretical work
on that regime was impossible to apply in precisely the circumstances it was
designed for.

All in all, discussing Lenin's **State and Revolution** without indicating
that the Bolsheviks failed to implement its ideas (indeed, did the exact
opposite) suggests a lack of honesty. It also suggests that the libertarian
ideas Lenin appropriated in that work could not survive being grafted onto the
statist ideas of mainstream Marxism. In the words of historian Marc Ferro:

> _"In a way, **The State and Revolution** even laid the foundations and
sketched out the essential features of an alternative to Bolshevik power, and
only the pro-Leninist tradition has used it, almost to quieten its conscience,
because Lenin, once in power, ignored its conclusions. The Bolsheviks, far
from causing the state to wither away, found endless reasons for justifying
its enforcement."_ [**October 1917**, pp. 213-4]

Anarchists would suggest that this alternative was anarchism. The Russian
Revolution shows that a workers state, as anarchists have long argued, means
minority power, not working class self-management of society. As such, Lenin's
work indicates the contradictory nature of Marxism - while claiming to support
democratic/libertarian ideals they promote structures (such as centralised
states) which undermine those values in favour of party rule. The lesson is
clear, only libertarian means can ensure libertarian ends and they have to be
applied consistently within libertarian structures to work. To apply them to
statist ones will simply fail.

[‹ H.0 Section H Introduction](/afaq/secHint.html "Go to previous page" )
[up](/afaq/secHcon.html "Go to parent page" ) [H.2 What parts of anarchism do
Marxists particularly misrepresent? ›](/afaq/secH2.html "Go to next page" )

