// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "lowercaseaddrfilter.h"
#include <cctype>

lowercaseAddrFilter::lowercaseAddrFilter() :
		strPrefix( "lowercase" ),
		strName( "Lowercase Addressfilter" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <te@profzone.ch>" ),
		strHelp( "Convert all mixedcase addresses to lowercase." )
{
	addParam( "disable", "Set to disable the lowercase filter.", "This is a flag.", FLAG, "0" );
}

lowercaseAddrFilter::~lowercaseAddrFilter()
{}

bool lowercaseAddrFilter::init( void )
{
	enabled = !getFlagParam( "disable" );
	return true;
}

bool lowercaseAddrFilter::checkAddr( std::string &addr )
{
	if ( !enabled ) return false;

	std::string::size_type i;
	for ( i = 0; i < addr.size(); i++ )
		addr[ i ] = tolower( addr[ i ] );

	return true;
};
