// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "mfanalyse.h"

mfAnalyse::mfAnalyse() :
		strPrefix( "mf" ),
		strName( "Mailcount from someone" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <te@profzone.ch>" ),
		strHelp( "Create statistics how many mails sent from local or external (to local)." )
{
	addParam( "limit", "Limit Output to n Lines.", "Integer from 1 to x.", G_STRING, "25" );
	addParam( "no-delivery", "Statistic with not delivered mail",
		"If set, not delivered mails are included.", G_FLAG, "0" );
	addParam( "only-no-delivery", "Statistic ONLY with not delivered mail",
		"If set, ONLY not delivered mails are included.", G_FLAG, "0" );
	addParam( "limit-to", "Maximum recipients shown.",
		"Integer from 1 to x.", STRING, "5" );
}

void mfAnalyse::run( std::map< std::string, unity_t > * unity_map )
{
	bool not_del = false;
	bool del = true;

	std::map< std::string, long > mailc_l_c;
	std::map< std::string, long > mailc_e_c;

	std::map< std::string, unity_t >::iterator i;
	std::map< std::string, long >::iterator j;

	if ( getFlagParam( "no-delivery" ) ) not_del = true; // Auch falsche;
	if ( getFlagParam( "only-no-delivery" ) )  // Hat auch vorrang.
	{
		not_del = true;
		del = false;
	};

	for ( i = unity_map->begin(); i != unity_map->end(); i++ )
	{
		// Nichtzugestellte oder zugestellte Mails aus statistik entfernen.
		if ( !not_del && ( i->second.to_intern.size() + i->second.to_extern.size() == 0 ) ) continue;
		if ( !del && ( i->second.to_intern.size() + i->second.to_extern.size() != 0 ) ) continue;

		if ( i->second.from.find( "@" ) != std::string::npos )
			mailc_e_c[ i->second.from ] ++;
		else
			mailc_l_c[ i->second.from ] ++;
	}
	// Temp map umrechnen.
	for ( j = mailc_l_c.begin(); j != mailc_l_c.end(); j++ )
		mailc_l.insert( std::make_pair( j->second, j->first ) );
	for ( j = mailc_e_c.begin(); j != mailc_e_c.end(); j++ )
		mailc_e.insert( std::make_pair( j->second, j->first ) );
}

void mfAnalyse::print( void )
{
	if ( !report ) return ; // be sure :-)

	std::multimap< long, std::string >::reverse_iterator j, k;
	int limit = getIntParam( "limit" );

	report->startNewReport( "Mailcount From someone - sended mails", Report::TABLE );
	report->addCol( 4, Report::COUNTER, Report::RIGHT, "nr", Report::NONE );
	// -1 = soviel platz verwenden, wie noch vorhanden.
	report->addCol( 16, Report::STRING, Report::LEFT, "from local", Report::NONE );
	report->addCol( 7, Report::INTEGER, Report::RIGHT, "total", Report::NONE, Report::SUM );
	report->addCol( -1, Report::STRING, Report::LEFT, "from external", Report::NONE );
	report->addCol( 7, Report::INTEGER, Report::RIGHT, "total", Report::NONE, Report::SUM );
	report->printHeader();
	j = mailc_l.rbegin();
	k = mailc_e.rbegin();

	while ( ( j != mailc_l.rend() || k != mailc_e.rend() ) && ( limit-- > 0 ) )
	{
		if ( j != mailc_l.rend() )
		{
			report->printField( j->second );
			report->printField( j->first );
			j++;
		}
		else
		{
			report->skipField();
			report->skipField();
		};
		if ( k != mailc_e.rend() )
		{
			report->printField( k->second );
			report->printField( k->first );
			k++;
		}
		else
		{
			report->skipField();
			report->skipField();
		};
	}
	report->printFooter();
}

void mfAnalyse::free( void )
{

	mailc_l.clear();
	mailc_e.clear();
}
