// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "xtanalyse.h"

xtAnalyse::xtAnalyse() :
		strPrefix( "xt" ),
		strName( "To External Traffic" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <te@profzone.ch>" ),
		strHelp( "Create statistics about all trafic to external recipients." )
{
	addParam( "limit", "Limit Output to n Lines.", "Integer from 1 to x.", G_STRING, "25" );
	addParam( "no-delivery", "Statistic with not delivered mail",
		"If set, not delivered mails are included.", G_FLAG, "0" );
	addParam( "only-no-delivery", "Statistic ONLY with not delivered mail",
		"If set, ONLY not delivered mails are included.", G_FLAG, "0" );
}

void xtAnalyse::run( std::map< std::string, unity_t > * unity_map )
{
	bool not_del = false;
	bool del = true;

	std::map< std::string, long > extern_traffic_c;

	std::map< std::string, unity_t >::iterator i;
	std::list< std::string >::iterator m;
	std::map< std::string, long >::iterator j;

	if ( getFlagParam( "no-delivery" ) ) not_del = true; // bounces to
	if ( getFlagParam( "only-no-delivery" ) )  // has precedence
	{
		not_del = true;
		del = false;
	};

	for ( i = unity_map->begin(); i != unity_map->end(); i++ )
	{
		// Remove delivered or not delivered mails from the statistic
		if ( !not_del && ( i->second.to_intern.size() + i->second.to_extern.size() == 0 ) ) continue;
		if ( !del && ( i->second.to_intern.size() + i->second.to_extern.size() != 0 ) ) continue;

		// Add the mailsize to the useraccount
		for ( m = i->second.to_extern.begin(); m != i->second.to_extern.end(); m++ )
		{
			extern_traffic_c[ *m ] += i->second.size;
			mailc_toe_c[ *m ] ++; // Count
		}
	}
	// Temp map recalc
	for ( j = extern_traffic_c.begin(); j != extern_traffic_c.end(); j++ )
		extern_traffic.insert( std::make_pair( j->second, j->first ) );
}

void xtAnalyse::print( void )
{
	if ( !report ) return ;

	int limit = getIntParam( "limit" );

	std::multimap< long, std::string >::reverse_iterator k;

	report->startNewReport( "To External recipient Traffic - from local accounts", Report::TABLE );
	report->addCol( 4, Report::COUNTER, Report::RIGHT, "nr", Report::NONE );
	// -1 = use all remaining space
	report->addCol( -1, Report::STRING, Report::LEFT, "email-address", Report::NONE );
	report->addCol( 7, Report::INTEGER, Report::RIGHT, "count", Report::ROUND, Report::SUM );
	report->addCol( 10, Report::INTEGER, Report::RIGHT, "received", Report::NONE, Report::SUM );
	report->printHeader();
	for( k = extern_traffic.rbegin(); k != extern_traffic.rend(); k++ )
	{
		report->printField( k->second );
		report->printField( mailc_toe_c[ k->second ] );
		report->printField( k->first );

		if ( --limit < 1 ) break;
	}
	report->printFooter();
}

void xtAnalyse::free( void )
{
	extern_traffic.clear();
	mailc_toe_c.clear();
}
