/*
 * properties.c
 * Copyright (C) 1998-2001 A.J. van Os; Released under GPL
 *
 * Description:
 * Read the properties information from a MS Word file
 */

#include <stdlib.h>
#include <string.h>
#include "antiword.h"


/*
 * Build the lists with Property Information
 */
void
vGetPropertyInfo(FILE *pFile, const pps_info_type *pPPS,
	const long *alBBD, size_t tBBDLen, const long *alSBD, size_t tSBDLen,
	const unsigned char *aucHeader, int iWordVersion)
{
	options_type	tOptions;

	fail(pFile == NULL || pPPS == NULL || aucHeader == NULL);
	fail(alBBD == NULL || alSBD == NULL);

	vGetOptions(&tOptions);

	switch (iWordVersion) {
	case 6:
	case 7:
		vGet6PapInfo(pFile, pPPS->tWordDocument.lSb,
			alBBD, tBBDLen, aucHeader);
		if (tOptions.bUseOutlineFonts) {
			vGet6ChrInfo(pFile, pPPS,
				alBBD, tBBDLen, aucHeader);
			vCreate6FontTable(pFile, pPPS->tWordDocument.lSb,
				alBBD, tBBDLen, aucHeader);
		}
		break;
	case 8:
		vGet8PapInfo(pFile, pPPS,
			alBBD, tBBDLen, alSBD, tSBDLen, aucHeader);
		if (tOptions.bUseOutlineFonts) {
			vGet8ChrInfo(pFile, pPPS,
				alBBD, tBBDLen, alSBD, tSBDLen, aucHeader);
			vCreate8FontTable(pFile, pPPS,
				alBBD, tBBDLen, alSBD, tSBDLen, aucHeader);
		}
		break;
	default:
		DBG_FIXME();
		werr(0, "Sorry, no property information");
		break;
	}
} /* end of vGetPropertyInfo */

/*
 * ePropMod2RowInfo - Turn the Propertie Modifier into row information
 *
 * Returns: the row information
 */
row_info_enum
ePropMod2RowInfo(unsigned short usPropMod, int iWordVersion)
{
	row_block_type	tRow;
	const unsigned char	*pucPropMod;
	int	iLen;

	pucPropMod = pucReadPropModListItem(usPropMod);
	if (pucPropMod == NULL) {
		return found_nothing;
	}
	iLen = (int)usGetWord(0, pucPropMod);

	switch (iWordVersion) {
	case 6:
	case 7:
		return eGet6RowInfo(0, pucPropMod + 2, iLen, &tRow);
	case 8:
		return eGet8RowInfo(0, pucPropMod + 2, iLen, &tRow);
	default:
		DBG_FIXME();
		return found_nothing;
	}
} /* end of ePropMod2RowInfo */
