/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __COOKBOOK_HPP
#define __COOKBOOK_HPP

#include "compiler.hpp"
#include "database.hpp"
#include "xslCompiler.hpp"

/** Specialized database class for accessing cookbook database.
    This class encapsulates the knowledge about the special structure of the
    cookbook database.
    
    @todo Porting of old databases using a wizard.
    @todo Use transactions.
    @date Thu Mar 10 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class CookBook: public Object
{
public:
  /** Constructor.
      @param _database Database holding the recipes.
      @param inputXSLFileName Filename of XSL-script translating XML-queries 
      to the SQL-dialec of the database.
      @param outputXSLFileName Filename of XSL-script adapting the structure of
      the output generated by the XSU-utility.
      @param performVersionCheck This boolean has to be set to \c false, if
      the database is empty (no tables have been created yet).
      @see XSU
      @see XSLCompiler */
  CookBook( DatabasePtr _database,
            const std::string &inputXSLFileName,
            const std::string &outputXSLFileName,
            bool performVersionCheck = true ) throw (Error);
  /** Get compiler-chain for accessing database.
      The returned compiler-chain is an XSU-utility with two XSL-scripts for
      pre- and postprocessing. The XSL-scripts are providing an abstraction-
      layer to hide the SQL-dialect of the database.

      The following picture illustrates, how the compiler-chain is being used
      to extract a recipe for example:
      \image html cookbook.png "Example for using compiler-chain"
      @return Compiler-chain for accessing database. */
  CompilerPtr getXMLLayer(void) const { return xmlLayer; }
  /** Get direct access to database.
      @see Database */
  DatabasePtr getDatabase(void) const { return database; }
  /// Query database version.
  int getVersion(void) const throw (Error);
  /// Update database version.
  void update(void) throw (Error);
protected:
  ///
  static CompilerPtr createXMLLayer( DatabasePtr _database,
                                     const std::string &inputXSLFileName,
                                     const std::string &outputXSLFileName );
  /// Database.
  DatabasePtr database;
  /// Compiler-chain.
  CompilerPtr xmlLayer;
};

///
typedef boost::shared_ptr< CookBook > CookBookPtr;

#endif
