#include <kdialog.h>
#include <klocale.h>
/****************************************************************************
** Form implementation generated from reading ui file './searchDialog.ui'
**
** Created: Sa Jun 3 16:56:34 2006
**      by: The User Interface Compiler ($Id: qt/main.cpp   3.3.5   edited Aug 31 12:13 $)
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

#include "searchDialog.h"

#include <qvariant.h>
#include <cassert>
#include <iostream>
#include <klocale.h>
#include <sstream>
#include <string>
#include <vector>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qheader.h>
#include <qlistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <knuminput.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include "klineedit.h"
#include "kpushbutton.h"
#include "knuminput.h"
#include "categoryListItem.hpp"
#include "displayWaitCursor.hpp"
#include "utils.hpp"
#include "xmlDocument.hpp"
#include "xmlNodeReferenceList.hpp"
#include "./searchDialog.ui.h"
/*
 *  Constructs a SearchDialog as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
SearchDialog::SearchDialog( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "SearchDialog" );
    setIcon( QPixmap::fromMimeSource( "search.png" ) );
    setSizeGripEnabled( TRUE );
    setModal( TRUE );
    SearchDialogLayout = new QVBoxLayout( this, 11, 6, "SearchDialogLayout"); 

    stockTab = new QTabWidget( this, "stockTab" );

    titleTab = new QWidget( stockTab, "titleTab" );
    titleTabLayout = new QVBoxLayout( titleTab, 11, 6, "titleTabLayout"); 

    titleLabel = new QLabel( titleTab, "titleLabel" );
    titleTabLayout->addWidget( titleLabel );

    titleWordView = new QListView( titleTab, "titleWordView" );
    titleWordView->addColumn( tr2i18n( "Regular Expression" ) );
    titleTabLayout->addWidget( titleWordView );

    titleEdit = new KLineEdit( titleTab, "titleEdit" );
    titleTabLayout->addWidget( titleEdit );

    layout4 = new QHBoxLayout( 0, 0, 6, "layout4"); 
    spacer10 = new QSpacerItem( 30, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout4->addItem( spacer10 );

    addTitleWordButton = new KPushButton( titleTab, "addTitleWordButton" );
    addTitleWordButton->setEnabled( FALSE );
    layout4->addWidget( addTitleWordButton );
    spacer11 = new QSpacerItem( 60, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout4->addItem( spacer11 );

    removeTitleWordButton = new KPushButton( titleTab, "removeTitleWordButton" );
    removeTitleWordButton->setEnabled( FALSE );
    layout4->addWidget( removeTitleWordButton );
    spacer12 = new QSpacerItem( 30, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout4->addItem( spacer12 );
    titleTabLayout->addLayout( layout4 );
    stockTab->insertTab( titleTab, QString::fromLatin1("") );

    categoriesTab = new QWidget( stockTab, "categoriesTab" );
    categoriesTabLayout = new QVBoxLayout( categoriesTab, 11, 6, "categoriesTabLayout"); 

    categoryListView = new QListView( categoriesTab, "categoryListView" );
    categoryListView->addColumn( tr2i18n( "#Recipes" ) );
    categoryListView->addColumn( tr2i18n( "Name" ) );
    categoryListView->setSelectionMode( QListView::Extended );
    categoryListView->setShowSortIndicator( TRUE );
    categoriesTabLayout->addWidget( categoryListView );

    layout4_2 = new QHBoxLayout( 0, 0, 6, "layout4_2"); 
    spacer9 = new QSpacerItem( 40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout4_2->addItem( spacer9 );

    reloadButton = new KPushButton( categoriesTab, "reloadButton" );
    layout4_2->addWidget( reloadButton );
    Spacer7 = new QSpacerItem( 80, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout4_2->addItem( Spacer7 );

    clearSelectionButton = new KPushButton( categoriesTab, "clearSelectionButton" );
    layout4_2->addWidget( clearSelectionButton );
    Spacer9 = new QSpacerItem( 40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout4_2->addItem( Spacer9 );

    selectAllButton = new KPushButton( categoriesTab, "selectAllButton" );
    layout4_2->addWidget( selectAllButton );
    Spacer8 = new QSpacerItem( 40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout4_2->addItem( Spacer8 );
    categoriesTabLayout->addLayout( layout4_2 );
    stockTab->insertTab( categoriesTab, QString::fromLatin1("") );

    TabPage = new QWidget( stockTab, "TabPage" );
    TabPageLayout = new QVBoxLayout( TabPage, 11, 6, "TabPageLayout"); 

    ingredientWordView = new QListView( TabPage, "ingredientWordView" );
    ingredientWordView->addColumn( tr2i18n( "Regular Expression" ) );
    TabPageLayout->addWidget( ingredientWordView );

    ingredientEdit = new KLineEdit( TabPage, "ingredientEdit" );
    TabPageLayout->addWidget( ingredientEdit );

    layout5 = new QHBoxLayout( 0, 0, 6, "layout5"); 
    spacer12_2 = new QSpacerItem( 31, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout5->addItem( spacer12_2 );

    addIngredientWordButton = new KPushButton( TabPage, "addIngredientWordButton" );
    addIngredientWordButton->setEnabled( FALSE );
    addIngredientWordButton->setDefault( TRUE );
    layout5->addWidget( addIngredientWordButton );
    spacer13 = new QSpacerItem( 61, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout5->addItem( spacer13 );

    removeIngredientWordButton = new KPushButton( TabPage, "removeIngredientWordButton" );
    removeIngredientWordButton->setEnabled( FALSE );
    layout5->addWidget( removeIngredientWordButton );
    spacer14 = new QSpacerItem( 31, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout5->addItem( spacer14 );
    TabPageLayout->addLayout( layout5 );
    stockTab->insertTab( TabPage, QString::fromLatin1("") );

    limitTab = new QWidget( stockTab, "limitTab" );
    limitTabLayout = new QVBoxLayout( limitTab, 11, 6, "limitTabLayout"); 

    Layout15 = new QHBoxLayout( 0, 0, 6, "Layout15"); 

    limitLabel = new QLabel( limitTab, "limitLabel" );
    Layout15->addWidget( limitLabel );

    limitSpinBox = new KIntSpinBox( limitTab, "limitSpinBox" );
    limitSpinBox->setMaxValue( 2500 );
    limitSpinBox->setMinValue( 1 );
    limitSpinBox->setValue( 100 );
    Layout15->addWidget( limitSpinBox );
    limitTabLayout->addLayout( Layout15 );

    orderedCheckBox = new QCheckBox( limitTab, "orderedCheckBox" );
    limitTabLayout->addWidget( orderedCheckBox );

    restrictCheckBox = new QCheckBox( limitTab, "restrictCheckBox" );
    limitTabLayout->addWidget( restrictCheckBox );
    Spacer21 = new QSpacerItem( 20, 290, QSizePolicy::Minimum, QSizePolicy::Expanding );
    limitTabLayout->addItem( Spacer21 );
    stockTab->insertTab( limitTab, QString::fromLatin1("") );
    SearchDialogLayout->addWidget( stockTab );

    Layout6 = new QHBoxLayout( 0, 0, 6, "Layout6"); 
    Spacer1 = new QSpacerItem( 20, 0, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout6->addItem( Spacer1 );

    okButton = new KPushButton( this, "okButton" );
    Layout6->addWidget( okButton );
    Spacer6 = new QSpacerItem( 20, 0, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout6->addItem( Spacer6 );

    cancelButton = new KPushButton( this, "cancelButton" );
    Layout6->addWidget( cancelButton );
    Spacer2 = new QSpacerItem( 20, 0, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout6->addItem( Spacer2 );
    SearchDialogLayout->addLayout( Layout6 );
    languageChange();
    resize( QSize(383, 321).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    connect( okButton, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( cancelButton, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( clearSelectionButton, SIGNAL( clicked() ), this, SLOT( clearCategorySelection() ) );
    connect( selectAllButton, SIGNAL( clicked() ), this, SLOT( selectAllCategories() ) );
    connect( reloadButton, SIGNAL( clicked() ), this, SLOT( reloadCategories() ) );
    connect( titleEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( addTitleButtonEnable() ) );
    connect( titleWordView, SIGNAL( selectionChanged(QListViewItem*) ), this, SLOT( selectTitleWord(QListViewItem*) ) );
    connect( addTitleWordButton, SIGNAL( clicked() ), this, SLOT( addTitleWord() ) );
    connect( removeTitleWordButton, SIGNAL( clicked() ), this, SLOT( removeTitleWord() ) );
    connect( addIngredientWordButton, SIGNAL( clicked() ), this, SLOT( addIngredientWord() ) );
    connect( removeIngredientWordButton, SIGNAL( clicked() ), this, SLOT( removeIngredientWord() ) );
    connect( ingredientWordView, SIGNAL( selectionChanged(QListViewItem*) ), this, SLOT( selectIngredientWord(QListViewItem*) ) );
    connect( ingredientEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( addIngredientButtonEnable() ) );

    // buddies
    titleLabel->setBuddy( titleEdit );
    limitLabel->setBuddy( limitSpinBox );
    init();
}

/*
 *  Destroys the object and frees any allocated resources
 */
SearchDialog::~SearchDialog()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void SearchDialog::languageChange()
{
    setCaption( tr2i18n( "Advanced Search" ) );
    QToolTip::add( stockTab, tr2i18n( "Specify search criteria." ) );
    titleLabel->setText( tr2i18n( "Keywords in &title:" ) );
    titleWordView->header()->setLabel( 0, tr2i18n( "Regular Expression" ) );
    QToolTip::add( titleEdit, tr2i18n( "Specify words to appear in the recipe's title." ) );
    addTitleWordButton->setText( tr2i18n( "&Add" ) );
    addTitleWordButton->setAccel( QKeySequence( tr2i18n( "Alt+A" ) ) );
    removeTitleWordButton->setText( tr2i18n( "&Remove" ) );
    removeTitleWordButton->setAccel( QKeySequence( tr2i18n( "Alt+R" ) ) );
    stockTab->changeTab( titleTab, tr2i18n( "&Title" ) );
    categoryListView->header()->setLabel( 0, tr2i18n( "#Recipes" ) );
    categoryListView->header()->setLabel( 1, tr2i18n( "Name" ) );
    QToolTip::add( categoryListView, tr2i18n( "Specify set of categories to restrict search to." ) );
    reloadButton->setText( tr2i18n( "&Reload" ) );
    reloadButton->setAccel( QKeySequence( tr2i18n( "Alt+R" ) ) );
    QToolTip::add( reloadButton, tr2i18n( "Reload list of categories." ) );
    clearSelectionButton->setText( tr2i18n( "&Clear" ) );
    clearSelectionButton->setAccel( QKeySequence( tr2i18n( "Alt+C" ) ) );
    QToolTip::add( clearSelectionButton, tr2i18n( "Clear category selection." ) );
    selectAllButton->setText( tr2i18n( "&All" ) );
    selectAllButton->setAccel( QKeySequence( tr2i18n( "Alt+A" ) ) );
    QToolTip::add( selectAllButton, tr2i18n( "Select all categories." ) );
    stockTab->changeTab( categoriesTab, tr2i18n( "&Categories" ) );
    ingredientWordView->header()->setLabel( 0, tr2i18n( "Regular Expression" ) );
    addIngredientWordButton->setText( tr2i18n( "&Add" ) );
    addIngredientWordButton->setAccel( QKeySequence( tr2i18n( "Alt+A" ) ) );
    removeIngredientWordButton->setText( tr2i18n( "&Remove" ) );
    removeIngredientWordButton->setAccel( QKeySequence( tr2i18n( "Alt+R" ) ) );
    stockTab->changeTab( TabPage, tr2i18n( "&Ingredients" ) );
    limitLabel->setText( tr2i18n( "&Limit:" ) );
    QToolTip::add( limitSpinBox, tr2i18n( "Maximum number of search results." ) );
    orderedCheckBox->setText( tr2i18n( "&Sort results before limiting (slow)" ) );
    orderedCheckBox->setAccel( QKeySequence( tr2i18n( "Alt+S" ) ) );
    restrictCheckBox->setText( tr2i18n( "&Restrict to selected recipes" ) );
    restrictCheckBox->setAccel( QKeySequence( tr2i18n( "Alt+R" ) ) );
    stockTab->changeTab( limitTab, tr2i18n( "&Limit" ) );
    okButton->setText( tr2i18n( "&Ok" ) );
    okButton->setAccel( QKeySequence( tr2i18n( "Alt+O" ) ) );
    cancelButton->setText( tr2i18n( "&Cancel" ) );
}

#include "searchDialog.moc"
