# spec file for installing AnyMeal under openSuSE 10.0
#
# Copyright (c) 2003 Jan Wedekind, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# please send bugfixes or comments to wedesoft@users.sourceforge.net .
#
Summary: Database client for maintaining recipes.
Name: anymeal
Version: 0.30
Release: 1suse10.0
Group: Applications/Databases
URL: http://www.wedesoft.demon.co.uk/anymeal-api/
License: GNU GPL
Distribution: openSUSE 10.0
Vendor: Sourceforge
Packager: Jan Wedekind <wedesoft@users.sourceforge.net>
# AnyMeal sources.
Prefix: /opt/kde3
Source0: %{name}-%{version}.tar.bz2
# diff -ruaN AnyMeal-0.6-{4,5} > AnyMeal-0.6-1.patch
# Patch0: %{name}-%{version}-1.patch.gz
# Patch1: %{name}-%{version}-2.patch.gz
# Patch2: %{name}-%{version}-3.patch.gz
# Patch1: %{name}-%{version}-2.patch.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-build
Requires: kdelibs3 qt3 >= 3.3 Xalan-c >= 1.9 Xerces-c >= 2.6 docbook-xsl-stylesheets mysql-shared >= 4.1 mysql >= 4.1 recode glibc libstdc++ recode file
# unixODBC unixODBC-gui-qt MyODBC-unixODBC
BuildRequires: docbook-xsl-stylesheets mysql-shared >= 4.1 mysql >= 4.1 flex kdelibs3-devel update-desktop-files qt3-devel >= 3.3 Xalan-c-devel >= 1.9 Xerces-c-devel >= 2.6 boost-devel dia doxygen graphviz mysql-devel >= 4.1 gettext bzip2 tar cpp make recode-devel glibc-devel libstdc++-devel recode-devel file-devel update-desktop-files
# unixODBC-devel 

%description
Cookbook database front-end developed with C++, Qt, MySQL, Xalan-C under
GNU/Linux. It can handle more than 100,000 recipes and search recipes for a
given set of ingredients! The sw-design is lean and flexible. Happy cooking!
Status: Alpha
This package is for openSuSE/SuSE 10.0!

%prep
%setup -q
# %patch0 -p1
# %patch1 -p1
# %patch2 -p1
# source the standard build enviroment as defined in kdelibs3 package
. /etc/opt/kde3/common_options
# replace the admin/ folder with the version from kdelibs3 (will work for sure
# with current autoconf and automake) and create Makefile.in and configure
# script).
# unalias make
UNSERMAKE="no" update_admin --no-unsermake

%build
# source the standard build enviroment as defined in kdelibs3 package
. /etc/opt/kde3/common_options
./configure $configkde --disable-final
# Configure build.
# ./configure --prefix=%{prefix}

# do compile with the number of jobs given to the --jobs parameter of the build script.
%{__make} %{?jobs:-j%jobs}

# Strip resulting binary.
%{__strip} -s src/anymeal

%install
iconv -f iso8859-1 -t utf-8 src/anymeal.desktop > w && mv w src/anymeal.desktop
%{__make} DESTDIR=$RPM_BUILD_ROOT install
# updates the .desktop file. It applys additional translations and Categories
# for a proper position in the KDE menu
%suse_update_desktop_file %name Utility
# Does find all localisation files and adds proper database attributes to them
%find_lang %name

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc AUTHORS COPYING INSTALL README TODO ChangeLog anymeal.lsm
%prefix
/usr/share

%changelog
* Fri Oct 06 2006 Jan Wedekind <jan@wedesoft.de> 0.30

	- Fixed error in spec-file: configure-script was called twice.

* Tue Feb 14 2006 Jan Wedekind <jan@wedesoft.de> 0.28

	- Updated according to http://en.opensuse.org/SUSE_Build_Tutorial

* Sun Jan 15 2006 Jan Wedekind <jan@wedesoft.de> 0.26

	- Added recode- and magic/file-library to dependencies.

* Wed Nov 02 2005 Jan Wedekind <jan@wedesoft.de> 0.23-1

	- New rpm package is for SuSE / openSuSE 10.0
	- A newer version of Xalan is required

* Sat Jul 16 2005 Jan Wedekind <jan@wedesoft.de> 0.19-1

	- New directory-structure and kdevelop-project

* Sun Jun 26 2005 Jan Wedekind <jan@wedesoft.de> 0.18-1

	- configure-script searches for docbook-script itself.
	- All m4-files are included in the source-package.

* Sun Jun 05 2005 Jan Wedekind <jan@wedesoft.de> 0.16-1

	- Added some icon-files.

* Mon May 30 2005 Jan Wedekind <jan@wedesoft.de> 0.14-2

	- Removed id-dialog.

* Fri Apr 01 2005 Jan Wedekind <jan@wedesoft.de> 0.12-1

	- Adding partial Malaysian translation.

* Thu Mar 24 2005 Jan Wedekind <jan@wedesoft.de> 0.11-1

	- 0.11 version depending on MySQL 4.1. 

* Wed Mar 23 2005 Jan Wedekind <jan@wedesoft.de> 0.10-8

	- Added some more logos.

* Sat Mar 19 2005 Jan Wedekind <jan@wedesoft.de> 0.10-7

	- Compiling with libraries of MySQL 4.1 now.

* Sat Mar 12 2005 Jan Wedekind <jan@wedesoft.de> 0.10-6

	- Learned some things about writing spec-files.

* Fri Mar 11 2005 Jan Wedekind <jan@wedesoft.de> 0.10-5

	- Dropping dependency on popt.

* Wed Mar 09 2005 Jan Wedekind <jan@wedesoft.de> 0.10-4

	- Dropped dependencies on ODBC-libraries.

* Sun Mar 06 2005 Jan Wedekind <jan@wedesoft.de> 0.10-1

	- Not using anymeal-script any more.

* Mon Feb 28 2005 Jan Wedekind <jan@wedesoft.de> 0.9-11

	- Added dependency on mysql-devel.

* Sun Feb 27 2005 Jan Wedekind <jan@wedesoft.de> 0.9-10

	- Definition of data-directory was moved to config-header.

* Sun Feb 13 2005 Jan Wedekind <jan@wedesoft.de> 0.9-8

	- AnyMeal is depending on the KDE system now.
	- Added icon and desktop-file.

* Mon Feb 07 2005 Jan Wedekind <jan@wedesoft.de> 0.9-7

	- Added files for mapping of units.
	- New XSD for verifying anymeal's internal XML-format for recipes.

* Tue Jan 11 2005 Jan Wedekind <jan@wedesoft.de> 0.9-2

	- Added some files for Apache-Wrappers.

* Sun Dec 31 2004 Jan Wedekind <jan@wedesoft.de> 0.9-1

	- Renamed some h-files to hpp.

* Wed Dec 29 2004 Jan Wedekind <jan@wedesoft.de> 0.8-11

	- Removed two superfluous screenshots.

* Tue Dec 28 2004 Jan Wedekind <jan@wedesoft.de> 0.8-10

	- QTDIR environment-variable not read out any more.

* Sun Nov 14 2004 Jan Wedekind <jan@wedesoft.de> 0.8-7

	- Fixed 0.8-6, which is broken.
	- Removed install.html from distribution.

* Sun Nov 14 2004 Jan Wedekind <jan@wedesoft.de> 0.8-6

	- Removed french translation file.

* Sat Nov 06 2004 Jan Wedekind <jan@wedesoft.de> 0.8-5

	- Replaced install.html with INSTALL.
	- Removed outdated *.nsi and *.ds? files.

* Tue Nov 02 2004 Jan Wedekind <jan@wedesoft.de> 0.8-4

	- Added vendor- and distribution-field.

* Sun Oct 31 2004 Jan Wedekind <jan@wedesoft.de> 0.8-3

	- Added LD_ASSUME_KERNEL=2.4.1 to startup-script.

* Sat Oct 30 2004 Jan Wedekind <jan@wedesoft.de> 0.8-1

	- Program is called indirectly using a script allowing later
	  customization.
	- Updated configure checks.
	- Added another xalanc-link in main-directory.
	- Renamed spec-file, because it is SuSE-specific.

* Wed Oct 27 2004 Jan Wedekind <jan@wedesoft.de> 0.7-6

	- Added empty french translation file.

* Sun Oct 24 2004 Jan Wedekind <jan@wedesoft.de> 0.7-5

	- Added XSL-script for exporting Mealmaster.

* Thu Sep 30 2004 Jan Wedekind <jan@wedesoft.de> 0.7-1

	- New release.

* Tue Sep 07 2004 Jan Wedekind <jan@wedesoft.de> 0.6-7

	- Removed error.cpp

* Mon Sep 06 2004 Jan Wedekind <jan@wedesoft.de> 0.6-6

	- Removed several xsl- and sql-files not being required any more.

* Sun Sep 05 2004 Jan Wedekind <jan@wedesoft.de> 0.6-5

	- Added patch and a release script.

* Sat Sep 04 2004 Jan Wedekind <jan@wedesoft.de> 0.6-4

	- First sourceforge release.
	- Some files where missing in the "make dist" target.
	- rpm-files are designed for SuSE 9.1.

* Tue Aug 31 2004 Jan Wedekind <jan@wedesoft.de> 0.6-3

	- Added dependency for ODBCConfig-executable.

* Sun Aug 22 2004 Jan Wedekind <jan@wedesoft.de> 0.6-2

	- Test build for initial project on sourceforge.net

* Sun Aug 08 2004 Jan Wedekind <jan@wedesoft.de> 0.6-1

	- Not using DTL library any more. Found a way to access unixODBC/ODBC
	  directly (similar to isql.c program shipped with unixODBC).
	- Create symbolic link xalanc to fix package Xalan-c-devel.

* Sat Jan 24 2004 Jan Wedekind <jan@wedesoft.de> 0.5-1

	- Search queries are fully working now (using XSL conversion of an XML
	  query document).
	- Improved performance of database by adding primary keys.

* Tue Jan 18 2004 Jan Wedekind <jan@wedesoft.de> 0.4-1

	- Adapted to different character encodings
	- Advanced search facilities (slow)

* Tue Dec 16 2003 Jan Wedekind <jan@wedesoft.de> 0.3-1

	- Started with Linux-GUI using Qt.
	- Added requirements and design page to doxygen-documentation.

* Mon Sep 29 2003 Jan Wedekind <jan@wedesoft.de> 0.2-2

	- Added XSU (XML SQL utility) test program.
	- There is a full set of scripts for storing and extracting XML data
	  in/from the SQL database.

* Fri Aug 29 2003 Jan Wedekind <jan@wedesoft.de> 0.2-1

	- Version 0.2

