/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __ODBCDATABASE_HPP
#define __ODBCDATABASE_HPP

#include "include.hpp"
#include <sql.h>
#include "database.hpp"

/** Class for connecting to ODBC-database.
    \deprecated{The ODBC classes are not in use at the moment}
    @date Thu Mar 03 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class ODBCDatabase: public Database
{
public:
  /** Constructor establishing connection to the data source.
      @param databaseName Name of unixODBC's data source.
      @param userName Name of database user.
      @param passWord Password of user. The password will be passed to the
      \c SQLConnect command. */
  ODBCDatabase( const std::string &databaseName,
                const std::string &userName,
                const std::string &passWord ) throw (Error);
  /// Destructor.
  virtual ~ODBCDatabase(void);
  ///
  virtual StatementPtr execQuery( const std::string &query ) throw (Error);
protected:
  /// ODBC environment handle.
  SQLHENV odbcEnvironment;
  /// Connection handle.
  SQLHDBC connection;
};

/// Smart-Pointer referencing a ODBC-database.
typedef boost::shared_ptr< ODBCDatabase > ODBCDatabasePtr;

#endif
