//
// anyRemote
// a bluetooth remote for your PC.
//
// Copyright (C) 2006,2007,2008 Mikhail Fedotov <anyremote@mail.ru>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
//

//#define USE_XTEST
 
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>


#ifdef USE_XTEST
#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>
#endif

#include "common.h"
#include "utils.h"

extern char tmp[MAXMAXLEN];

#ifdef USE_XTEST
static Display* disp = NULL;
#endif

void freeDisplay()
{
	#ifdef USE_XTEST
	if (disp) {
		XCloseDisplay(disp);
		disp = NULL;
	}
	#endif
}

#ifdef USE_XTEST
static void mouseClick(int button)
{
        XTestFakeButtonEvent(disp, button, True, CurrentTime);
        XTestFakeButtonEvent(disp, button, False, CurrentTime);
}

static void mouseDoubleClick()
{
	mouseClick(1);
        usleep(1000);
        mouseClick(1);
}

static KeyCode keysymStr2keycode(Display* disp, const char* keysymStr)
{
	KeySym ks = XStringToKeysym(keysymStr);
        if(ks == NoSymbol) {
	        DEBUG2("couldn't map keysymbol %s", keysymStr);
                ks = XStringToKeysym("space");
        }
        return XKeysymToKeycode(disp, ks);
}

static void keyboardClick(const char* keysymStr)
{
        KeyCode kc = keysymStr2keycode(disp, keysymStr);

        XTestFakeKeyEvent(disp, kc, True, CurrentTime);
        XTestFakeKeyEvent(disp, kc, False, CurrentTime);
}
#endif

// Input can be something like:
// key,a,keyup,b,keydown,c,mouse,1,mouseup,1,mousedown,1,mousemove,100,100,mousermove,10,10,mousedblclick,sleep,1000
//
int emulateCommands(char* cmdString) 
{
	#ifdef USE_XTEST

	if (disp == NULL) {
        	disp = XOpenDisplay(NULL);
        }
                
        char * cmd = strdup(cmdString);
        
        char* token = strtok(cmd,",");
        while (token) {
        
        	if (strcmp(token,"keyup") == 0) {
                	char * key = strtok(NULL,",");
                        if (key) {
				XTestFakeKeyEvent(disp, keysymStr2keycode(disp,key), False, CurrentTime );
                        } else {
                        	logger("DEBUG", "emulateCommands: improper keyup\n");
                        }
                } else if (strcmp(token,"keydown") == 0) {
                	char * key = strtok(NULL,",");
                        if (key) {
				XTestFakeKeyEvent(disp, keysymStr2keycode(disp,key), True, CurrentTime );
                        } else {
                        	logger("DEBUG", "emulateCommands: improper keydown\n");
                        }
                
                } else if (strcmp(token,"key") == 0) {
                	char * key = strtok(NULL,",");
                        if (key) {
                        	keyboardClick(key);
                        } else {
                        	logger("DEBUG", "emulateCommands: improper key\n");
                        }
                
                } else if (strcmp(token,"mousemove") == 0) {
                	char * x = strtok(NULL,",");
                	char * y = (x ? strtok(NULL,",") : NULL);
                        if (x && y) {
				XTestFakeMotionEvent(disp, -1, atoi(x), atoi(y), CurrentTime );
                        } else {
                        	logger("DEBUG", "emulateCommands: improper mousemove\n");
                        }
                
                } else if (strcmp(token,"mousermove") == 0) {
                	char * x = strtok(NULL,",");
                	char * y = (x ? strtok(NULL,",") : NULL);
                        if (x && y) {
				XTestFakeRelativeMotionEvent(disp,atoi(x), atoi(y), CurrentTime );
                        } else {
                        	logger("DEBUG", "emulateCommands: improper mousermove\n");
                        }
                
                } else if (strcmp(token,"mousedblclick") == 0) {
                
                	mouseDoubleClick();
                        
                } else if (strcmp(token,"mouseup") == 0) {
        		char * x = strtok(NULL,",");
                        if (x) {
				XTestFakeButtonEvent(disp, atoi(x), False, CurrentTime);
                        } else {
                        	logger("DEBUG", "emulateCommands: improper mouseup\n");
                        }

                } else if (strcmp(token,"mousedown") == 0) {
        		char * x = strtok(NULL,",");
                        if (x) {
				XTestFakeButtonEvent(disp, atoi(x), True, CurrentTime);
                        } else {
                        	logger("DEBUG", "emulateCommands: improper mousedown\n");
                        }

                } else if (strcmp(token,"mouse") == 0) {
        		char * x = strtok(NULL,",");
                        if (x) {
                        	mouseClick(atoi(x));
                        } else {
                        	logger("DEBUG", "emulateCommands: improper mouse\n");
                        }

                } else if (strcmp(token,"sleep") == 0) {
                
        		char * x = strtok(NULL,",");
                        if (x) {
                        	usleep(atoi(x));
                        } else {
                        	logger("DEBUG", "emulateCommands: improper sleep\n");
                        }

        	} else {
                	logger("DEBUG", "emulateCommands: unknown operation\n");
                }
                token = strtok(NULL,",");
		
		XFlush(disp);
        }
        XFlush(disp);
	
        free(cmd);
	#endif
        
        return EXIT_OK;
}
