//
// anyRemote
// a bluetooth remote for your PC.
//
// Copyright (C) 2006-2012 Mikhail Fedotov <anyremote@mail.ru>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef _COMMON_H_
#define _COMMON_H_

#define EXIT_EXACT  -3
#define EXIT_NOK    -1
#define EXIT_OK      0
#define EXIT_DISCON  2
#define EXIT_ABORT   3
#define EXIT_STOP    4
#define EXIT_INITOK  5

#define MAXMAXLEN    	2048
#define MAXLEN          512
#define MAXCKPDLEN    	100
#define MTEXTLEN    	30

#define IS_OK(answer) (strstr(answer, "OK") != NULL)

//#define DEFAULT_DEVICE  "/dev/rfcomm0"	seems JSR-82 phones is more usable now
#define DEFAULT_DEVICE  "bluetooth:19"

#define AT_DEVICE   	"rfcomm"
#define INET_SOCKET   	"socket:"
#define BT_SOCKET   	"bluetooth"
#define BT_SPP   	"btspp" 	// not yet used
#define L2CAP_SOCKET   	"l2cap"
#define UNIX_SOCKET   	"local:"
#define ILIRC_SOCKET   	"ilirc:"
#define STDIN_STREAM   	"stdin"
#define WEB_SOCKET   	"web:"

#define TOFILE   	"/anyremote.result"
#define CMDFILE   	"/anyremote.command"

#define PROTO_AT        1
#define PROTO_ANYREMOTE 2
#define PROTO_BEMUSED   3
#define PROTO_IVIEWER   4

#define CLIENT_RFCOMM   1	// AT protocol over bluetooth
#define CLIENT_AT       2	// AT protocol over IR or cable
#define SERVER_TCP      3	// anyRemote protocol over TCP/IP
#define SERVER_BT       4	// anyRemote protocol over btspp
#define CLIENT_ILIRC    5	// inputLirc protocol
#define CLIENT_NOAT     6	// anyRemote protocol over IR (or any AF_UNIX socket) - as client
#define SERVER_STDIN    7	// anyRemote protocol, read command from stdin
#define SERVER_WEB      8	// anyRemote protocol, built-in web server

#define SERVER_L2CAP    101	// TODO: anyRemote protocol over l2cap
#define SERVER_UX       102     // NOT USED: anyRemote protocol over IR (or any AF_UNIX socket) - as server

#define DEFAULT_BT_CHANNEL 19
#define BT_ADDR_LEN        17   // 00:12:EF:32:21:1A
#define DEFAULT_L2CAP_PORT 5019

#ifndef SOCK_CLOEXEC
#define SOCK_CLOEXEC 0
#endif

// TODO: Support L2CAP under FreeBSD
//#ifdef USE_BLUEZ
//#define USE_L2CAP 1
//#endif

#endif
