#!/bin/bash

ROOT=./data

CLEAN="N"
if [ "X$2" == "X-clean" ]; then
	CLEAN="Y"
fi

if [ ! -d "$ROOT/scalable" ]; then
	echo "No sources directory in "$ROOT
	echo "It needs to run this script inside anyremote2html-X.Y directory"
	exit 0
fi

if [ "X$CLEAN" == "XY" ]; then
	rm -rf $ROOT/16 $ROOT/32 $ROOT/48 $ROOT/64 $ROOT/128
	mkdir $ROOT/16 $ROOT/32 $ROOT/48 $ROOT/64 $ROOT/128
fi

cd $ROOT/scalable

PNGOUT=`which pngout 2> /dev/null|wc -l |tr -d  ' '` 

#for SIZE in 16 32 48 64 128 ; do 
for SIZE in 128 ; do 
	for IFILE in * ; do 

        	echo "Process "$SIZE":"$IFILE
	
        	NAME=`echo $IFILE|cut -f 1 -d '.'`
		OFILE="../"${SIZE}"/"${NAME}".png"
	
		gimp -i -b '(resize-and-save-as-png "'$IFILE'" "'$OFILE'" '$SIZE')' -b '(gimp-quit 0)' 2> /dev/null
	done
	
	if  [ "X$PNGOUT" == "X1" ]; then
	        cd ../${SIZE}
 		ls -1 | xargs -i pngout -c6 {}
                cd ../scalable
	else
		echo "Pngout is not installed. Jar file will be bigger."
	fi
done
