#ifndef _MOD_CACHE_H
#define _MOD_CACHE_H 

#include "httpd.h"
#include "http_config.h"

typedef struct {
    int mmap_cache_size; /* in entries */
    int mmap_cache_threshold; /* in KB */
} cache_conf;

extern module cache_module;

#define MMAP_CACHE_DEFAULT_THRESHOLD 4096

#define SET_BYTES_SENT(r) \
  do { if (r->sent_bodyct) \
      ap_bgetopt(r->connection->client, BO_BYTECT, &r->bytes_sent); \
  } while (0)

extern int mmap_cache_handle_request(request_rec *r, caddr_t *mmap_addr);
extern void mmap_cache_init(int cache_size_bytes);
extern void mmap_cache_exit(void);

#endif
