/* apcd.h - Definitons file for APC SmartUPS daemon
 *
 * Copyright (c) 1995 Pavel Korensky
 * All rights reserved
 *
 * Version:
 * 
 * $Id: apcd.h,v 1.5 1995/11/07 12:40:24 root Exp root $
 *
 *
 * History:
 *
 * $Log: apcd.h,v $
 * Revision 1.5  1995/11/07  12:40:24  root
 * Version 0.5 Beta uploaded to the sunsite
 *
 * Revision 1.4  1995/05/23  01:08:18  root
 * Parameters are on the command line, instead of the config.h file
 *
 * Revision 1.3  1995/05/23  00:26:08  root
 * UPS switch-off was added
 *
 * Revision 1.2  1995/05/21  20:15:56  root
 * First ALPHA version
 *
 * Revision 1.1  1995/05/20  12:22:54  root
 * Initial revision
 *
 *
 */

/* 
 * A few words regarding the APC serial protocol
 * 
 * Firstly, the cable:
 *
 * You will need a simple 3 wires cable connected as follows:
 *
 * PC (9 pin)     APC
 *  2 RxD          2
 *  3 TxD          1
 *  5 GND          9
 *
 * Communication protocol which is used for controlling the APC SmartUPS
 * is very simple ASCII protocol.
 * The serial communication is 2400 Bd, 8N1
 *
 * Basically, your computer send a character to the UPS and UPS answer
 * with the requested information in the form of the ASCII string terminated
 * with CR/LF.
 * In some cases, the UPS answer is the action like battery test etc.
 *
 * There are two exceptions. If the UPS is switching to the battery, the
 * characters "!!" are sent to the computer. If the UPS is switching back
 * on-line, the charater '$' is sent to the computer. If battery is low,
 * '%' is sent to the computer. When battery is recharged to more than 15%,
 * '+' is sent to the computer.
 *
 * The protocol description is not based on informations obtained from APC.
 * I tried to analyse the protocol on RS-232 port, so my description
 * is not complete.
 *
 * Command are:
 *
 *	SEND			ANSWER
 *
 *	f			Battery status in %   100 = fully loaded
 *	N			Line minimum voltage (V)
 *	M			Line maximum voltage (V)
 *	Q			Status byte 8 bits long.
 *                              - 08  On-line LED ON
 *                              - 10  On Battery LED ON
 *                              - 18  Both LEDs ON
 *                              - 02  UPS in shut down state, waiting for AC                  
 *
 *                              0 - If 1, UPS is in calibration
 *                              1 - If 1, UPS is sleeping
 *                              2 -  
 *                              3 - If 1, AC is here
 *                              4 - If 1, UPS is running on battery
 *                              5 -
 *                              6 - If 1, Battery is low
 *                              7 - If 1, Replace your battery!
 *
 *
 *	P			UPS load (VA)
 *	F			Line frequency (Hz)
 *	L			Line voltage (V)
 *	O			Output voltage (V)
 *	C			Inside temperature (Celsius degrees)
 *	B			Battery voltage
 *
 *
 * Some signals for UPS control
 *
 *      Y                       Attention
 *	W			Switch on battery
 *	X			Switch back on-line
 *	A			Lights test
 *	U			Power failure test
 *	c			UPS identification ???
 *
 * One very special signal
 *
 *	Z ~1500ms pause Z	Switch off the UPS completely and imediately
 *
 *
 * Special thanks to Kevin D. Smolkowski (kevins@tigger.oslc.org)
 *  who observed other control codes
 *
 *      D                       Runtime calibration   ON/OFF
 *      V                       Firmware revison
 *      c                       UPS Identification
 *      k                       UPS Warning (Power Fail, Power Fail + 30, Low Battery, OFF      
 *      l                       Low transfer point
 *      m                       Manufacture date
 *      n                       UPS serial number
 *      o                       Nominal UPS output
 *      p                       UPS turn off delay "020" "180" "300" "600" Cycles
 *      q                       Low battery signal time "02" "05" "07" "10" Cycles
 *      r                       Wakeup Delay
 *      s                       Sensitivity "H" "M" "L"
 *      u                       High transfer point
 *      x                       Battery replacement date
 *      y                       Brand "(C) APCC"
 *      7                       Option switch settings (Hex) "0F" "0E" "0C" "08" "00"
 *      
 *      -                       Change prev. settings
 *
 *                              To change UPS name   c - /n newname /n
 *
 *
 * Further codes, not fully tested
 *
 *      S                       Soft shutdown, UPS will go back on-line when AC is back
 *      @222                    Soft shutdown, UPS will NOT go back when AC is back
 *      U                       Power failure test
 *      G                       Return 'T' if there was a power failure 
 *                              Return 'S' if there was not a power failure
 *                              UPS Test will reset the value to the 'S'
 *      K 1500ms pause K        Switch off UPS completely after delay
 *
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <unistd.h>
#include <utmp.h>
#include <paths.h>
#include <string.h>
#include <dirent.h>
#include <fcntl.h>
#include <ctype.h>
#include <errno.h>
#include <syslog.h>
#include <time.h>
#include <mntent.h>
#include <sys/signal.h>
#include <sys/param.h>
#include <sys/mount.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/termios.h>
#include <sys/resource.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

/*
 * Various constants
 */

// #define	DEBUGGING 0	/* Debug flag */

#define	CONFIGFILENAME	"/etc/apcd.conf"
#define UPSLOGFILENAME  "/var/log/upsstat.log"	/* UPS status logging  */
#define PIDFILENAME	"/var/run/apcd.pid"	/* PID of daemon */
#define DAEMONID        "apcd"                  /* apcd short id */
#define DAEMONMES       "APC Daemon"            /* apcd verbose id */
#define	MAXLINE 100	/* Max. length of the UPS anser */
#define PAUSETIME 1	/* how many seconds should apcd sleep each time
			   it checks the UPS status
			 */
#define BATT 1		/* UPS switched on battery during reading info */
#define LINE 0		/* UPS switched back on-line during reading info */

#define MAX_SLAVES	10
#define UPS_TCP_PORT	6666	/* Our communication port */
			 
#define DEFAULT_SPEED B2400


#define	BATT_FULL	'f'
#define	UPS_LINE_MIN	'N'
#define UPS_LINE_MAX	'M'
#define	UPS_STATUS	'Q'
#define	UPS_LOAD	'P'
#define	LINE_FREQ	'F'
#define	LINE_VOLTAGE	'L'
#define	OUTPUT_VOLTAGE	'O'
#define	UPS_TEMP	'C'
#define	BATT_VOLTAGE	'B'

#define	GO_ON_BATT	'W'
#define	GO_ON_LINE	'X'
#define	LIGHTS_TEST	'A'
#define	FAILURE_TEST	'U'

#define	UPS_ON_BATT	'!'
#define	UPS_ON_LINE	'$'
#define BATT_LOW        '%'
#define BATT_OK         '+'

#define INIT            "/sbin/init"            /* Location of init */
#define DOWN_LEVEL	0			/* Runlevel for shutdown */
#define _PATH_UMOUNT	"/bin/umount"
#define UMOUNT_ARGS	"umount","-a"
#define _PATH_MTAB	"/etc/mtab"


/* reboot stuff */
#if defined(__GLIBC__)
#  include <sys/reboot.h>
#endif

#define BMAGIC_HARD     0x89ABCDEF
#define BMAGIC_SOFT     0
#define BMAGIC_REBOOT   0x01234567
#define BMAGIC_HALT     0xCDEF0123

#if defined(__GLIBC__)
  #define init_reboot(magic) reboot(magic)
#else
  #define init_reboot(magic) reboot(0xfee1dead, 672274793, magic)
#endif

#ifdef TRUE
#undef TRUE
#endif
#define TRUE 1
#ifdef FALSE
#undef FALSE
#endif
#define FALSE 0

/* Several typedefs */

typedef	unsigned char BYTE;
typedef unsigned short int  WORD;

typedef	struct {
	double	BatLoad;
	double	LineMin;
	double	LineMax;
	double	UPSLoad;
	double	LineFreq;
	double	LineVoltage;
	double	OutputVoltage;
	double	UPSTemp;
	double	BattVoltage;
	int	Status;
} UPSINFO;


/* Macros */

/* Variables */
extern int	notest;
extern int	slave;
extern int      master;
extern char	*use_port;
extern char	*master_name;
extern char	*logfilename;
extern char	*slaves[MAX_SLAVES];
extern int	num_slaves;
extern int	power_timer;
extern int	log_timer;
extern int	gottimeout;
extern int	mastertimeout;
extern int	gotpowerok;
extern int	masterbatlow;
extern int	socketfd;
extern int	newsocketfd;
extern float    min_batt_load;
extern struct sockaddr_in slave_adr[MAX_SLAVES];
extern int	slavesocket[MAX_SLAVES];

/* Function prototypes */


void start_daemon(void);
void signal_setup(void);
void sig_intr(int);
void sig_term(int);
void sig_hup(int);
void sig_alarm(int);
void dump_status (int);
void go_down(void);
void go_down_batt(void);
void send_second_z(int);
void do_shutdown(void);
void write_wtmp(void);
void umount_disks(void);
void umount_disks_ourselves(void);

void setup_tty(void);
int getline(int,char *);
int fillUPS(int,UPSINFO *);
void mesusr(char *,struct utmp *);
void mesall(char *);
int parse_config(void);
void log_UPS_status(void);
int get_master_message(int);
int send_to_slaves(int);
int send_info(int,int);
int prepare_slave(void);
int prepare_master(void);
void do_slave(void);
void do_master(void);
