/***************************************************************************
                          description
                             -------------------
begin		: July  2003
copyright	: (C) 2003 by Emre Uyguroglu
email		: 002415@students.emu.edu.tr
description	: this is a dialog for adding popular Sig2Dat links to downloads
		the code works but its very ugly, i'll clean it up sometime :)

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//example Sig2Dat links:

//  sig2dat://[|File Jackass S1-E01.mpg|Length 218660512 Bytes, 213536KB|UUHash: =sCtCN3xPiKJ1vzmBaYOWvB2Ciu8=|]

//  sig2dat://[|File:Bulletproof.Monk.CD1.INTERNAL.DVDRip.XviD-FiNaLe.avi|Length:731021312 Bytes,713888KB|UUHash:=E9C65ZzSrMRWCaxmbzOwiBxiWa4=|File:Bulletproof.Monk.CD2.INTERNAL.DVDRip.XviD-FiNaLe.avi|Length:731885568 Bytes,714732KB|UUHash:=66XAlFsRMznPzqESKbrs7lazeG4=|]

// sig2dat:///|File: The.Big.Lebowski.DVDRip.DivX-DVL.avi|Length: 762931200 Bytes, 745050KB|UUHash: =IqOpKHm64JPXOeM5eSgvnOQwAYU=|

// sig2dat:/|File:[tmd]2.fast.2.furious.(eso).ts.(1of2).avi|Length:231507968 Bytes,226082KB|UUHash:=9k3Ndxk6QKTMDztsWV/9096PWXM=|File:[tmd]2.fast.2.furious.(eso).ts.(2of2).avi|Length:221347840 Bytes,216160KB|UUHash:=hp+0LYGnsPlHxtwUOWXg3BwiyBU=|

#include <klocale.h>

#include "sigdialog.h"
#include "giftconnection.h"
#include "apollon.h"
//#include "sigdialog.moc"

#include <qvariant.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

static const char* const img0_sigdialog[] = {
"32 32 8 1",
". c #000000",
"f c #000040",
"e c #006040",
"# c #600000",
"a c #606000",
"b c #606040",
"d c #a0a080",
"c c #ffff00",
"................................",
"................................",
"................................",
"...#.#aaaa..aaa.aaaaa#..aa#.....",
"..#aaaaaab..aaa.aaaaaa..baa.....",
"..#aaacacb.#caabaaaaaaa#baaa....",
"..#abaaacb..accbcabacaa.acab....",
"..#aaacccde.cccbccaccccaccba....",
"..#aaaaacb..ccabccbccccbcaaa....",
"...aaccacd..accbccaccccbaaba....",
"...aaacdcd..cccbccbccccbcbca#...",
"...baccdcd..cccbccbccccaaaaa....",
"...aaccdcdf.cccdccbccccbcacba...",
"...aaccdcc..cdcdccaccccbaaab....",
"...aaacdccf.cdcdccbccccaccab....",
"...aaccdcd..cdcdccacccc.acca....",
"...acccbcdb#cdcdccbcccc.caccb...",
"...aaacbcd.#cdcdccaccccacabab...",
"...acacbcd..cbccccaccccbcabab...",
"...#accbcdbaccccccbccccbcbbcb...",
"....cccbcdbaccccccbccccbabdcb...",
"....aaabcdbaaccccabccccbcbdcb...",
"....accbdcaacdccccbacacbabaab...",
"....aacadccacdcccabacccbaacab...",
"....aacbbacccdcaaaaaaccbaaaab...",
"....aabbbccccdcbcabacccbaacbb...",
"....abbbbbbbbbababaabbbbaabbb...",
".....aaaabbabbbbab.abbb.aabb....",
"................................",
"................................",
"................................",
"................................"};


/* 
 *  Constructs a SigDialog as a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
SigDialog::SigDialog( giFTConnection * gcn,QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
,
      image0( (const char **) img0_sigdialog )
{
    if ( !name )
	setName( "SigDialog" );
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)3, 0, 0, sizePolicy().hasHeightForWidth() ) );
    setMinimumSize( QSize( 370, 220 ) );
    SigDialogLayout = new QGridLayout( this, 1, 1, 11, 6, "SigDialogLayout");
    _gcn=gcn;
    connect( this, SIGNAL( giftAddRequest( QString, QString, QString, QString, QString ) ), _gcn, SLOT( makeAddRequest( QString, QString, QString, QString, QString ) ) );
    layout6 = new QVBoxLayout( 0, 0, 6, "layout6");

    layout1 = new QHBoxLayout( 0, 0, 6, "layout1"); 

    textLabel = new QLabel( this, "textLabel" );
    layout1->addWidget( textLabel );

    lineEdit = new QLineEdit( this, "lineEdit" );
    layout1->addWidget( lineEdit );
    layout6->addLayout( layout1 );
    QSpacerItem* spacer = new QSpacerItem( 20, 16, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout6->addItem( spacer );

    layout4 = new QHBoxLayout( 0, 0, 6, "layout4"); 

    pixmapLabel4 = new QLabel( this, "pixmapLabel4" );
    pixmapLabel4->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, pixmapLabel4->sizePolicy().hasHeightForWidth() ) );
    pixmapLabel4->setPixmap( image0 );
    pixmapLabel4->setScaledContents( TRUE );
    layout4->addWidget( pixmapLabel4 );

    textLabel2 = new QLabel( this, "textLabel2" );
    textLabel2->setAlignment( int( QLabel::WordBreak | QLabel::AlignVCenter ) );
    layout4->addWidget( textLabel2 );
    layout6->addLayout( layout4 );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout6->addItem( spacer_2 );

    layout3 = new QHBoxLayout( 0, 0, 6, "layout3"); 
    QSpacerItem* spacer_3 = new QSpacerItem( 91, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout3->addItem( spacer_3 );

    okButton = new QPushButton( this, "okButton" );
    okButton->setOn( FALSE );
    layout3->addWidget( okButton );

    cancelButton = new QPushButton( this, "cancelButton" );
    cancelButton->setAutoDefault( FALSE );
    layout3->addWidget( cancelButton );
    layout6->addLayout( layout3 );

    SigDialogLayout->addLayout( layout6, 0, 0 );
    languageChange();
    resize( QSize(370, 221).expandedTo(minimumSizeHint()) );

    // signals and slots connections
    connect( cancelButton, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( okButton, SIGNAL( clicked() ), this, SLOT( addItem() ) );

    // buddies
    textLabel->setBuddy( lineEdit );
}

/*
 *  Destroys the object and frees any allocated resources
 */
SigDialog::~SigDialog()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void SigDialog::languageChange()
{
    setCaption( i18n( "Add Sig2Dat Link" ) );
    textLabel->setText( i18n( "&Sig2Dat link:" ) );
    textLabel2->setText( i18n( "Sig2Dat is a tool for using signatures (hashes) to share exact copies of a file on FastTrack network. In other words it is used to download verified files. You can paste a Sig2Dat link here to add the link directly to downloads. Search for Sig2Dat on google to find more info and links to Sig2Dat files." ) );
    okButton->setText( i18n( "&Ok" ) );
    cancelButton->setText( i18n( "&Cancel" ) );
}

void SigDialog::addItem()
{

    QString base64code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    QString sigurl = lineEdit->text();
    QString result;
    QString binary;
    QString hex;
    int File=0,Length=0,UUHash=0,find,cnt=0;
    QString temp=sigurl;
    while(cnt==0)
    {	cnt=0;
	find=temp.find("File");
	if(find!=-1){
	    temp=temp.right(temp.length()-find-4);
	    File++;
	}
	else	cnt=1;
	find=temp.find("Length");
	if(find!=-1){
	    temp=temp.right(temp.length()-find-6);
	    Length++;
	}
	else cnt=1;
	find=temp.find("UUHash");
	if(find!=-1){
	    temp=temp.right(temp.length()-find-6);
	    UUHash++;
	}
	else cnt=1;
    }
    if ((File==Length)&&(Length==UUHash)&&(temp.find("=|")>-1)){
	while (sigurl.find("File")!=-1){
	QString hashchar="";
	for(uint i=0;i<27;i++){
	    hashchar.append(sigurl.mid(sigurl.find("=")+1+i,1));
	    /*QChar myChar = hashchar[0];
	    int index = base64code.find(myChar);
	    result=dectobin(index);
	    uint k=result.length();
	    for(uint j=0;j<(6-k);j++)
		binary.append("0");
	    binary.append(result);
	    hex=bintohex(binary);*/
	}

	QString Hash="FTH:=";
	Hash.append(hashchar);
	Hash.append("=");
	QString size=sigurl.mid((sigurl.find("Length")+7),(sigurl.find("Bytes")-sigurl.find("Length")-2-6));
	QString fsturl ="FastTrack://127.0.0.1:0000/=";
	// FastTrack://192.168.1.101:1979/=fpUu1LQ+ja9je2sH6JEKd8HI0cM=?shost=209.6.21.91&sport=3074&uname=KazaaLiteK++FLA
	fsturl.append(hashchar);
	fsturl.append("=?shost=127.0.0.1&sport=0000&uname=foo");
	sigurl=sigurl.right(sigurl.length()-sigurl.find("File")-5);
	QString filename=sigurl.left(sigurl.find("Length")-1);
	emit giftAddRequest( "foo@127.0.0.1", Hash, size, fsturl , filename );
	sigurl=sigurl.right(sigurl.length()-sigurl.find("UUHash")-37);
	}
	accept();
    }
    else
    {
    lineEdit->clear();
    lineEdit->setText(i18n("Please enter a valid Sig2Dat link"));
    }
}

QString SigDialog::dectobin( int input )
{
    int i;
    int count = 0;
    int binary[32];
    do
    {
	i = input % 2;
	binary[count] = i;
	input = input / 2;
	count++;

    }
    while (input > 0);
    QString result;
    do
    {
	if(binary[count - 1])
	    result.append("1");
	else
	    result.append("0");
	count--;
    }
    while (count > 0);
    return result;
}

QString SigDialog::bintohex( QString bin )
{
    QString result;
    for(uint i=0;i<bin.length()/4;i++){
	QString hex = bin.mid( i*4, 4 );
	if(hex=="0000") result.append("0"); else
	if(hex=="0001") result.append("1"); else
	if(hex=="0010") result.append("2"); else
	if(hex=="0011") result.append("3"); else
	if(hex=="0100") result.append("4"); else
	if(hex=="0101") result.append("5"); else
	if(hex=="0110") result.append("6"); else
	if(hex=="0111") result.append("7"); else
	if(hex=="1000") result.append("8"); else
	if(hex=="1001") result.append("9"); else
	if(hex=="1010") result.append("a"); else
	if(hex=="1011") result.append("b"); else
	if(hex=="1100") result.append("c"); else
	if(hex=="1101") result.append("d"); else
	if(hex=="1110") result.append("e"); else
	if(hex=="1111") result.append("f");
    }
    return result;
}
