/* ================================================================= */
/* qsort <valore>...						     */
/* QuickSort.							     */
/* ================================================================= */

#include <stdio.h>

/* ================================================================= */
/* part ( <lista>, <inizio>, <fine> )				     */
/* ----------------------------------------------------------------- */
int part( int lista[], int a, int z ) {

    /* Viene preparata una variabile per lo scambio di valori.	     */
    int scambio = 0;

    /* Si assume che ``a'' sia inferiore a ``z''.		     */
    int i = a + 1;
    int cf = z;

    /* Inizia il ciclo di scansione dell'array.			     */
    while (1) {
	while (1) {

	    /* Sposta i a destra.				     */
	    if ( (lista[i] > lista[a]) || ( i >= cf) ) {
		break;
	    } else {
		i += 1;
	    }
	}
	while (1) {
	    /* Sposta cf a sinistra.				     */
	    if (lista[cf] <= lista[a]) {
		break;
	    } else {
		cf -= 1;
	    }
	}
	if ( cf <= i ) {
	    /*  avvenuto l'incontro tra i e cf.		     */
	    break;
	} else {
	    /* Vengono scambiati i valori.			     */
	    scambio = lista[cf];
	    lista[cf] = lista[i];
	    lista[i] = scambio;

	    i += 1;
	    cf -= 1;
	}
    }

    /* A questo punto lista[a..z]  stata ripartita e cf  la	     */
    /* collocazione di lista[a].				     */
    scambio = lista[cf];
    lista[cf] = lista[a];
    lista[a] = scambio;

    /* A questo punto, lista[cf]  un elemento (un valore) nella     */
    /* giusta posizione.					     */
    return cf;
}

/* ================================================================= */
/* quicksort ( <lista>, <inizio>, <fine> )			     */
/* ----------------------------------------------------------------- */
void quicksort( int lista[], int a, int z ) {

    /* Viene preparata la variabile cf.				     */
    int( cf ) = 0;

    if ( z > a ) {
	cf = part ( lista, a, z);
	quicksort ( lista, a, cf-1);
	quicksort ( lista, cf+1, z);
    }
}

/* ================================================================= */
/* Inizio del programma.					     */
/* ----------------------------------------------------------------- */
main( int argc, char *argv[] ) {

    int lista[argc-1];
    int i;

    /* Considera gli argomenti come gli elementi		     */
    /* dell'array da ordinare.					     */
    for ( i = 1; i < argc; i++ ) {
	sscanf( argv[i], "%d", &lista[i-1] );
    }

    /* Esegue il riordino.					     */
    quicksort( lista, 0, argc-2);

    /* Emette il risultato.					     */
    for ( i = 0; i < (argc-1); i++ ) {
	printf( "%d ", lista[i] );
    }
    printf( "\n" );
}
