#!/usr/bin/perl
#======================================================================
# Copyright (c) 1998 Daniele Giacomini daniele@pluto.linux.it
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
# contantore.pl
# Routine Perl per il conteggio degli accessi.
#======================================================================

use Fcntl ':flock'; # Importa le costanti di gestione dei file.

#======================================================================
# &FileLock ( <file handle>, <lock> )
#----------------------------------------------------------------------
sub FileLock {

    local ( $FILEHANDLE )   = $_[0];
    local ( $lock )         = $_[1];

    #------------------------------------------------------------------
    # Assegna dei valori predefiniti.
    #------------------------------------------------------------------
    if ( $lock <= 0 ) {
        $lock = LOCK_EX;
    };

    #------------------------------------------------------------------
    # 
    #------------------------------------------------------------------
    flock ( $FILEHANDLE, $lock );

    return 0;

};



#======================================================================
# &Contatore ( <file di conteggio> )
#----------------------------------------------------------------------
sub Contatore {

    local ( $file_contatore ) = $_[0];
    local ( $conteggio ) = 0;

    if ( -s $file_contatore ) {
        if ( open ( CONTATORE, $file_contatore ) ) {
            $conteggio = <CONTATORE>;
            close ( CONTATORE );
            chomp ($conteggio);
            $conteggio++;
            open ( CONTATORE, ">> $file_contatore" );
                flock ( CONTATORE, LOCK_EX ) ;
                    seek( CONTATORE, 0, 2 );
                    print CONTATORE ( "$conteggio\n" );
                
             close ( CONTATORE );
             print STDOUT ( "$conteggio\n" );
             return $contatore;
        };
    };
};


&Contatore ( "/tmp/cacca" );

#======================================================================
# Trattandosi di una libreria, l'ultima riga deve restituire un
# valore equiparabile a TRUE.
#----------------------------------------------------------------------
1;
#======================================================================

