//=====================================================================
// java BSortApp2.java
//=====================================================================

import java.lang.*; // predefinita

//---------------------------------------------------------------------
class BSortApp2 {

    //-----------------------------------------------------------------
    static int[] bsort(int[] lista, int a, int z) {

	int scambio;
	int k;

	if ( a < z ) {

	    //---------------------------------------------------------
	    // Scansione interna dell'array per collocare nella
	    // posizione a l'elemento giusto.
	    //---------------------------------------------------------
	    for ( k = a+1; k <= z; k++ ) {
		if ( lista[k] < lista[a] ) {

		    //-------------------------------------------------
		    // Scambia i valori
		    //-------------------------------------------------
		    scambio = lista[k];
		    lista[k] = lista[a];
		    lista[a] = scambio;
		}
	    }

	    bsort( lista, a+1, z );
	}

	return lista;
    }

    //=================================================================
    // Inizio del programma.
    //-----------------------------------------------------------------
    public static void main(String[] args) {

	int[] lista = new int[args.length];
	int i;

	//-------------------------------------------------------------
	// Conversione degli argomenti della riga di comando in
	// numeri.
	//-------------------------------------------------------------
	for ( i = 0; i < args.length; i ++ ) {
	    lista[i] = Integer.valueOf(args[i]).intValue();
	}

	//-------------------------------------------------------------
	// Ordina l'array.
	// In Java, gli array sono oggetti, e come tali vengono passati
	// per riferimento.
	//-------------------------------------------------------------
	 bsort( lista, 0, args.length-1);

	//-------------------------------------------------------------
	// Visualizza il risultato.
	//-------------------------------------------------------------
	for ( i = 0; i < lista.length; i ++ ) {
	    System.out.println( "lista[" + i + "] = " +
		lista[i] );
	}
    }

}
//=====================================================================
