#!/usr/bin/perl

##
my $curl="curl"; # or echo curl

syswrite(STDOUT,"This is an experimental script. You have been warned.\n");

use strict;

my ($cachedir, $baseurl, $verbose, $prios) = @ARGV;
die "USAGE: apt-precache apt-cacher-cachedir apt-cacher-base-url [ verbosity forced-prios ]
Examples:
apt-precache /var/cache/apt-cacher http://proxy/apt-cacher/
apt-precache /data/apt-cacher http://proxy/apt-cacher/ 1 required,important
NOTE: the options may change in the future
" if ! ($cachedir && $baseurl);

my $tmp=`mktemp`;
my $pcount=0;
chomp $tmp;

chdir "$cachedir/packages" || die "cannot enter $cachedir/packages" ;

my %pkgs;
for (<*>) { my $pn=$_; $pn=~s/_.*//g; $pkgs{$pn}=$_; }

for my $pgz (<*Packages*>) {
   my $acurl=$pgz;
   $acurl =~ s!_!/!g;
   my $pgzurl = "$baseurl/$acurl";
   $acurl =~ s!^!$baseurl/!;
   $acurl =~ s!/dists/.*!!; # that sucks, pure guessing

   
   my ($cat, $listpipe);
   $_=$pgz;
   $cat = (/bz2$/ ? "bzcat" : (/gz$/ ? "zcat" : "cat"));
   
   print "D: $pgzurl\n" if $verbose;
   
   # dl to temp file first, otherwise risking connection timout
   if((!system "curl", "--stderr", "/dev/null", "-o", $tmp, $pgzurl) && open(pfile,"-|",$cat,$tmp)) {

         my $prio;
      while(<pfile>) {
         if(/^Priority:\s+(.*)\n/) { $prio=$1; }
         if(/^Filename: (.*)\n/) {
            my $path=$1;
            s!.*/!!g;
            my ($file, $name) = (/^(([^\/_]+).*)\n/);
            if($file && defined($prios)) {
               if(!-e $file && $prios=~/$prio/) {
                  print "D: $acurl/$path\n" if $verbose;
                  system $curl, "-o", "/dev/null", "$acurl/$path";
               }
            }
            elsif($pkgs{$name}) {
               if(!-e $file) {
                  $pcount++;
                  print "D: $acurl/$path\n" if $verbose;
                  system $curl, "-o", "/dev/null", "$acurl/$path";
               }
            }
         }
      }
   }
}

unlink $tmp;

print "Downloaded: $pcount packages.\n" if $verbose;
