// pkg_description_treeitem.h   (this is -*-c++-*-)
//
//  Copyright 1999,2000,2001 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Shows the description of a package, obeying the various tree-node
// interfaces.  Somewhat different from most of the other pkg_* since it
// has no relation at all to any descendant of pkg_node.

#ifndef PKG_DESCRIPTION_TREEITEM_H
#define PKG_DESCRIPTION_TREEITEM_H

#include "aptitude.h"

#include "vscreen/vs_treeitem.h"
#include "apt_info_tree.h"

#include "pkg_grouppolicy.h"

#include <string>
#include <list>

class pkg_description_item:public vs_treeitem
{
  const std::string description;
public:
  pkg_description_item(const std::string &_description):vs_treeitem(false),description(_description) {}

  void paint(vs_tree *win, int y, bool hierarchical);

  const char *tag() const {return "";}
  const char *label() const {return "";}
};

class pkg_description:public vs_treeitem
{
  typedef std::list<pkg_description_item *> child_list;
  typedef child_list::iterator child_iterator;

  child_list children;
  std::string title;
protected:
  class levelref:public vs_tree_levelref
  {
    child_iterator realitem;
    child_list *parent_list;

  public:
    levelref(const levelref &x)
      :vs_tree_levelref(x), realitem(x.realitem), parent_list(x.parent_list) {}
    levelref(const child_iterator &_realitem, child_list *_parent_list)
      :realitem(_realitem), parent_list(_parent_list)
    {
    }

    vs_treeitem *get_item() {return *realitem;}
    virtual void advance_next() {realitem++;}
    virtual void return_prev() {realitem--;}
    bool is_begin() {return realitem==parent_list->begin();}
    bool is_end() {return realitem==parent_list->end();}
    levelref *clone() const {return new levelref(*this);}
  };

  // Used to initialize this (to work around problems with gettextizing
  // default args)
  void init(const pkgCache::VerIterator &ver, std::string _title);
public:
  pkg_description(const pkgCache::VerIterator &ver, std::string _title)
  {
    init(ver, _title);
  }
  pkg_description(const pkgCache::VerIterator &ver)
  {
    init(ver, _("Description"));
  }

  const char *tag() const {return _(title.c_str());}
  const char *label() const {return _(title.c_str());}

  void paint(vs_tree *win, int y, bool hierarchical);

  int get_normal_attr() {return A_BOLD;}

  levelref *begin() {return (!children.empty())?new levelref(children.begin(), &children):NULL;}
  levelref *end() {return (!children.empty())?new levelref(children.end(), &children):NULL;}
  bool has_visible_children() {return !children.empty();}

  ~pkg_description()
  {
    child_iterator curr,next;
    for(curr=children.begin(); curr!=children.end(); curr=next)
      {
	next=curr;
	next++;
	delete *curr;
      }
  }
};

// Displays the description of a package (quick hack to test the above)
class pkg_description_screen:public apt_info_tree
{
protected:
  vs_treeitem *setup_new_root(const pkgCache::PkgIterator &pkg,
			      const pkgCache::VerIterator &ver);
public:
  pkg_description_screen(const pkgCache::VerIterator &pkg);
};

#endif
