// vs_bin.h        -*-c++-*-
//
//  Generic stuff for a container that can only handle one child.

#ifndef VS_BIN_H
#define VS_BIN_H

#include "vs_passthrough.h"

class vs_bin:public vs_passthrough
{
  vscreen_widget *subwidget;

  // These are unfortunate necessities; when a widget is /removed/
  // (but not destroyed), it is necessary to delete the connections to
  // it.  :-(
  SigC::Connection show_conn, hide_conn;

  // right now these just show or hide the bin itself
  void show_widget(vscreen_widget *w);
  void hide_widget(vscreen_widget *w);
public:
  vs_bin();
  virtual ~vs_bin();

  void set_subwidget(vscreen_widget *w);
  vscreen_widget *get_subwidget() {return subwidget;}

  virtual void show_all();

  virtual void add_widget(vscreen_widget *w);
  virtual void rem_widget(vscreen_widget *w);

  vscreen_widget *get_focus();
};

#endif
