// vs_button.cc

#include "vs_button.h"

#include "vscreen.h"

#include "config/keybindings.h"

vs_button::vs_button(std::string _label)
  :label(_label)
{
  focussed.connect(slot(this, &vs_button::accept_focus));
  unfocussed.connect(slot(this, &vs_button::lose_focus));
}

bool vs_button::focus_me()
{
  return true;
}

bool vs_button::get_cursorvisible()
{
  return get_isfocussed();
}

point vs_button::get_cursorloc()
{
  return point(0,0);
}

void vs_button::accept_focus()
{
  vscreen_update();
}

void vs_button::lose_focus()
{
  vscreen_update();
}

void vs_button::paint()
{
  if(get_isfocussed())
    {
      bkgdset(get_bg()^A_REVERSE);
      attrset(get_bg()^A_REVERSE);
    }

  std::string out="[ "+label+" ]";

  // FIXME: do this Better[tm]..maybe even make this a container holding
  // a label like in GTK+??
  mvaddnstr(0, 0, out.c_str(), out.size());
}

void vs_button::dispatch_mouse(short id, int x, int y, int z, mmask_t bmask)
{
  if(bmask & (BUTTON1_CLICKED | BUTTON2_CLICKED |
	      BUTTON3_CLICKED | BUTTON4_CLICKED |
	      BUTTON1_RELEASED | BUTTON2_RELEASED |
	      BUTTON3_RELEASED | BUTTON4_RELEASED))
    pressed();
}

bool vs_button::handle_char(chtype ch)
{
  if(global_bindings.key_matches(ch, "PushButton") || global_bindings.key_matches(ch, "Confirm"))
    {
      pressed();
      return true;
    }
  else
    return vscreen_widget::handle_char(ch);
}

size vs_button::size_request()
{
  return size(label.size()+4, 1);
}
