// vs_util.h      -*-c++-*-
//
//  Copyright 2000 Daniel Burrows
//
//  Provides a bunch of utility functions to construct prefabricated
// widget trees (for instance, handy message boxes)

#ifndef VS_UTIL_H
#define VS_UTIL_H

#include "slotarg.h"
#include "vs_editline.h"

#include <string>

class vscreen_widget;

// Canned dialog-boxes:
vscreen_widget *vs_dialog_ok(std::string msg, Slot0Arg okslot=NULL);
vscreen_widget *vs_dialog_ok(std::string msg, Slot0Arg okslot,
			     int attr);
vscreen_widget *vs_dialog_ok(std::string msg, Slot0Arg okslot, std::string label,
			     int attr);

vscreen_widget *vs_dialog_yesno(std::string msg,
				Slot0Arg yesslot,
				Slot0Arg noslot,
				bool deflt=true);
vscreen_widget *vs_dialog_yesno(std::string msg,
				Slot0Arg yesslot,
				Slot0Arg noslot,
				int attr,
				bool deflt=true);
vscreen_widget *vs_dialog_yesno(std::string msg,
				Slot0Arg yesslot,
				std::string yeslabel,
				Slot0Arg noslot,
				std::string nolabel,
				int attr,
				bool deflt=true);

vscreen_widget *vs_dialog_fileview(std::string fn,
				   Slot0Arg okslot=NULL);
vscreen_widget *vs_dialog_fileview(std::string fn,
				   Slot0Arg okslot,
				   int attr);

vscreen_widget *vs_dialog_string(std::string msg,
				 std::string deflt,
				 SlotArg<SigC::Slot1<void, std::string> > okslot,
				 SlotArg<SigC::Slot0<void> > cancel_slot,
				 SlotArg<SigC::Slot1<void, std::string> > changed_slot,
				 vs_editline::history_list *history,
				 int attr);
vscreen_widget *vs_dialog_string(std::string msg,
				 std::string deflt,
				 SlotArg<SigC::Slot1<void, std::string> > slot,
				 SlotArg<SigC::Slot0<void> > cancel_slot,
				 SlotArg<SigC::Slot1<void, std::string> > changed_slot,
				 vs_editline::history_list *history);

#endif
