// vscreen_widget.cc

#include "vscreen_widget.h"
#include "vs_container.h"

// needed for queuelayout:
#include "vscreen.h"

#include <sigc++/bind.h>

#include <config/colors.h>
#include <config/keybindings.h>

#include <assert.h>

#ifdef HAVE_CONFIG_H
#include "../../config.h"
#endif

using namespace std;

// Queues of things that Need To Be Done
static list<vscreen_widget *> todelete;
static list<vscreen_widget *> toresize;

vscreen_widget::vscreen_widget()
  :win(NULL),
   timeout_value(0),
   owner(NULL),
   geom(0,0,0,0),
   visible(false),
   bgattr(get_color("DefaultWidgetBackground")),
   isfocussed(false)
{
  focussed.connect(bind(slot(this, &vscreen_widget::set_isfocussed), true));
  unfocussed.connect(bind(slot(this, &vscreen_widget::set_isfocussed), false));
}

vscreen_widget::~vscreen_widget()
{
  assert(!owner);
}

void vscreen_widget::set_isfocussed(bool _isfocussed)
{
  isfocussed=_isfocussed;
}

void vscreen_widget::handle_pending_deletes()
{
  // don't delete -- debugging

  //for(list<vscreen_widget *>::iterator i=todelete.begin();
  //    i!=todelete.end();
      //    i++)
  //  delete *i;

  todelete.erase(todelete.begin(), todelete.end());
}

void vscreen_widget::set_owner_window(cwindow _win, int x, int y, int w, int h)
{
  if(_win)
    {
      geom.x=x;
      geom.y=y;
      geom.w=w;
      geom.h=h;

      if(geom.h==0 || geom.w==0)
	win=NULL;
      else
	{
	  win=_win.derwin(geom.h,
			  geom.w,
			  geom.y,
			  geom.x);
	  win.keypad(true);
	}
    }
  else
    win=NULL;

  // NOT queue_layout()! (that would be just Dumb[tm])
  do_layout();
}

void vscreen_widget::alloc_size(int x, int y, int w, int h)
{
  if(owner)
    set_owner_window(owner->win, x, y, w, h);
  else
    set_owner_window(NULL, x, y, w, h);
}

void vscreen_widget::set_owner(vs_container *_owner)
{
  owner=_owner;
  alloc_size(0,0,0,0);

  if(owner==NULL)
    destroy();
}

int vscreen_widget::timeout(int msecs)
{
  int prevval=timeout_value;
  timeout_value=msecs;
  if(win)
    win.timeout(msecs);
  return prevval;
}

void vscreen_widget::destroy()
{
  hide();

  if(owner)
    owner->rem_widget(this);

  assert(!win);

  destroyed();

  // Disconnect all signals:

  shown_sig.clear();
  hidden_sig.clear();
  destroyed.clear();
  do_layout.clear();
  focussed.clear();
  unfocussed.clear();

  invalid();

  for(list<vscreen_widget *>::iterator i=todelete.begin();
      i!=todelete.end();
      i++)
    if(*i==this)
      return;

  todelete.push_back(this);
}

void vscreen_widget::show()
{
  visible=true;

  shown_sig();
}

void vscreen_widget::show_all()
{
  show();
}

void vscreen_widget::hide()
{
  visible=false;

  hidden_sig();
}

void vscreen_widget::display()
{
  if(bgattr!=-1)
    {
      bkgd(bgattr);
      erase();
      attrset(bgattr);
    }

  paint();
}

void vscreen_widget::set_bg(int _bgattr)
{
  // Should I queue a redraw?  Right now I'm not doing that..
  bgattr=_bgattr;
}

bool vscreen_widget::focus_me()
{
  return !auxillary_bindings.empty();
}

bool vscreen_widget::handle_char(chtype ch)
{
  bool rval=false;

  for(key_connection i=auxillary_post_bindings.begin();
      i!=auxillary_post_bindings.end();
      i++)
    if(i->bindings->key_matches(ch, i->keyname))
      {
	i->slot.call();
	rval=true;
      }

  return rval;
}

bool vscreen_widget::dispatch_char(chtype ch)
{
  bool rval=false;

  for(key_connection i=auxillary_bindings.begin();
      i!=auxillary_bindings.end();
      i++)
    if(i->bindings->key_matches(ch, i->keyname))
      {
	i->slot.call();
	rval=true;
      }

  return rval || handle_char(ch);
}

void vscreen_widget::dispatch_mouse(short id, int x, int y, int z,
				    mmask_t bmask)
{
}

vscreen_widget::key_connection vscreen_widget::connect_key(const string &key,
							   keybindings *bindings,
							   const SigC::Slot0<void> &slot)
{
  auxillary_bindings.push_back(binding_connection(key, bindings, slot));

  key_connection rval=auxillary_bindings.end();
  --rval;

  return rval;
}

vscreen_widget::key_connection vscreen_widget::connect_key_post(const string &key,
								keybindings *bindings,
								const SigC::Slot0<void> &slot)
{
  auxillary_post_bindings.push_back(binding_connection(key, bindings, slot));

  key_connection rval=auxillary_bindings.end();
  --rval;

  return rval;
}

void vscreen_widget::disconnect_key(key_connection key)
{
  auxillary_bindings.erase(key);
}

void vscreen_widget::disconnect_key_post(key_connection key)
{
  auxillary_post_bindings.erase(key);
}
