// matchers.h  -*-c++-*-
//
//  Copyright 2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Provides support for complex string-based matching of packages.  Patterns
// can be compiled for later use or used and discarded.

#ifndef MATCHERS_H
#define MATCHERS_H

#include <apt-pkg/pkgcache.h>

class pkg_matcher
// A closure describing a matching rule.  Note that we match on a particular
// version, not just on the package (this is because some attributes are pretty
// meaningless for only a package)
{
public:
  virtual bool matches(pkgCache::PkgIterator pkg, pkgCache::VerIterator ver)=0;
  virtual ~pkg_matcher() {}
};

pkg_matcher *parse_pattern(string s, bool flag_errors=true);
inline bool pkg_matches(string s, pkgCache::PkgIterator pkg, pkgCache::VerIterator ver)
{
  pkg_matcher *m=parse_pattern(s);
  if(!m)
    return false;
  else
    {
      bool rval=m->matches(pkg, ver);
      delete m;
      return rval;
    }
}

#endif
