// vs_radiogroup.h                    -*-c++-*-
//
//  Ok, here's how radio-button-like behavior is implemented:
//
//  Radio-groups store some group of buttons.  They constrain the buttons
// so that exactly one is on.  This is done by various devious means:
// the first button added is always selected, and subsequently added selected
// buttons override previously selected buttons.  You can manually select a
// button through this class (by ID) or via the button's own set_checked
// routine.
//
//  (note that radio-groups are NOT WIDGETS!!!)
//  (note that this does NOT attempt to memory-manage its "children"!)
//  (note that you should generally delete this at the same time as its
//   children, or Bad Things[tm] may happen.. (more specifically, if you
//   delete a selected child, some other random option will be selected))
//
//  Oh, one more note: although any togglebutton can be used in a radio
// widget, passing in checkbuttons has a high probability of causing weird
// things.  Use radiobuttons.  (if you want them to look like checkbuttons,
// use the extended togglebutton constructor..)

#ifndef VS_RADIOGROUP_H
#define VS_RADIOGROUP_H

#include "vs_togglebutton.h"

#include <vector>

#include <sigc++/object.h>

class vs_radiogroup:public SigC::Object
{
  struct item
  {
    vs_togglebutton *b;
    int id;

    // Needed, unfortunately.
    SigC::Connection destroyed_conn, pressed_conn;

    item(vs_togglebutton *_b, int _id,
	 const SigC::Connection &_dconn, const SigC::Connection &_pconn)
      :b(_b), id(_id), destroyed_conn(_dconn), pressed_conn(_pconn) {}
  };

  typedef std::vector<item> itemlist;

  itemlist items;

  // The index of the currently selected button
  itemlist::size_type selected;

  // Called when a particular button is selected.
  // The argument is the *index* of the button.
  void button_pressed(itemlist::size_type index);
public:
  vs_radiogroup():selected(items.max_size()) {}
  ~vs_radiogroup();

  void add_button(vs_togglebutton *b, int id);
  void rem_button(vs_togglebutton *b);

  int get_selected() {return items[selected].id;}
  // Selects a button by id.
  void select(int id);

  // Emitted when one of the sub-items is chosen.  (you could also collect
  // the individual button signals; this is just a higher-level view of it)
  SigC::Signal1<void, int> item_selected;
};

#endif
