/***************************************************************************
 $RCSfile: aqmprogressmonitor.cpp,v $
                             -------------------
    cvs         : $Id: aqmprogressmonitor.cpp,v 1.3 2003/05/18 03:02:11 aquamaniac Exp $
    begin       : Thu Apr 03 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "aqmprogressmonitor.h"


AQMProgressMonitor::AQMProgressMonitor(AQMAPI *api)
  :HBCI::ProgressMonitor()
  ,_api(api){

}


AQMProgressMonitor::~AQMProgressMonitor() {
};


void AQMProgressMonitor::transactionStarted(TransProgressType type,
					    string const &descr, int jobs){
  if (_api->debugLevel()>0) {
    fprintf(stderr,"==================================\n");
    fprintf(stderr,"Beginn der Transaktionen\n");
  }
}


void AQMProgressMonitor::transactionFinished(){
  if (_api->debugLevel()>0) {
    fprintf(stderr,"==================================\n");
    fprintf(stderr,"Transaktionen beendet.\n");
  }
}


void AQMProgressMonitor::jobStarted(JobProgressType t,
				    const string &descr, int actions){
  string s;

  if (_api->debugLevel()>0)
    fprintf(stderr,"----------------------------------\n");
  s+="Neuer Auftrag: ";
  switch(t) {
  case JOB_OPENINGDIALOG:
    s+="Dialog eroeffnen";
    break;
  case JOB_CLOSINGDIALOG:
    s+="Dialog schliessen";
    break;
  case JOB_OPENINGNETWORK:
    s+="Verbindung herstellen";
    break;
  case JOB_CLOSINGNETWORK:
    s+="Verbindung trennen";
    break;
  case JOB_GET_BALANCE:
    s+="Kontostand abrufen";
    break;
  case JOB_GET_TRANS:
    s+="Kontoauszuege abrufen";
    break;
  case JOB_NEW_TRANSFER:
    s+="Ueberweisung taetigen";
    break;
  case JOB_DEBIT_NOTE:
    s+="Lastschrift einziehen";
    break;
  case JOB_GET_STO:
    s+="Dauerauftraege abrufen";
    break;
  case JOB_NEW_STO:
    s+="Dauerauftrag einrichten";
    break;
  case JOB_DELETE_STO:
    s+="Dauerauftrag loeschen";
    break;
  case JOB_GET_ACCOUNTS:
    s+="Kontenliste abrufen";
    break;
  case JOB_GET_SYSTEMID:
    s+="Systemkennung abrufen";
    break;
  case JOB_GET_KEYS:
    s+="Schluessel des Servers abrufen";
    break;
  case JOB_SEND_KEYS:
    s+="Oeffentliche Schluessel senden";
    break;
  case JOB_DISABLE_KEYS:
    s+="Schluessel sperren";
    break;
  case JOB_CHANGE_KEYS:
    s+="Schluessel aendern";
    break;
  case JOB_GET_STATUS:
    s+="Ueberweisungen und Lastschriften pruefen";
    break;
  default:
    s+=descr;
  } // switch

  fprintf(stderr,"%s\n", s.c_str());
}


void AQMProgressMonitor::jobFinished(){
  fprintf(stderr,"Auftrag erledigt.\n");
}


void AQMProgressMonitor::actionStarted(ActionProgressType t,
				       const string &descr){
  string s;

  if (_api->debugLevel()>0) {
    switch(t) {
    case ACT_SENDINGMESSAGE:
      s+="Sende Nachricht";
      break;
    case ACT_WAITRESPONSE:
      s+="Warte auf Antwort";
      break;
    case ACT_CREATEHBCIJOB:
      s+="Erzeuge HBCI-Auftraege";
      break;
    case ACT_CONTACTINGSERVER:
      s+="Verbinde mit Server";
      break;
    case ACT_CHKRESULT:
      s+="Auswertung des Auftrages";
      break;
    case ACT_UPDATESYSTEM:
      s+="Aktualisiere die Daten";
      break;
    case ACT_CLOSECONNECTION:
      s+="Trenne Verbindung zum Server";
      break;
    default:
      s=descr;
    } // switch
    fprintf(stderr," %s\n", s.c_str());
  }
}


void AQMProgressMonitor::actionFinished(){
}


void AQMProgressMonitor::logMessage(const string &msg){
  fprintf(stderr,"Log: %s\n",msg.c_str());
}


