/***************************************************************************
 $RCSfile: xactionmatcher.h,v $
 -------------------
 cvs         : $Id: xactionmatcher.h,v 1.1 2003/05/29 15:37:47 aquamaniac Exp $
 begin       : Mon Jan 20 2003
 copyright   : (C) 2003 by Martin Preuss
 email       : martin@aquamaniac.de
 */

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XACTIONMATCHER_H
#define XACTIONMATCHER_H

#include <openhbci.h>
#include <string>
#include "aqmtypes.h"


#define TM_FLAGS_POSITIVE   0x0001
#define TM_FLAGS_NEGATIVE   0x0002
#define TM_FLAGS_OPEN       0x0004
#define TM_FLAGS_FAILED     0x0008
#define TM_FLAGS_DONE       0x0010
#define TM_FLAGS_NO_UNKNOWN 0x0020

#define TM_FLAGS_DEFAULT ( \
  TM_FLAGS_POSITIVE | \
  TM_FLAGS_NEGATIVE | \
  TM_FLAGS_OPEN | \
  TM_FLAGS_FAILED | \
  TM_FLAGS_DONE \
  )

/**
 *
 */
class TransactionMatcher {
private:
  int _country;
  string _institute;
  string _account;
  HBCI::Date _fromdate;
  HBCI::Date _todate;
  unsigned int _flags;

public:
  TransactionMatcher();
  TransactionMatcher(int country,
		     const string &institute,
		     const string &account,
		     HBCI::Date fromdate,
		     HBCI::Date todate,
		     unsigned int flags);
  ~TransactionMatcher();
  bool match(const AQMTransaction &xa);
};



#endif

