/***************************************************************************
 $RCSfile: getbalance.cpp,v $
                             -------------------
    cvs         : $Id: getbalance.cpp,v 1.7 2003/05/18 03:02:12 aquamaniac Exp $
    begin       : Sat Jan 26 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


/*
 */

#include "getbalance.h"


HBCI::Error getBalance(HBCI::Pointer<AQMAPI> hbciif,
		       HBCI::SimpleConfig &opt){
    HBCI::Pointer<HBCI::OutboxJob> job;
    HBCI::Tree<HBCI::ConfigNode>::iterator var;
    int country;
    string instid;
    string accnr;
    string custid;
    list<HBCI::Pointer<HBCI::Account> > accounts;
    list<HBCI::Pointer<HBCI::Account> >::iterator it;
    HBCI::Pointer<HBCI::Customer> cust;
    HBCI::Error err;

    job.setDescription("getBalance:job (HBCI::OutboxJob)");
    country=opt.getIntVariable("country",0,opt.root());
    instid=opt.getVariable("instid","*",opt.root());
    custid=opt.getVariable("customer","",opt.root());
    accnr=opt.getVariable("accnr","*",opt.root());
    // get accounts
    accounts=hbciif.ref().getAccounts(country,
                                      instid,
                                      accnr);
    if (accounts.empty())
        return HBCI::Error("getbalance()",
                         ERROR_LEVEL_NORMAL,
                         0,
                         ERROR_ADVISE_DONTKNOW,
                         "account not found");

    // create jobs
    for (it=accounts.begin();
         it!=accounts.end();
         it++) {
        // get authorized customer for this account
        if (!custid.empty()) {
            // customer given
            cust=(*it).ref().bank().ref().findCustomer(custid);
            if (!cust.isValid())
                return HBCI::Error("getbalance()",
                                 ERROR_LEVEL_NORMAL,
                                 0,
                                 ERROR_ADVISE_DONTKNOW,
                                 "customer not found");
            if (!((*it).ref().isAuthorized(cust)))
                return HBCI::Error("getbalance()",
                                 ERROR_LEVEL_NORMAL,
                                 0,
                                 ERROR_ADVISE_DONTKNOW,
                                 "customer is not authorized");
        }
        else {
            // not given, try the first in the list
            list<HBCI::Pointer<HBCI::Customer> > custlist;

            custlist=(*it).ref().authorizedCustomers();
            if (custlist.empty())
                return HBCI::Error("getbalance()",
                                 ERROR_LEVEL_NORMAL,
                                 0,
                                 ERROR_ADVISE_DONTKNOW,
                                 "no authorized customer for this account");
            cust=custlist.front();
        }

        // create job for this account
        job=new HBCI::OutboxJobGetBalance(cust,*it);
        // enqueue job
        hbciif.ref().addJob(job);
    } // for
    try {
        err=hbciif.ref().executeQueue(true);
    }
    catch (HBCI::Error lerr) {
        err=lerr;
    }
    cerr<<"Got balance.\n";
    return err;
}





