/***************************************************************************
 $RCSfile: getstatus.cpp,v $
                             -------------------
    cvs         : $Id: getstatus.cpp,v 1.1 2003/05/18 03:02:12 aquamaniac Exp $
    begin       : Sat May 17 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <openhbci.h>
#include "getstatus.h"


HBCI::Error getStatus(HBCI::Pointer<AQMAPI> hbciif,
		      HBCI::SimpleConfig &opt){
  HBCI::Pointer<HBCI::OutboxJobGetStatusReports> job;
  HBCI::Pointer<HBCI::Customer> cust;
  HBCI::Tree<HBCI::ConfigNode>::iterator var;
  int country;
  string instid;
  string custid;
  list<HBCI::Pointer<HBCI::Bank> > banks;
  HBCI::Error err;
  string fdate;
  string tdate;
  HBCI::Date fromdate;
  HBCI::Date todate;
  list<HBCI::Pointer<HBCI::OutboxJobGetStatusReports> > jobs;
  list<HBCI::Pointer<HBCI::OutboxJobGetStatusReports> >::iterator jit;
  list<HBCI::Pointer<HBCI::Customer> > custs;
  list<HBCI::Pointer<HBCI::Customer> >::iterator it;

  job.setDescription("getstatus:job (OutboxJob)");
  country=opt.getIntVariable("country",0,opt.root());
  instid=opt.getVariable("instid","*",opt.root());
  custid=opt.getVariable("customer","*",opt.root());
  fdate=opt.getVariable("fromdate","",opt.root());
  tdate=opt.getVariable("todate","",opt.root());

  // set from date
  if (!fdate.empty()) {
    fromdate=HBCI::Date(fdate,4);
    if (!fromdate.isValid())
      return HBCI::Error("getstatus()",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "error in date format.");
  }
  else {
    /* fromdate is empty, look for the first transaction which is still
     */
    list<AQMTransaction>::iterator tit;

    for (tit=hbciif.ref().transfers().begin();
	 tit!=hbciif.ref().transfers().end();
	 tit++) {
      if ((*tit).status().result()==10) {
	if (fromdate.isValid()) {
	  if ((*tit).status().date().isValid()) {
	    if ((*tit).status().date()<fromdate)
	      fromdate=(*tit).status().date();
	  }
	}
	else {
	  if ((*tit).status().date().isValid())
	    fromdate=(*tit).status().date();
	}
      }
    }
    if (!fromdate.isValid()) {
      // still no valid date, use today
      DateTime dt=DateTime::currentTime();
      fromdate=Date(dt.day(), dt.month(), dt.year());
    }
  }

  // set todate
  if (!tdate.empty()) {
    todate=HBCI::Date(tdate,4);
    if (!todate.isValid())
      return HBCI::Error("getstatus()",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "error in date format.");
  }

  // get customers
  custs=hbciif.ref().getCustomers(country, instid, custid);
  if (custs.empty())
    return HBCI::Error("getstatus()",
		       ERROR_LEVEL_NORMAL,
		       0,
		       ERROR_ADVISE_DONTKNOW,
		       "no customer found");

  // create jobs
  for (it=custs.begin();
       it!=custs.end();
       it++) {

    // create job for this account
    job=new HBCI::OutboxJobGetStatusReports(*it, fromdate, todate, -1);
    // enqueue job
    hbciif.ref().addJob(job.cast<OutboxJob>());
    jobs.push_back(job);
  } // for
  try {
    err=hbciif.ref().executeQueue(true);
  }
  catch (HBCI::Error lerr) {
    err=lerr;
  }
  if (!err.isOk())
    return HBCI::Error("getstatus", err);

  // now check all jobs for status reports
  for (jit=jobs.begin();
       jit!=jobs.end();
       jit++) {
    list<HBCI::StatusReport>::const_iterator sit;

    // check all status reports received
    for (sit=(*jit).ref().statusReports().begin();
	 sit!=(*jit).ref().statusReports().end();
	 sit++) {
      list<AQMTransaction>::iterator tit;

      // find transfer, for which we have this status
      if ((*sit).segment()!=-1) {
	bool haveTransfer;

	haveTransfer=false;
	for (tit=hbciif.ref().transfers().begin();
	     tit!=hbciif.ref().transfers().end();
	     tit++) {
	  HBCI::StatusReport oldst;

	  oldst=(*tit).status();
	  if ((oldst.messageReference()==(*sit).messageReference()) &&
	      (oldst.segment()==(*sit).segment())) {
	    // found transfer, replace status
	    (*tit).setStatus(*sit);
	    haveTransfer=true;
	    break;
	  }
	} // for transfer
	if (!haveTransfer) {
	  if (hbciif.ref().debugLevel()>1) {
	    fprintf(stderr, "Unmatched status : \n");
	    fprintf(stderr, "------------------ \n");
	    fprintf(stderr, "%s\n",
		    (*sit).dump().c_str());
	  }
	}
	else {
	  if (hbciif.ref().debugLevel()>2) {
	    fprintf(stderr, "Matched status : \n");
	    fprintf(stderr, "---------------- \n");
	    fprintf(stderr, "%s\n",
		    (*sit).dump().c_str());
	  }
	}
      } // if segment is given
    } // for reports
  } // for jobs


  return HBCI::Error();
}







