/***************************************************************************
 $RCSfile: report.cpp,v $
 -------------------
 cvs         : $Id: report.cpp,v 1.6 2003/05/18 03:02:12 aquamaniac Exp $
 begin       : Mon Jan 20 2003
 copyright   : (C) 2003 by Martin Preuss
 email       : martin@aquamaniac.de
 */

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "report.h"
#include "xactionmatcher.h"

const char monthNames[12][12]={
  "Januar",
  "Februar",
  "Mrz",
  "April",
  "Mai",
  "Juni",
  "Juli",
  "August",
  "September",
  "Oktober",
  "November",
  "Dezember"
};


string report_html(HBCI::Pointer<HBCI::Account> acc,
		   unsigned int flags,
		   int year,
		   int month,
		   int accountidx) {
  list<HBCI::Transaction>::const_iterator iter;
  string result;
  HBCI::Date tmpdate;
  double vmonthplus, vmonthminus;
  double vyearplus, vyearminus;
  string tmps;
  TransactionMatcher tm;
  HBCI::Value val;
  string l;
  double vals[31*12][2];
  int i, j;
  HBCI::Date fromdate;
  HBCI::Date todate;
  int idx;
  int count;

  if (month) {
    fromdate=HBCI::Date(1,month,year);
    todate=HBCI::Date(31,month,year);
  }
  else {
    fromdate=HBCI::Date(1,1,year);
    todate=HBCI::Date(31,12,year);
  }
  tm=TransactionMatcher(0,
			"*",
			"*",
			fromdate,
			todate,
			flags & 0xffff);
  // clear values
  for (i=0; i<31*12; i++) {
    vals[i][0]=0.0;
    vals[i][1]=0.0;
  } // for

  // sample data
  count=0;
  for (iter=acc.ref().transactions().begin();
       iter!=acc.ref().transactions().end(); iter++) {
    // check for match
    if (tm.match(*iter)) {
      count++;
      tmpdate=(*iter).valutaDate();
      if (!tmpdate.isValid())
	tmpdate=(*iter).date();
      if (tmpdate.isValid()) {
	idx=((tmpdate.month()-1)*31)+tmpdate.day()-1;

	if ((*iter).value().getValue()<0) {
	  vals[idx][1]-=((*iter).value().getValue());
	}
	else {
	  vals[idx][0]+=((*iter).value().getValue());
	}
      }
      else
	fprintf(stderr,"Invalid date (%d/%d/%d).\n",
		tmpdate.day(), tmpdate.month(), tmpdate.year());
    } // if match
  } // for

  if (count==0) {
    result="--- no data ---<br>";
    return result;
  }

  // show data
  vyearplus=0.0;
  vyearminus=0.0;

  for (i=0; i<12; i++) {
    if (month==0 || month==i+1) {
      vmonthplus=0.0;
      vmonthminus=0.0;
      if (flags&AQM_REPORT_FLAGS_SHOW_MONTHS) {
	result+="<a name=konto";
	result+=HBCI::String::num2string(accountidx);
	result+="month";
	result+=HBCI::String::num2string(i+1);
        result+="></a>";
	result+="<h2>Monatsbilanz f&uuml;r ";
	result+=monthNames[i];
	result+=" ";
	result+=HBCI::String::num2string(year);
	result+="</h2>";
      } // if month reports wanted
      if ((flags&AQM_REPORT_FLAGS_SHOW_MONTHS) ||
	  (flags&AQM_REPORT_FLAGS_SHOW_DAYS)) {
	result+="<table WIDTH=600 BORDER=1>";
	result+="<tr>";
	result+="<th>Datum</th>";
	result+="<th>Einnahmen</th>";
	result+="<th>Ausgaben</th>";
	result+="<th>Bilanz</th>";
	result+="</tr>";
      }
      for (j=0; j<31; j++) {
	idx=i*31+j;
	vmonthplus+=vals[idx][0];
	vmonthminus+=vals[idx][1];
	vyearplus+=vals[idx][0];
	vyearminus+=vals[idx][1];

	if ((vals[idx][0]!=0.0 ||
	     vals[idx][1]!=0.0 ||
	     (flags&AQM_REPORT_FLAGS_SHOW_NULL)) &&
	    (flags&AQM_REPORT_FLAGS_SHOW_DAYS)) {
	  l="<tr>";
	  l+="<td align=right>";
	  l+=HBCI::String::num2string(j+1);
	  l+=".";
	  l+=HBCI::String::num2string(i+1);
	  l+=".";
	  l+=HBCI::String::num2string(year);
	  l+="</td>";
	  l+="<td align=right>";
	  val=HBCI::Value(vals[idx][0], acc.ref().currency());
	  tmps=val.toReadableString();
	  l+=tmps;
	  l+="</td>";
	  l+="<td align=right>";
	  val=HBCI::Value(vals[idx][1], acc.ref().currency());
	  tmps=val.toReadableString();
	  l+=tmps;
	  l+="</td>";
	  l+="<td align=right>";
	  val=HBCI::Value(vals[idx][0]-vals[idx][1], acc.ref().currency());
	  tmps=val.toReadableString();
	  if (val.getValue()<0) {
	    l+="<font color=red>";
	    l+=tmps;
            l+="</font>";
	  }
          else
	    l+=tmps;
	  l+="</td>";
	  l+="</tr>";
	  result+=l;
	} // if moves
      } // days
      if (flags&AQM_REPORT_FLAGS_SHOW_MONTHS) {
	l="<tr>";
	l+="<td align=center><b>";
	l+="Gesamt";
	l+="</b></td>";
	l+="<td align=right><b>";
	val=HBCI::Value(vmonthplus, acc.ref().currency());
	tmps=val.toReadableString();
	l+=tmps;
	l+="</b></td>";
	l+="<td align=right><b>";
	val=HBCI::Value(vmonthminus, acc.ref().currency());
	tmps=val.toReadableString();
	l+=tmps;
	l+="</b></td>";
	l+="<td align=right><b>";
	val=HBCI::Value(vmonthplus-vmonthminus, acc.ref().currency());
	tmps=val.toReadableString();
	if (val.getValue()<0) {
	  l+="<font color=red>";
	  l+=tmps;
	  l+="</font>";
	}
	else
	  l+=tmps;
	l+="</b></td>";
	l+="</tr>";
	result+=l;
      } // if month reports
    } // if month matches
    if ((flags&AQM_REPORT_FLAGS_SHOW_MONTHS) ||
	(flags&AQM_REPORT_FLAGS_SHOW_DAYS)) {
      result+="</table><br>";
    }
  } // months

  if (flags&AQM_REPORT_FLAGS_SHOW_YEAR) {
    result+="<a name=konto";
    result+=HBCI::String::num2string(accountidx);
    result+="year";
    result+="></a>";
    result+="<h2> Jahresbilanz f&uuml;r ";
    result+=HBCI::String::num2string(year);
    result+="</h2>";
    result+="<table WIDTH=600 border=1>";
    result+="<tr>";
    result+="<th>Einnahmen</th>";
    result+="<th>Ausgaben</th>";
    result+="<th>Bilanz</th>";
    result+="</tr>";

    l="<tr>";
    l+="<td align=right>";
    val=HBCI::Value(vyearplus, acc.ref().currency());
    tmps=val.toReadableString();
    l+=tmps;
    l+="</td>";
    l+="<td align=right>";
    val=HBCI::Value(vyearminus, acc.ref().currency());
    tmps=val.toReadableString();
    l+=tmps;
    l+="</td>";
    l+="<td align=right>";
    val=HBCI::Value(vyearplus-vyearminus, acc.ref().currency());
    tmps=val.toReadableString();
    if (val.getValue()<0) {
      l+="<font color=red>";
      l+=tmps;
      l+="</font>";
    }
    else
      l+=tmps;
    l+="</td>";
    l+="</tr>";
    result+=l;
    result+="</table>";
  } // if year reports

  return result;
}


string report_txt(HBCI::Pointer<HBCI::Account> acc,
		  unsigned int flags,
		  int year,
		  int month) {
  list<HBCI::Transaction>::const_iterator iter;
  string result;
  HBCI::Date tmpdate;
  double vmonthplus, vmonthminus;
  double vyearplus, vyearminus;
  string tmps;
  TransactionMatcher tm;
  HBCI::Value val;
  string l;
  double vals[31*12][2];
  int i, j;
  HBCI::Date fromdate;
  HBCI::Date todate;
  int idx;
  int count;

  if (month) {
    fromdate=HBCI::Date(1,month,year);
    todate=HBCI::Date(31,month,year);
  }
  else {
    fromdate=HBCI::Date(1,1,year);
    todate=HBCI::Date(31,12,year);
  }
  tm=TransactionMatcher(0,
			"*",
			"*",
			fromdate,
			todate,
			flags & 0xffff);
  // clear values
  for (i=0; i<31*12; i++) {
    vals[i][0]=0.0;
    vals[i][1]=0.0;
  } // for

  // sample data
  count=0;
  for (iter=acc.ref().transactions().begin();
       iter!=acc.ref().transactions().end(); iter++) {
    // check for match
    if (tm.match(*iter)) {
      count++;
      tmpdate=(*iter).valutaDate();
      if (!tmpdate.isValid())
	tmpdate=(*iter).date();
      if (tmpdate.isValid()) {
	idx=((tmpdate.month()-1)*31)+tmpdate.day()-1;

	if ((*iter).value().getValue()<0) {
	  vals[idx][1]-=((*iter).value().getValue());
	}
	else {
	  vals[idx][0]+=((*iter).value().getValue());
	}
      }
      else
	fprintf(stderr,"Invalid date (%d/%d/%d).\n",
		tmpdate.day(), tmpdate.month(), tmpdate.year());
    } // if match
  } // for

  if (count==0) {
    result="--- no data ---\n";
    return result;
  }

  // show data
  vyearplus=0.0;
  vyearminus=0.0;

  if ((flags&AQM_REPORT_FLAGS_SHOW_MONTHS) &&
      !(flags&AQM_REPORT_FLAGS_SHOW_DAYS)) {
    result+="      Monat       Einnahmen       Ausgaben      Bilanz\n";
    result+="  --------------------------------------------------------\n";
  }

  for (i=0; i<12; i++) {
    if (month==0 || month==i+1) {
      vmonthplus=0.0;
      vmonthminus=0.0;
      if ((flags&AQM_REPORT_FLAGS_SHOW_MONTHS) &&
	  (flags&AQM_REPORT_FLAGS_SHOW_DAYS)) {
	result+="  Monatsbilanz fr ";
	result+=monthNames[i];
	result+=" ";
	result+=HBCI::String::num2string(year);
	result+="\n";
      } // if month reports wanted
      if ((!(flags&AQM_REPORT_FLAGS_SHOW_MONTHS) ||
	   (flags&AQM_REPORT_FLAGS_SHOW_DAYS)) &&
	  (flags&AQM_REPORT_FLAGS_SHOW_MONTHS)) {
	result+="      Datum       Einnahmen       Ausgaben      Bilanz\n";
	result+="  --------------------------------------------------------\n";
      }
      for (j=0; j<31; j++) {
	idx=i*31+j;
	vmonthplus+=vals[idx][0];
	vmonthminus+=vals[idx][1];
	vyearplus+=vals[idx][0];
	vyearminus+=vals[idx][1];

	if ((vals[idx][0]!=0.0 ||
	     vals[idx][1]!=0.0 ||
	     (flags&AQM_REPORT_FLAGS_SHOW_NULL)) &&
	    (flags&AQM_REPORT_FLAGS_SHOW_DAYS)) {
	  l="   ";
	  l+=HBCI::String::num2string(j+1);
	  l+=".";
	  l+=HBCI::String::num2string(i+1);
	  l+=".";
	  l+=HBCI::String::num2string(year);
	  l=string(13-l.length(),' ')+l;
	  l+=" ";
	  val=HBCI::Value(vals[idx][0], acc.ref().currency());
	  tmps=val.toReadableString();
	  tmps=string(14-tmps.length(),' ')+tmps;
	  l+=tmps;
	  l+=" ";
	  val=HBCI::Value(vals[idx][1], acc.ref().currency());
	  tmps=val.toReadableString();
	  tmps=string(14-tmps.length(),' ')+tmps;
	  l+=tmps;
	  l+=" ";
	  val=HBCI::Value(vals[idx][0]-vals[idx][1], acc.ref().currency());
	  tmps=val.toReadableString();
	  tmps=string(14-tmps.length(),' ')+tmps;
	  l+=tmps;
	  l+=" ";
	  l+="\n";
	  result+=l;
	} // if moves
      } // days
      if (flags&AQM_REPORT_FLAGS_SHOW_MONTHS) {
	if (flags&AQM_REPORT_FLAGS_SHOW_DAYS) {
	  result+="  --------------------------------------------------------\n";
	  l="  Gesamt";
	}
	else {
	  l="  ";
	  l+=monthNames[i];
	}
	l+=string(14-l.length(),' ');
	val=HBCI::Value(vmonthplus, acc.ref().currency());
	tmps=val.toReadableString();
	tmps=string(14-tmps.length(),' ')+tmps;
	l+=tmps;
	l+=" ";
	val=HBCI::Value(vmonthminus, acc.ref().currency());
	tmps=val.toReadableString();
	tmps=string(14-tmps.length(),' ')+tmps;
	l+=tmps;
	l+=" ";
	val=HBCI::Value(vmonthplus-vmonthminus, acc.ref().currency());
	tmps=val.toReadableString();
	tmps=string(14-tmps.length(),' ')+tmps;
	l+=tmps;
	l+=" ";
	l+="\n";
	if (!(flags&AQM_REPORT_FLAGS_SHOW_MONTHS) ||
	    (flags&AQM_REPORT_FLAGS_SHOW_DAYS))
	  l+="\n";
	result+=l;
      } // if month reports
    } // if month matches
  } // months

  if (flags&AQM_REPORT_FLAGS_SHOW_YEAR) {
    if (!(flags&AQM_REPORT_FLAGS_SHOW_MONTHS) ||
	(flags&AQM_REPORT_FLAGS_SHOW_DAYS)) {
      if (!(flags&AQM_REPORT_FLAGS_SHOW_MONTHS))
	result+="\n";
      result+=" Jahresbilanz fr ";
      result+=HBCI::String::num2string(year);
      result+="\n";
      result+="      Jahr        Einnahmen       Ausgaben      Bilanz\n";
      result+=" ---------------------------------------------------------\n";
      l=HBCI::String::num2string(year)+"    ";
      l=string(14-l.length(),' ')+l;
    }
    else {
      result+=" ---------------------------------------------------------\n";
      l="  Gesamt";
      l+=string(14-l.length(),' ');
    }
    val=HBCI::Value(vyearplus, acc.ref().currency());
    tmps=val.toReadableString();
    tmps=string(14-tmps.length(),' ')+tmps;
    l+=tmps;
    l+=" ";
    val=HBCI::Value(vyearminus, acc.ref().currency());
    tmps=val.toReadableString();
    tmps=string(14-tmps.length(),' ')+tmps;
    l+=tmps;
    l+=" ";
    val=HBCI::Value(vyearplus-vyearminus, acc.ref().currency());
    tmps=val.toReadableString();
    tmps=string(14-tmps.length(),' ')+tmps;
    l+=tmps;
    l+=" ";
    l+="\n\n";
    result+=l;
  } // if month reports

  return result;
}


string report_csv(HBCI::Pointer<HBCI::Account> acc,
		  unsigned int flags,
		  int year,
		  int month) {
  list<HBCI::Transaction>::const_iterator iter;
  string result;
  HBCI::Date tmpdate;
  string tmps;
  TransactionMatcher tm;
  HBCI::Value val;
  string l;
  double vals[31*12][2];
  int i, j;
  HBCI::Date fromdate;
  HBCI::Date todate;
  int idx;
  int count;
  double vmonthplus, vmonthminus;
  double vyearplus, vyearminus;
  string curr;

  if (month) {
    fromdate=HBCI::Date(1,month,year);
    todate=HBCI::Date(31,month,year);
  }
  else {
    fromdate=HBCI::Date(1,1,year);
    todate=HBCI::Date(31,12,year);
  }
  tm=TransactionMatcher(0,
			"*",
			"*",
			fromdate,
			todate,
			flags & 0xffff);
  // clear values
  for (i=0; i<31*12; i++) {
    vals[i][0]=0.0;
    vals[i][1]=0.0;
  } // for

  // sample data
  count=0;
  for (iter=acc.ref().transactions().begin();
       iter!=acc.ref().transactions().end(); iter++) {
    // check for match
    if (tm.match(*iter)) {
      count++;
      tmpdate=(*iter).valutaDate();
      if (!tmpdate.isValid())
	tmpdate=(*iter).date();
      if (tmpdate.isValid()) {
	idx=((tmpdate.month()-1)*31)+tmpdate.day()-1;

	if ((*iter).value().getValue()<0) {
	  vals[idx][1]-=((*iter).value().getValue());
	}
	else {
	  vals[idx][0]+=((*iter).value().getValue());
	}
      }
      else
	fprintf(stderr,"Invalid date (%d/%d/%d).\n",
		tmpdate.day(), tmpdate.month(), tmpdate.year());
    } // if match
  } // for

  if (count==0) {
    result="";
    return result;
  }

  vyearplus=0.0;
  vyearminus=0.0;

  // create header
  result="\"Datum\" ; \"Einnahmen\" ; \"Ausgaben\" ; \"Balance\"\n";

  if (flags&AQM_REPORT_FLAGS_SHOW_CURRENCY)
    curr=acc.ref().currency();
  else
    curr="";
  // create data entries
  for (i=0; i<12; i++) {
    vmonthplus=0.0;
    vmonthminus=0.0;
    for (j=0; j<31; j++) {
      idx=i*31+j;
      vmonthplus+=vals[idx][0];
      vmonthminus+=vals[idx][1];
      vyearplus+=vals[idx][0];
      vyearminus+=vals[idx][1];
      if ((vals[idx][0]!=0.0 ||
	   vals[idx][1]!=0.0 ||
	   (flags&AQM_REPORT_FLAGS_SHOW_NULL)) &&
	  (flags&AQM_REPORT_FLAGS_SHOW_DAYS)) {
	l="";
	l+=HBCI::String::num2string(j+1);
	l+=".";
	l+=HBCI::String::num2string(i+1);
	l+=".";
	l+=HBCI::String::num2string(year);
	l+=" ; ";
	val=HBCI::Value(vals[idx][0], curr);
	tmps=val.toReadableString();
	l+=tmps;
	l+=" ; ";
	val=HBCI::Value(vals[idx][1], curr);
	tmps=val.toReadableString();
	l+=tmps;
	l+=" ; ";
	val=HBCI::Value(vals[idx][0]-vals[idx][1], curr);
	tmps=val.toReadableString();
	l+=tmps;
	l+="\n";
	result+=l;
      } // if moves
    } // for day

    if (flags&AQM_REPORT_FLAGS_SHOW_MONTHS) {
      l="\"";
      l+=monthNames[i];
      l+="\" ; ";
      val=HBCI::Value(vmonthplus, curr);
      tmps=val.toReadableString();
      l+=tmps;
      l+=" ; ";
      val=HBCI::Value(vmonthminus, curr);
      tmps=val.toReadableString();
      l+=tmps;
      l+=" ; ";
      val=HBCI::Value(vmonthplus-vmonthminus, curr);
      tmps=val.toReadableString();
      l+=tmps;
      l+="\n";
      result+=l;
    } // if month report
  } // for month

  if (flags&AQM_REPORT_FLAGS_SHOW_YEAR) {
    l="\"";
    l+=HBCI::String::num2string(year);;
    l+="\" ; ";
    val=HBCI::Value(vyearplus, curr);
    tmps=val.toReadableString();
    l+=tmps;
    l+=" ; ";
    val=HBCI::Value(vyearminus, curr);
    tmps=val.toReadableString();
    l+=tmps;
    l+=" ; ";
    val=HBCI::Value(vyearplus-vyearminus, curr);
    tmps=val.toReadableString();
    l+=tmps;
    l+="\n";
    result+=l;
  }

  return result;
}


HBCI::Error report(HBCI::Pointer<AQMAPI> hbciif,
		   HBCI::SimpleConfig &opt){
  int country;
  string instid;
  string accnr;
  list<HBCI::Pointer<HBCI::Account> > acclist;
  list<HBCI::Pointer<HBCI::Account> >::const_iterator it;
  HBCI::Error err;
  HBCI::Error err2;
  string result;
  string fname;
  string tmp;
  string format;
  unsigned int flags=0;
  int year;
  int month;
  int accountidx;
  HBCI::DateTime currentTime;

  currentTime=HBCI::DateTime::currentTime();

  country=opt.getIntVariable("country",0,opt.root());
  instid=opt.getVariable("instid","*",opt.root());
  accnr=opt.getVariable("accnr","*",opt.root());
  fname=opt.getVariable("outfile","-",opt.root());
  format=opt.getVariable("outformat","txt",opt.root());
  year=opt.getIntVariable("year",currentTime.year(),opt.root());
  month=opt.getIntVariable("month",0,opt.root());
  tmp=opt.getVariable("rflags","ymd",opt.root());
  if (tmp.find("y")!=string::npos)
    flags|=AQM_REPORT_FLAGS_SHOW_YEAR;
  if (tmp.find("m")!=string::npos)
    flags|=AQM_REPORT_FLAGS_SHOW_MONTHS;
  if (tmp.find("d")!=string::npos)
    flags|=AQM_REPORT_FLAGS_SHOW_DAYS;
  if (tmp.find("n")!=string::npos)
    flags|=AQM_REPORT_FLAGS_SHOW_NULL;
  if (tmp.find("c")!=string::npos)
    flags|=AQM_REPORT_FLAGS_SHOW_CURRENCY;

  flags|=TM_FLAGS_POSITIVE;
  flags|=TM_FLAGS_NEGATIVE;
  if (opt.findVariable("pos",opt.root(),false).isValid())
    flags&=~TM_FLAGS_NEGATIVE;
  if (opt.findVariable("neg",opt.root(),false).isValid())
    flags&=~TM_FLAGS_POSITIVE;

  // get accounts
  acclist=hbciif.ref().getAccounts(country,instid,accnr);
  if (acclist.empty())
    return HBCI::Error("report()",
		       ERROR_LEVEL_NORMAL,
		       0,
		       ERROR_ADVISE_DONTKNOW,
		       "no account found.");

  if (format=="html") {
    result+="<html>";
    result+="<body>";
  }

  // if no data then simply return
  accountidx=0;
  for (it=acclist.begin();
       it!=acclist.end();
       it++) {
    accountidx++;
    //if (!(*it).ref().transactions().empty()) {
    // output
    if (format=="txt") {
      HBCI::Pointer<HBCI::Bank> bank;
      result+="Report fr Konto ";
      result+=(*it).ref().accountId();
      // get institute name
	bank=(*it).ref().bank();
	result+=" bei ";
	result+=bank.ref().name();
	result+=" (BLZ: ";
	result+=bank.ref().bankCode();
	result+=")\n";
	result+=report_txt(*it,
			   flags,
			   year,
			   month);
	result+="\n";
    }
    else if (format=="csv") {
      result+=report_csv(*it,
			 flags,
			 year,
			 month);
      result+="\n";
    }
    else if (format=="html") {
      HBCI::Pointer<HBCI::Bank> bank;

      if (accountidx>1)
	result+="<hr>";
      result+="<a name=konto";
      fprintf(stderr,"Setting anchor %d\n",accountidx);
      result+=HBCI::String::num2string(accountidx);
      result+="></a>";
      result+="<h2>Report f&uuml;r Konto ";
      result+=(*it).ref().accountId();
      // get institute name
      bank=(*it).ref().bank();
      result+=" bei ";
      result+=bank.ref().name();
      result+=" (BLZ: ";
      result+=bank.ref().bankCode();
      result+=")</h2>";
      result+=report_html(*it,
			  flags,
			  year,
			  month,
			  accountidx);
      result+="<br>";
    }
    else
      return HBCI::Error("report()",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "unknown output format "+format);
    //} // if transactions
  } // for
  if (format=="html") {
    result+="</body>";
    result+="</html>";
  }

  if (fname=="-")
    fprintf(stdout,"%s",result.c_str());
  else {
    FILE *of;

    of=fopen(fname.c_str(),"w");
    if (of==0) {
      return HBCI::Error("report()",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "could not create file "+fname);
    }
    fprintf(of,"%s",result.c_str());
    if (fclose(of)) {
      return HBCI::Error("report()",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "could not close file "+fname);
    }
  }

  return HBCI::Error();
}
