# 
# old-file.sh: compare file with pristine tree
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

command_line="$*"

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "compare file with cached pristine revision\\n"
                printf "usage: old-file [options] file [[archive/]revision]\\n"
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
                printf " -R --root root                specify the local archive root\\n"
                printf " -A --archive archive          specify the archive name\\n"
		printf "  --cache DIR                  cache directory for locally cached\\n"
		printf "\\n"
		printf " --debug                       debugging output\\n"
		printf "\\n"
		printf "Write the contents of the version of FILE found in a cached pristine\\n"
		printf "copy of REVISION.\\n"
		printf "\\n"
		printf "(See \"larch add-pristine\".)\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=
cache_dir=
html=

debug_opt=

while test $# -ne 0 ; do

  case "$1" in 

    --debug)	shift
    		larch heading "old-file: debugging output enabled\\n"
    		set -x
		debug_opt=--debug
		;;

    -R|--root)          shift
                        if test $# -eq 0 ; then
                          printf "old-file: -R and --root require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 2
                        fi
                        archroot="$1"
                        shift
                        ;;

    -A|--archive)       shift
                        if test $# -eq 0 ; then
                          printf "old-file: -A and --archive require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 2
                        fi
                        archive="$1"
                        shift
                        ;;

    --cache)            shift
                        if test $# -eq 0 ; then
                          printf "old-file: --cache requires an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 2
                        fi
                        cache_dir="$1"
                        shift
                        ;;

    --)			shift
    			break
			;;

    -*)                 printf "old-file: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 2
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -lt 1 -o  $# -gt 2 ; then
  printf "usage: old-file [options] file [[archive/]revision]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 2
fi

file="$1"
shift

if test $# -ne 0 ; then
  rvnspec="$1"
  shift
else
  rvnspec=
fi

################################################################
# Sanity Check and Process Defaults
# 


dir="`dirname \"$file\"`"

cd "$dir"
dir="`pwd`"
wdroot="`larch tree-root`"

file_base="`basename \"$file\"`"
rel_path=".${dir#$wdroot}/$file_base"

cd "$wdroot"

if test -z "$rvnspec" ; then
  rvnspec="`larch tree-version`"
fi

larch valid-package-name -e old-file -t "$rvnspec"

archive="`larch parse-package-name -R \"$archroot\" -A \"$archive\" --arch \"$rvnspec\"`"
category="`larch parse-package-name -R \"$archroot\" -A \"$archive\" --basename \"$rvnspec\"`"
branch="`larch parse-package-name -R \"$archroot\" -A \"$archive\" --package \"$rvnspec\"`"

if larch valid-package-name --vsn -t "$rvnspec" ; then
  version="`larch parse-package-name --package-version \"$rvnspec\"`"
else
  version="`larch logs -r \"$branch\" | head -1`"
  if test -z "$version" ; then
    printf "old-file: no logs for that branch\\n" 1>&2
    printf "  branch: %s\\n" "$branch" 1>&2
    printf "\\n"
    exit 2
  fi
  version="`larch parse-package-name --package-version \"$version\"`"
fi

if larch valid-package-name --patch-level -t "$rvnspec" ; then
  revision="`larch parse-package-name --non-arch \"$rvnspec\"`"
else
  lvl="`larch log-ls -r \"$version\" | head -1`"
  if test -z "$lvl" ; then
    printf "old-file: no patch level for that version\\n" 1>&2
    printf "  branch: %s\\n" "$version" 1>&2
    printf "\\n"
    exit 2
  fi
  revision="$version--$lvl"
fi

if test -z "$cache_dir" ; then
  cd "$wdroot/.."
  cache_dir="`pwd`"
  cd "$wdroot"
fi

if larch library-find --silent -A "$archive" "$revision" > /dev/null ; then

  revision_tree="`larch library-find --silent -A \"$archive\" \"$revision\"`"
  revision_index="$revision_tree/,,index"

else
  set +e
  revision_tree="`larch find-in-cache -A \"$archive\" \"$cache_dir\" \"$revision\"`"
  status=$?
  set -e

  if test $status -ne 0 ; then
    printf "old-file: revision not in library or local cache\\n" 1>&2
    printf "  revision: %s\\n" "$revision" 1>&2
    printf "\\n" 1>&2
    printf "See \"larch add-pristine\"\\n" 1>&2
    printf "\\n" 1>&2
    exit 2
  fi

  revision_index="`larch cached-index \"$revision_tree\"`"

fi



################################################################
# Identify the File
# 

tagging_method="`larch tagging-method`"

set +e

cd "$wdroot"

case "$tagging_method" in

  names)	tag="?$rel_path"
    		status=0
  		;;

  implicit)	tag="`file-tag --implicit \"$rel_path\"`"
  		status=$?
		tag="`printf \"%s\\\\n\" \"$tag\" | cut -s -f 2`"
		;;

  explicit)	tag="`file-tag --explicit \"$rel_path\"`"
  		status=$?
		tag="`printf \"%s\\\\n\" \"$tag\" | cut -s -f 2`"
		;;

  *)		printf "old-file: internal error\\n" 1>&2
  		printf "  unrecognized tagging method (%s)\\n" "$tagging_method" 1>&2
		printf "\\n" 1>&2
		exit 2
		;;
esac

if test "$status" -ne 0 ; then
  printf "old-file: unable to compute file tag\\n" 1>&2
  printf "  file: %s\\n" "$wdroot/$rel_path" 1>&2
  printf "\\n" 1>&2
  exit 2
fi

################################################################
# Find the Corresponding File
# 

revision_path="`printf \"%s\\n\" \"$tag\" | join -o 2.1 -1 1 -2 2 - \"$revision_index\"`"


################################################################
# Output Old File
# 

cat "$revision_tree/$revision_path"

# tag: Tom Lord Fri Dec 14 03:01:38 2001 (local-cache/old-file.sh)
#
