# 
# copy-to-patch-log.sh - copy a log file to a patch log
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "*copy a log file to a patch log\\n"
		printf "usage: copy-to-patch-log [options] log-file [archive/]version patch-level [dir]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
                printf " -R --root root                specify the local archive root\\n"
                printf " -A --archive archive          specify the archive name\\n"
                printf "\\n"
		printf "Record LOG-FILE as the log-entry for VERSION at PATH-LEVEL in the\\n"
		printf "project tree containing DIR (or the current directory).\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=

while test $# -ne 0 ; do

  case "$1" in 

    -R|--root)          shift
                        if test $# -eq 0 ; then
                          printf "copy-to-patch-log: -R and --root require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        archroot="$1"
                        shift
                        ;;

    -A|--archive)       shift
                        if test $# -eq 0 ; then
                          printf "copy-to-patch-log: -A and --archive require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        archive="$1"
                        shift
                        ;;

    -*)			printf "copy-to-patch-log: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -lt 3 -o $# -gt 4 ; then
  printf "usage: copy-to-patch-log [options] log-file [archive/]version patch-level [dir]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

logfile="$1"
shift

archive_version="$1"
shift

patchlvl="$1"
shift

if test $# -ne 0 ; then
  dir="$1"
  shift
else
  dir="."
fi

here="`pwd`"

cd "$dir"
dir="`pwd`"

cd "$here"

cd "`dirname \"$logfile\"`"
logfile="`pwd`/`basename \"$logfile\"`"

################################################################
# Sanity Check and Process Defaults
# 

larch valid-package-name -e copy-to-patch-log --vsn -- "$archive_version"
larch valid-patch-level-name -e copy-to-patch-log -- "$patchlvl"

cd "$dir"
wdroot="`larch tree-root`"

archive=`larch parse-package-name -R "$archroot" -A "$archive" --arch $archive_version`
version=`larch parse-package-name -R "$archroot" -A "$archive" --package-version $archive_version`
category=`larch parse-package-name -b $version`
branch=`larch parse-package-name $version`

logdir="$wdroot/{arch}/$category/$branch/$version/$archive/patch-log"

################################################################
# Compute the location for the log file.
# 

mkdir -p "$logdir"
rm -f "$logdir/$patchlvl"
cp "$logfile" "$logdir/$patchlvl"

