# 
# empty-patch.sh: create a null patch set
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

command_line="$*"

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
	        printf "make a null patch set\\n"
		printf "usage: empty-patch [options] destination\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf "Create a patch set that records no changes.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 

while test "$#" -gt 0 ; do

  case "$1" in

    --)		shift
    		break
		;;

    -*)		printf "empty-patch: unrecognized option (%s)\\n" "$1" 1>&2
    		printf "\\n" 1>&2
		printf "Try \"larch empty-patch --help\"\\n" 1>&2
		exit 1
		;;

    *)		break
		;;

  esac


done


################################################################
# Ordinary Arguments
# 

if test $# != 1 ; then
  printf "usage: empty-patch [options] destination\\n" 1>&2
  printf "try --help\\n"
  exit 1
fi

destination="$1"
shift

here="`pwd`"

################################################################
# Sanity Check and Process Defaults
# 

destination_parent="`dirname \"$destination\"`"
destination_base="`basename \"$destination\"`"
cd "$here"
cd "$destination_parent"
destination_parent="`pwd`"
destination="`pwd`/$destination_base"


################################################################
# Create the output directory.  It must not already exist.
# 

bail()
{
  cd "$destination_parent"
  rm -rf "$destination"
  exit 1
}

trap "printf \"empty-patch: interrupted -- cleaning up\\n\" 1>&2 ; bail" INT
mkdir "$destination"

################################################################
# Create a Null Patch Set
# 

cd "$destination" 

touch orig-dirs-index
touch mod-dirs-index
touch orig-files-index
touch mod-files-index
touch original-only-dir-metadata
touch modified-only-dir-metadata
mkdir removed-files-archive
mkdir new-files-archive
mkdir patches


# tag: Tom Lord Sun Dec 16 06:13:53 2001 (patch-sets/empty-patch.sh)
#
