/* log.c: 
 *
 ****************************************************************
 * Copyright (C) 2002 Tom Lord
 * 
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/vu/safe-printfmt.h"
#include "hackerlab/os/unistd.h"
#include "hackerlab/os/fcntl.h"
#include "hackerlab/vu/safe.h"
#include "shell-utils/log.h"



void
log_event (char * file, int mode, char * fmt, ...)
{
  int fd;
  struct flock lock_data;
  va_list ap;

  
  fd = safe_open (file, O_WRONLY | O_APPEND | O_CREAT, mode);

  lock_data.l_type = F_WRLCK;
  lock_data.l_whence = SEEK_SET;
  lock_data.l_start = 0;
  lock_data.l_len = 0;
  safe_fcntl (fd, F_SETLKW, (long)&lock_data);
  
  va_start (ap, fmt);
  safe_printfmt_va_list (fd, fmt, ap);
  va_end (ap);

  safe_close (fd);
}


/* tag: Tom Lord Thu Jan 24 22:19:46 2002 (log.c)
 */
