# Graph for tla
# Copyright (C) 2005 Thomas Gerigk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
# or look under http://www.gnu.org/licenses/licenses.html#GPL

use strict;

package ArchWay::Util::RevisionNodes;

#
# This class is meant as superclass for RevNodes and RenderNodes
#

# no init
sub new {
	my $class = shift;
	
	my $self = {};
	$self->{"nodes"} = {};
	bless $self, $class;
	
	return $self;
}

#split version and revision
sub _zerlege_vers_rev {
	my $self = shift;
	my @z;
	my $p = shift;
	$p =~ /^(.*)--(.+?)$/;
	@z = ($1, $2);
	return @z;
}

# $self->_find_highest_patch_lowest_versionfix
# giben: full version
# returns: list/array of higest patch-X and lowest versionfix-Y
sub _find_highest_patch_lowest_versionfix {
	my $self = shift;
	my $version = shift;
	
	my $rt;
	my $rl;
	my $max_patch_n = undef;
	my $min_vfix_n = undef;
	
	my $nodes = $self->{"nodes"};
	
	foreach my $revision ( keys %{$nodes->{$version}} ) {
		
		($rt, $rl) = split (/-/, $revision);
		
		if (  ( $rt eq "patch"
				|| $rt eq "base" )
			  && ( ( !defined $max_patch_n )
				   || $rl > $max_patch_n ) ) {
			$max_patch_n = $rl;
		}
		
		if ( ( $rt eq "versionfix"
			   || $rt eq "version" )
			 && ( ( !defined $min_vfix_n )
				  || $rl < $min_vfix_n ) ) {
			$min_vfix_n = $rl;
		}
	}
	return ( $max_patch_n, $min_vfix_n);
}	 

# searches (existing) previous rev for given rev
# within given version . Asuming completeness.
# if none exists, returns undef else revision.
sub _find_next_pre_rev {
	my $self = shift;
	my $t1v = shift;
	my $t1r = shift;
	
	my $nodes = $self->{"nodes"};
	my $prevision = undef;
	my $found = 0;
	
	(my $rt, my $rl) = split (/-/,$t1r);
	
	while ($found == 0) {
		$rl--;
		
		if ($rl < 0) {
			if ($rt eq "version") {
				my @ngw = $self->_find_highest_patch_lowest_versionfix( $t1v );
				$rl = $ngw[1];
				$rt = "patch";
			} else {
				# exit with undef
				$found = 1;
			}
		}
		if ($rl == 0) {
			if ($rt eq "versionfix") {
				$rt = "version";
			}
			if ($rt eq "patch") {
				$rt = "base";
			}
		}
		
		my $t2r = $rt . "-" . $rl;
		if ( defined $nodes->{$t1v}->{$t2r} ) {
			$found = 1;
			$prevision = $t2r;
		}
	}
	return $prevision;
}

#
# dump for test purposes
#
sub _dump  {
	my $self = shift;
	
	my $nodes = $self ->{"nodes"};
	foreach my $t1v ( sort keys %{$nodes} ) {
		foreach my $t1r ( sort keys %{$nodes->{$t1v}} ) {
			print "${t1v}--${t1r}\n";
			
			if (defined $nodes->{$t1v}->{$t1r}->{"pre"}) {
				print "	 previous\n";
				print "		" . $nodes->{$t1v}->{$t1r}->{"pre"} . "\n";
			}
			
			foreach my $t2v ( sort keys %{$nodes->{$t1v}->{$t1r}->{"from"}} ) {
				foreach my $t2r ( sort keys %{$nodes->{$t1v}->{$t1r}->{"from"}->{$t2v}} ) {
					print "	  ${t2v}--${t2r}\n";
				}
			}
			print "\n";
		}
	}
}


1;

__END__

