# -*- coding: utf-8 -*-
# generated by wxGlade HG on Thu Apr 22 15:01:49 2010

import wx

# begin wxGlade: dependencies
# end wxGlade

# begin wxGlade: extracode

# end wxGlade

class CertInstallDialog(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CertInstallDialog.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.signedCertLabel = wx.StaticText(self, -1, "Paste your signed certificate here")
        self.signedCertText = wx.TextCtrl(self, -1, "", style=wx.TE_MULTILINE|wx.TE_RICH)
        self.pasteButton = wx.Button(self, -1, "Paste")
        self.clearButton = wx.Button(self, -1, "Clear")
        self.panel_1 = wx.Panel(self, -1)
        self.installCertificateButton = wx.Button(self, -1, "Install")
        self.closeButton_copy = wx.Button(self, -1, "Close")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self.onPaste, self.pasteButton)
        self.Bind(wx.EVT_BUTTON, self.onClear, self.clearButton)
        self.Bind(wx.EVT_BUTTON, self.onInstallCert, self.installCertificateButton)
        self.Bind(wx.EVT_BUTTON, self.onClose, self.closeButton_copy)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: CertInstallDialog.__set_properties
        self.SetTitle("Install signed certificate")
        self.SetSize((616, 435))
        self.signedCertText.SetFont(wx.Font(10, wx.SCRIPT, wx.NORMAL, wx.NORMAL, 0, "Courier"))
        self.signedCertText.SetFocus()
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: CertInstallDialog.__do_layout
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        sizer_8 = wx.BoxSizer(wx.HORIZONTAL)
        buttonRowSizer_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_9 = wx.BoxSizer(wx.HORIZONTAL)
        mainSizer.Add(self.signedCertLabel, 0, wx.LEFT|wx.RIGHT|wx.TOP, 4)
        mainSizer.Add(self.signedCertText, 4, wx.ALL|wx.EXPAND, 4)
        sizer_9.Add(self.pasteButton, 0, 0, 0)
        sizer_9.Add(self.clearButton, 0, 0, 0)
        sizer_8.Add(sizer_9, 0, wx.LEFT|wx.TOP|wx.BOTTOM, 4)
        sizer_8.Add(self.panel_1, 1, wx.EXPAND, 0)
        buttonRowSizer_copy.Add(self.installCertificateButton, 0, 0, 0)
        buttonRowSizer_copy.Add(self.closeButton_copy, 0, 0, 0)
        sizer_8.Add(buttonRowSizer_copy, 0, wx.RIGHT|wx.TOP|wx.BOTTOM, 4)
        mainSizer.Add(sizer_8, 0, wx.EXPAND, 0)
        self.SetSizer(mainSizer)
        self.Layout()
        self.Centre()
        # end wxGlade
        
        self.__initDialog()
        
    def __initDialog(self):
        """
        Initialise dialog
        """
        self.__certRequest = None

    def onInstallCert(self, event): # wxGlade: CertInstallDialog.<event_handler>
        """
        Install certificate
        """
        if self.signedCertText.GetValue()!="":
            if self.__certRequest!=None:
                self.__certRequest.updateCertificate(self.signedCertText.GetValue())
                self.__certRequest.installCertAndKey()
                wx.MessageBox("Certificate and private key installed.")
                result = wx.MessageBox("Remove certificate request directory?\n(user certificate and private key will not be removed.)", "Certificate request", wx.YES_NO)
                if result == wx.YES:
                    self.__certRequest.removeCurrentRequestDir()
                    wx.MessageBox("Current request directory removed.")
                self.Close()
        else:
            wx.MessageBox("Nothing was entered in the text field.", "Install Certificate")
        

    def onClose(self, event): # wxGlade: CertInstallDialog.<event_handler>
        """
        Close Dialog
        """
        self.Close()

    def onPaste(self, event): # wxGlade: CertInstallDialog.<event_handler>
        """
        Paste signed certificate into text box.
        """
        self.signedCertText.Clear()
        self.signedCertText.Paste()
        

    def onClear(self, event): # wxGlade: CertInstallDialog.<event_handler>
        """
        Clear text box.
        """
        self.signedCertText.Clear()
        
    def setCertRequest(self, certRequest):
        """
        Assign CertRequest instance.
        """
        self.__certRequest = certRequest
        
    def getCertRequest(self):
        """
        Return CertRequest instance.
        """
        return self.__certRequest
        
    certRequest = property(getCertRequest, setCertRequest)

# end of class CertInstallDialog


