# -*- coding: iso-8859-15 -*-
# generated by wxGlade HG on Mon Jul  6 19:39:07 2009

"""
Module implementing the default services dialog.
"""

import wx

# begin wxGlade: dependencies
# end wxGlade

# begin wxGlade: extracode

# end wxGlade

import arc

class DefaultServicesDialog(wx.Dialog, object):
    """
    Class implementing the service dialog box.
    """
    def __init__(self, *args, **kwds):
        # begin wxGlade: DefaultServicesDialog.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE|wx.RESIZE_BORDER|wx.THICK_FRAME
        wx.Dialog.__init__(self, *args, **kwds)
        self.selectedServicesLabel = wx.StaticText(self, -1, "Selected services")
        self.defaultServicesList = wx.ListBox(self, -1, choices=[])
        self.addServiceButton = wx.Button(self, -1, "Add...")
        self.modifyServiceButton = wx.Button(self, -1, "Modify...")
        self.removeServiceButton = wx.Button(self, -1, "Remove")
        self.moveToRejectedButton = wx.Button(self, -1, ">>")
        self.moveToSelectedButton = wx.Button(self, -1, "<<")
        self.clearServicesButton = wx.Button(self, -1, "Clear")
        self.rejectedServicesLabel = wx.StaticText(self, -1, "Rejected services")
        self.rejectedServicesList = wx.ListBox(self, -1, choices=[])
        self.okButton = wx.Button(self, -1, "OK")
        self.cancelButton = wx.Button(self, -1, "Cancel")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_LISTBOX, self.onSelectedList, self.defaultServicesList)
        self.Bind(wx.EVT_BUTTON, self.onAddService, self.addServiceButton)
        self.Bind(wx.EVT_BUTTON, self.onModifyService, self.modifyServiceButton)
        self.Bind(wx.EVT_BUTTON, self.onRemoveService, self.removeServiceButton)
        self.Bind(wx.EVT_BUTTON, self.onMoveToRejected, self.moveToRejectedButton)
        self.Bind(wx.EVT_BUTTON, self.onMoveToSelected, self.moveToSelectedButton)
        self.Bind(wx.EVT_BUTTON, self.onClearServices, self.clearServicesButton)
        self.Bind(wx.EVT_LISTBOX, self.onRejectedList, self.rejectedServicesList)
        self.Bind(wx.EVT_BUTTON, self.onOK, self.okButton)
        self.Bind(wx.EVT_BUTTON, self.onCancel, self.cancelButton)
        # end wxGlade
        
        self.__initDialog()

    def __set_properties(self):
        # begin wxGlade: DefaultServicesDialog.__set_properties
        self.SetTitle("Default services")
        self.SetSize((647, 315))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: DefaultServicesDialog.__do_layout
        sizer_28 = wx.BoxSizer(wx.VERTICAL)
        sizer_31 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_29 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_9 = wx.BoxSizer(wx.VERTICAL)
        sizer_30 = wx.BoxSizer(wx.VERTICAL)
        sizer_2 = wx.BoxSizer(wx.VERTICAL)
        sizer_2.Add(self.selectedServicesLabel, 0, wx.LEFT|wx.TOP|wx.ADJUST_MINSIZE, 4)
        sizer_2.Add(self.defaultServicesList, 1, wx.ALL|wx.EXPAND, 4)
        sizer_29.Add(sizer_2, 1, wx.EXPAND, 0)
        sizer_30.Add(self.addServiceButton, 0, 0, 0)
        sizer_30.Add(self.modifyServiceButton, 0, 0, 0)
        sizer_30.Add(self.removeServiceButton, 0, 0, 0)
        sizer_30.Add(self.moveToRejectedButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_30.Add(self.moveToSelectedButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_30.Add(self.clearServicesButton, 0, 0, 0)
        sizer_29.Add(sizer_30, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_9.Add(self.rejectedServicesLabel, 0, wx.LEFT|wx.TOP|wx.ADJUST_MINSIZE, 4)
        sizer_9.Add(self.rejectedServicesList, 1, wx.ALL|wx.EXPAND|wx.ADJUST_MINSIZE, 4)
        sizer_29.Add(sizer_9, 1, wx.EXPAND, 0)
        sizer_28.Add(sizer_29, 1, wx.EXPAND, 0)
        sizer_31.Add(self.okButton, 0, 0, 0)
        sizer_31.Add(self.cancelButton, 0, 0, 0)
        sizer_28.Add(sizer_31, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL, 4)
        self.SetSizer(sizer_28)
        self.Layout()
        self.Centre()
        # end wxGlade
        
    def __initDialog(self):
        """
        Initialise dialog variables.
        """
        self.__arcGuiConfig = None
        self.__serviceList = []
        self.__selectedListActive = False
        self.__rejectedListActive = False
        
    def __updateListBox(self):
        """
        Update contents of list boxes.
        """
        if self.__arcGuiConfig!=None:
            self.defaultServicesList.Clear()
            for serviceName in self.__serviceList:
                self.defaultServicesList.Append(str(serviceName))               
            self.rejectedServicesList.Clear()
            for serviceName in self.__rejectedList:
                self.rejectedServicesList.Append(str(serviceName)) 
            
    def setArcGuiConfig(self, arcGuiConfig):
        """
        Assign arcgui config instance.
        """
        self.__arcGuiConfig = arcGuiConfig
        self.__serviceList = list(self.__arcGuiConfig.defaultServices)
        self.__rejectedList = list(self.__arcGuiConfig.rejectedServices)
        self.__updateListBox()
        
    def getArcGuiConfig(self):
        """
        Return arcgui config instance.
        """
        return self.__arcGuiConfig

    def onAddService(self, event): # wxGlade: DefaultServicesDialog.<event_handler>
        """
        Add a service to the selected services.
        """
        serviceUrl = wx.GetTextFromUser("Add new service", "Default services", "", centre = True)
        if serviceUrl!="":
            self.__serviceList.append(str(serviceUrl))
            self.__updateListBox()
        else:
            wx.MessageBox("Not a valid URL", "Default services")

    def onRemoveService(self, event): # wxGlade: DefaultServicesDialog.<event_handler>
        """
        Remove a service from selected or rejected lists.
        """
        if self.__selectedListActive:
            if self.defaultServicesList.GetSelection()>=0:
                del self.__serviceList[self.defaultServicesList.GetSelection()]
                self.defaultServicesList.Delete(self.defaultServicesList.GetSelection())
                self.__updateListBox()
            else:
                wx.MessageBox("Please select a service in the list.")
        else:
            if self.rejectedServicesList.GetSelection()>=0:
                del self.__rejectedList[self.rejectedServicesList.GetSelection()]
                self.rejectedServicesList.Delete(self.rejectedServicesList.GetSelection())
                self.__updateListBox()
            else:
                wx.MessageBox("Please select a service in the list.")

    def onClearServices(self, event): # wxGlade: DefaultServicesDialog.<event_handler>
        """
        Clear all services.
        """
        self.defaultServicesList.Clear()
        self.rejectedServicesList.Clear()
        self.__serviceList = []
        self.__updateListBox()

    def onModifyService(self, event): # wxGlade: DefaultServicesDialog.<event_handler>
        """
        Modify selected or rejected service.
        """
        if self.__selectedListActive:
            selectedItem = self.defaultServicesList.GetSelection()
            serviceUrl = self.defaultServicesList.GetString(selectedItem)
            serviceUrl = wx.GetTextFromUser("Modify service", "Default services", serviceUrl, centre = True)
            if serviceUrl!="":
                self.defaultServicesList.SetString(selectedItem, str(serviceUrl))
                self.__serviceList[selectedItem] = str(serviceUrl)
        else:
            selectedItem = self.rejectedServicesList.GetSelection()
            serviceUrl = self.rejectedServicesList.GetString(selectedItem)
            serviceUrl = wx.GetTextFromUser("Modify rejected service", "Rejected services", serviceUrl, centre = True)
            if serviceUrl!="":
                self.rejectedServicesList.SetString(selectedItem, serviceUrl)
                self.__serviceList[selectedItem] = serviceUrl
                
    def getServiceList(self):
        """
        Return service list.
        """
        return self.defaultServicesList.GetStrings()
                
    def onOK(self, event): # wxGlade: DefaultServicesDialog.<event_handler>
        """
        Assign updates lists of services to the arcgui config instance and
        close the dialog.
        """
        self.__arcGuiConfig.defaultServices = self.__serviceList
        self.__arcGuiConfig.rejectedServices = self.__rejectedList
        self.__arcGuiConfig.update()
        self.Close()

    def onCancel(self, event): # wxGlade: DefaultServicesDialog.<event_handler>
        """
        Close dialog without saving any changes.
        """
        self.Close()
        
    def onMoveToRejected(self, event): # wxGlade: DefaultServicesDialog.<event_handler>
        """
        Move selected service to rejected list.
        """
        if self.__selectedListActive:
            if self.defaultServicesList.GetSelection()>=0:
                serviceToMove = self.__serviceList[self.defaultServicesList.GetSelection()]
                del self.__serviceList[self.defaultServicesList.GetSelection()]
                self.defaultServicesList.Delete(self.defaultServicesList.GetSelection())
                self.__rejectedList.append(serviceToMove)
                self.__updateListBox()
            else:
                wx.MessageBox("Please select a service in the list.")

    def onMoveToSelected(self, event): # wxGlade: DefaultServicesDialog.<event_handler>
        """
        Move rejected service to selected list.
        """
        if self.__rejectedListActive:
            if self.rejectedServicesList.GetSelection()>=0:
                serviceToMove = self.__rejectedList[self.rejectedServicesList.GetSelection()]
                del self.__rejectedList[self.rejectedServicesList.GetSelection()]
                self.rejectedServicesList.Delete(self.rejectedServicesList.GetSelection())
                self.__serviceList.append(serviceToMove)
                self.__updateListBox()
            else:
                wx.MessageBox("Please select a service in the list.")
        
    def onSelectedList(self, event): # wxGlade: DefaultServicesDialog.<event_handler>
        """
        Update the current list box selection.
        """
        self.__selectedListActive = True
        self.__rejectedListActive = False

    def onRejectedList(self, event): # wxGlade: DefaultServicesDialog.<event_handler>
        """
        Update the current list box selection.
        """
        self.__selectedListActive = False
        self.__rejectedListActive = True
        
    arcGuiConfig = property(getArcGuiConfig, setArcGuiConfig)



# end of class DefaultServicesDialog


