/*
 * ARCload (c) 2005 Stanislaw Skowronek
 */

#ifndef LIST_H
#define LIST_H

#define LIST_HEAD(t)			\
	t *prev, *next;


#define LIST_STRUCT(n)			\
	struct n {			\
		LIST_HEAD(struct n)


#define LIST_ADD(l, e)			\
	do {				\
		e->next = l;		\
		e->prev = l->prev;	\
		l->prev->next = e;	\
		l->prev = e;		\
	} while(0)


#define LIST_FOR(i, l)			\
	for(i = l->next; i != l; i = i->next)


#define LIST_OF(t, l)			\
	static t _##l##_head;		\
	t *l = &_##l##_head;


#define LIST_INIT(l)			\
	do {				\
		l->next	= l;		\
		l->prev	= l;		\
	} while(0)


#define RAW_LIST_OF(t, l)		\
	t *l;


#define RAW_LIST_INIT(s, l)				\
	do {						\
		(s).l = calloc(sizeof(*((s).l)), 1);	\
		((s).l)->next = (s).l; 			\
		((s).l)->prev = (s).l; 			\
	} while(0)


#define LIST_FIND_BY_FIELD(n, lt, ft, fn)		\
	lt *n(lt *list, ft value)			\
	{						\
		lt *el;					\
		LIST_FOR(el, list)			\
			if(el->fn == value)		\
				return el;		\
		return NULL;				\
	}


#endif /* LIST_H */
