// -*- c++ -*-
//  Generated by gtkmmproc from ./../fontselection.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_FONTSELECTION_H
#define _GTKMM_FONTSELECTION_H

/* $Id: fontselection.h,v 1.2 2003/06/17 16:37:40 pbd Exp $ */

/* fontselection.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/window.h>
#include <gtk--/notebook.h>
#include <gtk--/radiobutton.h>
#include <gtk--/clist.h>
#include <gtk--/entry.h>
#include <gtk--/box.h>
#include <gtk/gtkfontsel.h>

namespace Gtk {
class FontSelection;
class FontSelection_Class;
}
namespace Gtk { Gtk::FontSelection *wrap (GtkFontSelection *o); }
namespace Gtk {
class FontSelectionDialog;
class FontSelectionDialog_Class;
}
namespace Gtk { Gtk::FontSelectionDialog *wrap (GtkFontSelectionDialog *o); }
namespace Gtk
{
//: A widget for selecting fonts.
//- The {\class Gtk::FontSelection} widget lists the available fonts, styles and sizes,
//- allowing the user to select a font. It is used in the
//- {\class Gtk::FontSelectionDialog} widget to provide a dialog box for selecting
//- fonts.
//-
//- To set the font which is initially selected, use {set_font_name()}.
//-
//- To get the selected font use {get_font()} or {get_font_name()}.
//-
//- To change the text which is shown in the preview area, use {set_preview_text()}.
//-
//- Filters can be used to limit the fonts shown. There are 2 filters in the
//- {\class Gtk::FontSelection} - a base filter and a user filter. The base filter can
//- not be changed by the user, so this can be used when the user must choose from the
//- restricted set of fonts (e.g. for a terminal-type application you may want to
//- force the user to select a fixed-width font). The user filter can be changed or
//- reset by the user, by using the 'Reset Filter' button or changing the options on
//- the 'Filter' page of the widget.
class FontSelection : public Notebook {

public:
  typedef FontSelection          CppObjectType;
  typedef FontSelection_Class    CppClassType;
  typedef GtkFontSelection           BaseObjectType;
  typedef GtkFontSelectionClass      BaseClassType;

private:
  friend class FontSelection_Class;
  static CppClassType font_selection_class;

  FontSelection(const FontSelection&);
  FontSelection& operator=(const FontSelection&); // not implemented

protected:
  void   initialize_class();
  explicit FontSelection(GtkFontSelection *castitem);

public:
  static GtkType get_type();
  GtkFontSelection* gtkobj()             { return (GtkFontSelection*)(gtkobject); }
  const GtkFontSelection* gtkobj() const { return (GtkFontSelection*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~FontSelection();

private:

public:

  FontSelection();



  // gchar* gtk_font_selection_get_font_name(GtkFontSelection *);
  //: Gets the currently-selected font name.
  string   get_font_name       () const;

  //: Gets the currently-selected font.
  //- Returns: The currently-selected font, or NULL if no font is selected.


  Gdk_Font get_font() const;

  //: Sets the currently-selected font.
  //- fontname: A fontname.
  //-
  //- Returns: TRUE if the font was found.


  bool set_font_name(const string& fontname);

  //void  gtk_font_selection_set_filter(GtkFontSelection *,
  //  GtkFontFilterType, GtkFontType, gchar**, gchar**, gchar**, gchar**,
  //  gchar**, gchar**);
  //: Sets one of the two font filters, to limit the fonts shown.
  //- filter_type: Which of the two font filters to set, either
  //- {\enum GTK_FONT_FILTER_BASE} or {\enum GTK_FONT_FILTER_USER}. The user filter
  //- can be changed by the user, but the base filter is permanent.
  //-
  //- font_type: The types of font to be shown. This is a bitwise combination of
  //- {\enum GTK_FONT_BITMAP}, {\enum GTK_FONT_SCALABLE} and
  //- {\enum GTK_FONT_SCALABLE_BITMAP}, or {\enum GTK_FONT_ALL} to show all three
  //- font types.
  //-
  //- foundries: A NULL-terminated array of strings containing foundry names which
  //- will be shown, or NULL to show all foundries.
  //-
  //- weights: A NULL-terminated array of strings containing weight names which
  //- will be shown, or NULL to show all weights.
  //-
  //- slants: A NULL-terminated array of strings containing slant names which will
  //- be shown, or NULL to show all slants.
  //-
  //- setwidths: A NULL-terminated array of strings containing setwidth names which
  //- will be shown, or NULL to show all setwidths.
  //-
  //- spacings: A NULL-terminated array of strings containing spacings which will
  //- be shown, or NULL to show all spacings.
  //-
  //- charsets: A NULL-terminated array of strings containing charset names which
  //- will be shown, or NULL to show all charsets.
  void     set_filter          (GtkFontFilterType filter_type,
				GtkFontType	font_type,
				const SArray	&foundries,
				const SArray	&weights,
				const SArray	&slants,
				const SArray	&setwidths,
				const SArray	&spacings,
				const SArray	&charsets);

  //: Gets the text displayed in the preview area.
  //- Returns: The text displayed in the preview area.


  string get_preview_text() const;

  //: Sets the text displayed in the preview area.
  //- text: The text to display in the preview area.


  void set_preview_text(const string& fontname);

  // Font page
  Gtk::Box* get_font_box() const;

  Gtk::Label* get_font_label() const;


  Gtk::Entry* get_font_entry() const;

  Gtk::Entry* get_font_style_entry() const;

  Gtk::Entry* get_size_entry() const;

  Gtk::Entry* get_preview_entry() const;


  Gtk::CList* get_font_list() const;

  Gtk::CList* get_font_style_list() const;

  Gtk::CList* get_size_list() const;


  Gtk::RadioButton* get_pixels_button() const;

  Gtk::RadioButton* get_points_button() const;

  Gtk::Button* get_filter_button() const;

  Gtk::Label* get_message_label() const;

  // Font info page
  Gtk::Box* get_info_box() const;

  Gtk::CList* get_info_list() const;
  Gtk::Entry* get_requested_font_name() const;

  Gtk::Entry* get_actual_font_name() const;
  // Filter page
  Gtk::Box* get_filter_box() const;

  Gtk::CheckButton* get_type_bitmaps_button() const;

  Gtk::CheckButton* get_type_scalable_button() const;

  Gtk::CheckButton* get_type_scaled_bitmaps_button() const;

  enum PropertyType { WEIGHT, SLANT, SET_WIDTH, SPACING, CHARSET, FOUNDRY };

  CList* get_filter_list(PropertyType p);

public:

protected:
  // impl functions

};

//: A dialog box for selecting fonts.
//- The {\class Gtk::FontSelectionDialog} widget is a dialog box for selecting a font.
//-
//- To set the font which is initially selected, use {set_font_name()}.
//-
//- To get the selected font use {get_font()} or {get_font_name()}.
//-
//- To change the text which is shown in the preview area, use {set_preview_text()}.
//-
//- Filters can be used to limit the fonts shown. There are 2 filters in the
//- {\class Gtk::FontSelectionDialog} - a base filter and a user filter. The base
//- filter can not be changed by the user, so this can be used when the user must
//- choose from the restricted set of fonts (e.g. for a terminal-type application
//- you may want to force the user to select a fixed-width font). The user filter can
//- be changed or reset by the user, by using the 'Reset Filter' button or changing the
//- options on the 'Filter' page of the dialog.
class FontSelectionDialog : public Window
{

public:
  typedef FontSelectionDialog          CppObjectType;
  typedef FontSelectionDialog_Class    CppClassType;
  typedef GtkFontSelectionDialog           BaseObjectType;
  typedef GtkFontSelectionDialogClass      BaseClassType;

private:
  friend class FontSelectionDialog_Class;
  static CppClassType font_selection_dialog_class;

  FontSelectionDialog(const FontSelectionDialog&);
  FontSelectionDialog& operator=(const FontSelectionDialog&); // not implemented

protected:
  void   initialize_class();
  explicit FontSelectionDialog(GtkFontSelectionDialog *castitem);

public:
  static GtkType get_type();
  GtkFontSelectionDialog* gtkobj()             { return (GtkFontSelectionDialog*)(gtkobject); }
  const GtkFontSelectionDialog* gtkobj() const { return (GtkFontSelectionDialog*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~FontSelectionDialog();

private:

public:

  FontSelectionDialog(const nstring &title=(char*)0);


  //: Sets the currently-selected font.
  //- fontname: A fontname.
  //-
  //- Returns: TRUE if the font was found.


  bool set_font_name(const string& fontname);

  // gchar* gtk_font_selection_dialog_get_font_name(GtkFontSelectionDialog *),
  //: Gets the currently-selected font name.
  //- Returns: The currently-selected font name, or NULL if no font is selected.
  nstring   get_font_name   () const;

  //: Gets the currently-selected font.
  //- Returns: The currently-selected font, or NULL if no font is selected.


  Gdk_Font get_font() const;

  //: Gets the text displayed in the preview area.
  //- Returns: The text displayed in the preview area.


  string get_preview_text() const;

  //: Sets the text displayed in the preview area.
  //- text: The text to display in the preview area.


  void set_preview_text(const string& fontname);

  // void gtk_font_selection_dialog_set_filter(GtkFontSelectionDialog *fsd,
  //   GtkFontFilterType, GtkFontType, gchar**, gchar**, gchar**,
  //   gchar**, gchar**, gchar**);
  //: Sets one of the two font filters, to limit the fonts shown.
  //- filter_type: Which of the two font filters to set, either
  //- {\enum GTK_FONT_FILTER_BASE} or {\enum GTK_FONT_FILTER_USER}. The user
  //- filter can be changed by the user, but the base filter is permanent.
  //-
  //- font_type: The types of font to be shown. This is a bitwise combination
  //- of {\enum GTK_FONT_BITMAP}, {\enum GTK_FONT_SCALABLE} and
  //- {\enum GTK_FONT_SCALABLE_BITMAP}, or {\enum GTK_FONT_ALL} to show all
  //- three font types.
  //-
  //- foundries: A NULL-terminated array of strings containing foundry names
  //- which will be shown, or NULL to show all foundries.
  //-
  //- weights: A NULL-terminated array of strings containing weight names which
  //- will be shown, or NULL to show all weights.
  //-
  //- slants: A NULL-terminated array of strings containing slant names which
  //- will be shown, or NULL to show all slants.
  //-
  //- setwidths: A NULL-terminated array of strings containing setwidth names
  //- which will be shown, or NULL to show all setwidths.
  //-
  //- spacings: A NULL-terminated array of strings containing spacings which
  //- will be shown, or NULL to show all spacings.
  //- charsets: A NULL-terminated array of strings containing charset names
  //- which will be shown, or NULL to show all charsets.
  void     set_filter      (GtkFontFilterType filter_type,
			    GtkFontType		font_type,
                            const SArray	&foundries,
                            const SArray	&weights,
                            const SArray	&slants,
                            const SArray	&setwidths,
                            const SArray	&spacings,
                            const SArray	&charsets);

  Gtk::FontSelection* get_font_selection() const;

  Gtk::Button* get_ok_button() const;

  Gtk::Button* get_apply_button() const;

  Gtk::Button* get_cancel_button() const;

public:

protected:
  // impl functions

};


}


#endif
