/*
 * Copyright (c) 2000-2001 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/*  ArgusModeler.h  */
/*  This is a merger of argus.h, interface.h, and constants strewn about the
    argus.c and argus_util.c modules.
*/


#ifndef ArgusModeler_h
#define ArgusModeler_h


#define ARGUS_MARSTATUSTIMER	"300"
#define ARGUS_FARSTATUSTIMER	"60"

#define ARGUS_INITIMEOUT	15
#define ARGUS_IPTIMEOUT		300
#define ARGUS_ARPTIMEOUT	300
#define ARGUS_TCPTIMEOUT	120
#define ARGUS_ICMPTIMEOUT	300
#define ARGUS_IGMPTIMEOUT	300
#define ARGUS_OTHERTIMEOUT	300
#define ARGUS_IPFRAGTIMEOUT	2

#define ARGUS_FRAGTIMEOUT	5

#define ARGUS_MINSNAPLEN	96
#define ARGUS_MINIPHDRLEN	20
#define ARGUS_HASHTABLESIZE	65536

#define ARGUS_REQUEST		0x01
#define ARGUS_REPLY		0x02

#define ARGUS_RTP_PCMU		0
#define ARGUS_RTP_PCMA		8
#define ARGUS_RTP_G722		9
#define ARGUS_RTP_G723		4
#define ARGUS_RTP_G728		15
#define ARGUS_RTP_G729		18
#define ARGUS_RTP_H261		31
#define ARGUS_RTP_H263		34

#define ARGUS_DEBUG		0xFF


/* True if  "l" bytes of "var" were captured */
#define BYTESCAPTURED(var, l) ((u_char *)&(var) <= ArgusThisSnapEnd - (l))

/* True if "var" was captured */
#define STRUCTCAPTURED(var) BYTESCAPTURED(var, sizeof(var))

/* Bail if "l" bytes of "var" were not captured */
#define BYTESCHECK(var, l) if (!BYTESCAPTURED(var, l)) goto trunc

/* Bail if "var" was not captured */
#define STRUCTCHECK(var) BYTESCHECK(var, sizeof(var))

#define LENCHECK(l) { if ((l) > len) goto bad; BYTESCHECK(*cp, l); }


#include <syslog.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>

#if defined(HAVE_SOLARIS) || defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
#include <sys/socket.h>

#if !defined(__OpenBSD__) || (defined(__OpenBSD__) && !defined(_NET_IF_H_))
#include <net/if.h>
#define _NET_IF_H_
#endif
#endif

#include <netinet/in.h>

#if !defined(__OpenBSD__) || (defined(__OpenBSD__) && !defined(_NETINET_IF_SYSTEM_H_))
#include <netinet/in_systm.h>
#define _NETINET_IF_SYSTEM_H_
#endif

#if !defined(__OpenBSD__)
#include <netinet/if_ether.h>
#endif

#include <compat.h>

#ifndef _NETINET_IP_H_
#include <netinet/ip.h>
#define _NETINET_IP_H_
#endif

#ifndef _NETINET_UDP_H_
#include <netinet/udp.h>
#define _NETINET_UDP_H_
#endif

#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>
#include <netinet/igmp.h>
#include <netinet/rtp.h>

#include <ArgusUtil.h>

 
struct ArgusUserDataObject {
   int count, size;
   char *array;
};

struct ArgusUserObject {
   struct ArgusUserDataObject src, dst;
};


struct AHHeader {
   unsigned char  nxt, len;
   unsigned short pad;
   unsigned int   spi, replay, data;
};

struct ArgusHashTableStruct {
   int size;
   struct ArgusHashTableHeader **array;
};

struct ArgusModelerStruct {
   int state;
};

struct ArgusModelerTime {
   unsigned int n, min, max, sum;
   long long sumsqrd;
};

struct ArgusFlowStats {
   unsigned short status, ip_id, options;
   unsigned char ttl, tos;
   struct timeval lasttime;
   unsigned int count, bytes, appbytes;
   struct ArgusModelerTime active, idle;
};

struct ArgusFlowState {
   struct timeval startime, lasttime;
   unsigned int status;
   unsigned short ofragcnt;
   unsigned char rev, dir;
   struct ArgusFlowStats *last, src, dst;
};

struct ArgusFlowStruct {
   struct ArgusQueueHeader qhdr;
   struct ArgusHashTableHeader *htblhdr;
   struct ArgusFlow flow;
   unsigned int ArgusFlowType;
   struct ArgusFlowState state;
   unsigned int ArgusTransactionNum;
   int ArgusTimeout, ArgusVlanId;

   void *MacDSRBuffer;
   void *VlanDSRBuffer;
   void *MplsDSRBuffer;
   void *NetworkDSRBuffer;
   void *ICMPDSRBuffer;
   void *FragDSRBuffer;
   void *TransportDSRBuffer;
   void *SessionDSRBuffer;
   void *UserDSRBuffer;
};

struct ArgusHashTableHeader {
   struct ArgusHashTableHeader *nxt, *prv;
   struct ArgusFlow flow;
   unsigned short hash;
   struct ArgusFlowStruct *flowobj;
};

struct ArgusTCPModelerObject {
   struct timeval lasttime;
   unsigned int status;
   unsigned short state;
   unsigned char flag, pad;
   unsigned short win, winbytes;
   unsigned int seq_base, seq, ack, winnum;
   unsigned int count, bytes, retrans, ackbytes;
};

struct ArgusTCPExtensionBuffer {
   unsigned int status, state, options;
   unsigned int synAckuSecs, ackDatauSecs;
   struct ArgusTCPModelerObject src, dst;
};


struct ArgusFragOffsetStruct {
   struct ArgusFragOffsetStruct *nxt;
   int start, end;
};

struct ArgusFragExtensionBuffer {
   struct ArgusFlow flow;
   struct ArgusFragObject frag;
   unsigned int startbytes, bytes, totbytes;
   struct ArgusFlowStruct *flowstr;
   struct ArgusUserDataObject *user;
   struct ArgusFragOffsetStruct *offsets;
};

extern void ArgusUpdateESPState (struct ArgusFlowStruct *, unsigned char *);
extern void ArgusUpdateFragState (struct ArgusFlowStruct *, unsigned char *);
extern void ArgusUpdateTCPState(struct ArgusFlowStruct *, unsigned char *);
extern void ArgusUpdateUDPState(struct ArgusFlowStruct *, unsigned char *);
extern void ArgusUpdateICMPState(struct ArgusFlowStruct *, unsigned char *);
extern void ArgusUpdateAppState (struct ArgusFlowStruct *, unsigned char *);

extern void ArgusUpdateArpState (struct ArgusFlowStruct *, unsigned char *);
extern void ArgusUpdateFRAGState(struct ArgusFlowStruct *, unsigned char *);

extern int ArgusUpdateParentFlow (struct ArgusFlowStruct *);

void ArgusUpdateMACState (struct ArgusFlowStruct *, unsigned char *);

extern struct ArgusRecord *ArgusGenerateFlowRecord (struct ArgusFlowStruct *, unsigned char);
extern void ArgusVlanFlowRecord (struct ArgusFlowStruct *, struct ArgusRecord *, unsigned char);
extern void ArgusMplsFlowRecord (struct ArgusFlowStruct *, struct ArgusRecord *, unsigned char);
extern void ArgusTimeFlowRecord (struct ArgusFlowStruct *, struct ArgusRecord *, unsigned char);
extern void ArgusMacFlowRecord (struct ArgusFlowStruct *, struct ArgusRecord *, unsigned char);
extern void ArgusESPFlowRecord (struct ArgusFlowStruct *, struct ArgusRecord *, unsigned char);
extern void ArgusUDPFlowRecord (struct ArgusFlowStruct *, struct ArgusRecord *, unsigned char);
extern void ArgusTCPFlowRecord (struct ArgusFlowStruct *, struct ArgusRecord *, unsigned char);
extern void ArgusARPFlowRecord (struct ArgusFlowStruct *, struct ArgusRecord *, unsigned char);
extern void ArgusICMPFlowRecord (struct ArgusFlowStruct *, struct ArgusRecord *, unsigned char);
extern void ArgusUserDataFlowRecord (struct ArgusFlowStruct *, struct ArgusRecord *, unsigned char);

extern void ArgusInitializeTCP (struct ArgusFlowStruct *);
extern int ArgusUpdateTCPStateMachine (struct ArgusFlowStruct *, struct tcphdr *);
extern int ArgusUpdateTCPSequence (struct ArgusFlowStruct *, struct tcphdr *);



#if defined(ArgusModeler)

#if defined(LBL_ALIGN)
#define ARGUS_MAXALIGNBUF  65536
unsigned char ArgusAlignBuffer[ARGUS_MAXALIGNBUF], *ArgusAlignBuf = ArgusAlignBuffer;
#endif

struct ArgusModelerStruct *ArgusModel = NULL;

unsigned int ArgusTransactionNum = 0;
int ArgusModelerPipe[2] = {-1, -1};

struct ArgusHashTableStruct ArgusHashTable;
struct ArgusSocketStruct *ArgusModelerOutputSocket = NULL;
struct ArgusQueueStruct *ArgusFlowQueue = NULL;

struct ArgusFlow  ArgusThisFlowBuffer;
struct ArgusFlow *ArgusThisFlow = &ArgusThisFlowBuffer;

struct ArgusMacStruct  ArgusThisMacBuffer;
struct ArgusMacStruct *ArgusThisMac = &ArgusThisMacBuffer;

int ArgusThisNetworkFlowType = 0;
int ArgusThisAppFlowType = 0;
int ArgusInProtocol = 1;
unsigned short ArgusOptionIndicator = 0;

struct ether_header *ArgusThisEpHdr = NULL;
struct ip *ArgusThisIpHdr = NULL;

unsigned char *ArgusThisUpHdr = NULL;
unsigned char *ArgusThisSnapEnd = NULL;

int ArgusSnapLength = 0;
int ArgusGenerateTime = 0;
int ArgusThisLength = 0;
int ArgusThisBytes = 0;
int ArgusThisDir = 0;
int ArgusIPPacketLenOff = 0;

unsigned short ArgusThisHash = 0;

long long ArgusTotalPacket = 0;
long long ArgusTotalFrags = 0;
long long ArgusTotalIPPkts = 0;
long long ArgusLastIPPkts = 0;

long long ArgusTotalNonIPPkts = 0;
long long ArgusLastNonIPPkts = 0;

long long ArgusTotalNewFlows = 0;
long long ArgusLastNewFlows = 0;
long long ArgusTotalClosedFlows = 0;
long long ArgusLastClosedFlows = 0;

long long ArgusTotalIPFlows = 0;
long long ArgusLastIPFlows = 0;

long long ArgusTotalNonIPFlows = 0;
long long ArgusLastNonIPFlows = 0;

long long ArgusTotalRecords = 0;
long long ArgusLastRecords = 0;

long long ArgusTotalUpdates = 0;
long long ArgusLastUpdates = 0;

int ArgusThisPacketLLCEncaps = 0;
int ArgusThisPacketMPLSEncaps = 0;
unsigned int ArgusThisPacketMPLSLabel = 0;
int ArgusThisPacket8021QEncaps = 0;
int ArgusThisPacketPPPoEEncaps = 0;

struct timeval ArgusGlobalTime = {0, 0};
struct timeval ArgusStartTime = {0, 0};
struct timeval ArgusUpdateInterval = {0,200000};
struct timeval ArgusUpdateTimer = {0, 0};

static int ArgusMajorVersion = VERSION_MAJOR;
static int ArgusMinorVersion = VERSION_MINOR;
static int ArgusSnapLen = ARGUS_MINSNAPLEN;

int ArgusUserDataLen = 0;
int ArgusAflag = 1;
int Argusmflag = 1;

int ArgusResponseStatus = 0;

struct timeval ArgusFarReportInterval = {0,0};

unsigned int ArgusLocalNet = 0;
unsigned int ArgusNetMask = 0;

static int ArgusIPTimeout   = ARGUS_IPTIMEOUT;
static int ArgusTCPTimeout  = ARGUS_TCPTIMEOUT;
static int ArgusICMPTimeout = ARGUS_ICMPTIMEOUT;
static int ArgusIGMPTimeout = ARGUS_IGMPTIMEOUT;
static int ArgusFRAGTimeout = ARGUS_FRAGTIMEOUT;

static unsigned int ArgusID = ARGUS_COOKIE;
static unsigned int ArgusIDType = 0;
static unsigned int ArgusLink = 0;
static unsigned char ArgusInterfaceType = 0;
static unsigned char ArgusInterfaceStatus = 0;
 
struct ArgusModelerStruct *ArgusNewModeler(void);
void ArgusInitModeler(void);
void ArgusDeleteModeler(void);

int ArgusProcessPacket (struct ether_header *, int, struct timeval *);
int ArgusProcessIpPacket (struct ip *, int, struct timeval *);
extern struct ether_header *ArgusProcessEtherHdr (struct ether_header *, int);

unsigned short ArgusDiscoverNetworkProtocol (unsigned char *);
void ArgusParseMPLSLabel (unsigned char *, unsigned int *, unsigned char *, unsigned char *, unsigned char *);

void ArgusSendFlowRecord (struct ArgusFlowStruct *, unsigned char);

struct ArgusFlowStruct *ArgusNewFlow (void);
extern struct ArgusFlowStruct *ArgusNewFragFlow (void);
void ArgusTallyStats (struct ArgusFlowStruct *, unsigned char);
void ArgusTallyTime (struct ArgusFlowStruct *, unsigned char);
unsigned short ArgusParseIPOptions (unsigned char *, int);

int getArgusAflag(void);
void setArgusAflag(int);
int getArgusmflag(void);
void setArgusmflag(int);
int getArgusUserDataLen(void);
void setArgusUserDataLen(int);

int getArgusGenerateTime(void);
void setArgusGenerateTime(int);

int getArgusdflag(void);
void setArgusdflag(int);

void setArgusLink(unsigned int);
void ArgusModelerCleanUp (void);

int ArgusCreateFlow (struct ether_header *, int);
int ArgusCreateArpFlow (struct ether_header *);
int ArgusCreateIPFlow (struct ip *);
int ArgusCreateESPFlow (struct ip *);
int ArgusCreateICMPFlow (struct ip *);
int ArgusCreateFRAGFlow (struct ip *);


struct ArgusFlowStruct *ArgusFindFlow (void);

void ArgusICMPMappedFlowRecord (struct ArgusFlowStruct *, struct ArgusRecord *, unsigned char);
int ArgusUpdateState (struct ArgusFlowStruct *, unsigned char);

void ArgusUpdateFlow (struct ArgusFlowStruct *, unsigned char);

void ArgusModelTransmit (void);

int ArgusUpdateTime (void);
void ArgusTimeOut(struct ArgusFlowStruct *);

struct ArgusHashTableHeader *ArgusFindHashObject(void);

int getArgusMajorVersion(void);
void setArgusMajorVersion(int);

int getArgusMinorVersion(void);
void setArgusMinorVersion(int);

int getArgusSnapLen(void);
void setArgusSnapLen(int);

int getArgusManReportInterval(void);
void setArgusManReportInterval(int);

struct timeval *getArgusFarReportInterval(void);
void setArgusFarReportInterval(char *);

int getArgusResponseStatus(void);
void setArgusResponseStatus(int value);

unsigned int getArgusID(void);
void setArgusID(unsigned int);

unsigned int getArgusIDType(void);
void setArgusIDType(unsigned int);

int getArgusIPTimeout(void);
void setArgusIPTimeout(int);

int getArgusTCPTimeout(void);
void setArgusTCPTimeout(int);

int getArgusICMPTimeout(void);
void setArgusICMPTimeout(int);

int getArgusIGMPTimeout(void);
void setArgusIGMPTimeout(int);

int getArgusFRAGTimeout(void);
void setArgusFRAGTimeout(int);

unsigned int getArgusLocalNet(void);
void setArgusLocalNet(unsigned int);

unsigned int getArgusNetMask(void);
void setArgusNetMask(unsigned int);

unsigned char getArgusInterfaceType(void);
void setArgusInterfaceType(unsigned char);

unsigned char getArgusInterfaceStatus(void);
void setArgusInterfaceStatus(unsigned char);

void ArgusSystemTimeout (void);


#else /* #if defined(ArgusModeler) */

#if defined(LBL_ALIGN)
extern unsigned char *ArgusAlignBuf;
#endif

extern struct ArgusModelerStruct *ArgusModel;

extern unsigned int ArgusTransactionNum;
extern int ArgusModelerPipe[2];

extern struct ArgusHashTableStruct ArgusHashTable;
extern struct ArgusSocketStruct *ArgusModelerOutputSocket;
extern struct ArgusQueueStruct *ArgusFlowQueue;

extern struct ArgusFlow *ArgusThisFlow;

extern int ArgusThisNetworkFlowType;
extern int ArgusThisAppFlowType;
extern int ArgusInProtocol;
extern unsigned short ArgusOptionIndicator;

extern struct ether_header *ArgusThisEpHdr;
extern struct ip *ArgusThisIpHdr;
extern unsigned char *ArgusThisUpHdr;
extern unsigned char *ArgusThisSnapEnd;

extern long long ArgusTotalPacket;
extern long long ArgusTotalFrags;

extern long long ArgusTotalIPPkts;
extern long long ArgusLastIPPkts;

extern long long ArgusTotalNonIPPkts;
extern long long ArgusLastNonIPPkts;

extern long long ArgusTotalNewFlows;
extern long long ArgusLastNewFlows;
extern long long ArgusTotalClosedFlows;
extern long long ArgusLastClosedFlows;

extern long long ArgusTotalIPFlows;
extern long long ArgusLastIPFlows;

extern long long ArgusTotalNonIPFlows;
extern long long ArgusLastNonIPFlows;

extern long long ArgusTotalRecords;
extern long long ArgusLastRecords;

extern long long ArgusTotalUpdates;
extern long long ArgusLastUpdates;

extern unsigned int ArgusLocalNet, ArgusNetMask;
extern int ArgusFarReportInterval;
extern int ArgusResponseStatus;

extern int ArgusAflag;
extern int Argusmflag;

extern int ArgusThisPacketLLCEncaps;
extern int ArgusThisPacketMPLSEncaps;
extern unsigned int ArgusThisPacketMPLSLabel;
extern int ArgusThisPacket8021QEncaps;
extern int ArgusThisPacketPPPoEEncaps;

extern u_char *ArgusSnapEnd;
extern int ArgusSnapLength;

extern int ArgusGenerateTime;
extern int ArgusThisLength;
extern int ArgusThisBytes;
extern int ArgusThisDir;
extern unsigned short ArgusThisHash;
extern int ArgusIPPacketLenOff;

extern struct timeval ArgusGlobalTime;
extern struct timeval ArgusStartTime;
extern struct timeval ArgusUpdateInterval;
extern struct timeval ArgusUpdateTimer;

extern struct ArgusModelerStruct *ArgusNewModeler(void);
extern void ArgusInitModeler(void);
extern void ArgusDeleteModeler(void);

extern int ArgusProcessPacket (struct ether_header *, int, struct timeval *);
extern int ArgusProcessIpPacket (struct ip *, int, struct timeval *);
extern struct ether_header *ArgusProcessEtherHdr (struct ether_header *, int);

extern unsigned short ArgusDiscoverNetworkProtocol (unsigned char *);
extern void ArgusParseMPLSLabel (unsigned char *, unsigned int *, unsigned char *, unsigned char *, unsigned char *);

extern void ArgusSendFlowRecord (struct ArgusFlowStruct *, unsigned char);

extern struct ArgusFlowStruct *ArgusNewFlow (void);
extern struct ArgusFlowStruct *ArgusNewFragFlow (void);
extern void ArgusTallyStats (struct ArgusFlowStruct *, unsigned char);
extern void ArgusTallyTime (struct ArgusFlowStruct *, unsigned char);
extern unsigned short ArgusParseIPOptions (unsigned char *, int);

extern int getArgusAflag(void);
extern void setArgusAflag(int);
extern int getArgusmflag(void);
extern void setArgusmflag(int);
extern int getArgusUserDataLen(void);
extern void setArgusUserDataLen(int);

extern int getArgusGenerateTime(void);
extern void setArgusGenerateTime(int);

extern int getArgusdflag(void);
extern struct timeval *getArgusFarReportInterval(void);

extern void setArgusdflag(int);
extern void setArgusFarReportInterval(char *);

extern void setArgusLink(unsigned int);
extern void ArgusModelerCleanUp (void);

extern int ArgusCreateFlow (struct ether_header *, int);
extern int ArgusCreateArpFlow (struct ether_header *);
extern int ArgusCreateIPFlow (struct ip *);
extern int ArgusCreateESPFlow (struct ip *);
extern int ArgusCreateICMPFlow (struct ip *);
extern int ArgusCreateFRAGFlow (struct ip *);

extern struct ArgusFlowStruct *ArgusFindFlow (void);

extern void ArgusICMPMappedFlowRecord (struct ArgusFlowStruct *, struct ArgusRecord *, unsigned char);
extern int ArgusUpdateState (struct ArgusFlowStruct *, unsigned char);

extern void ArgusUpdateFlow (struct ArgusFlowStruct *, unsigned char);

extern void ArgusModelTransmit (void);

extern int ArgusUpdateTime (void);
extern void ArgusTimeOut(struct ArgusFlowStruct *);

extern int getArgusMajorVersion(void);
extern void setArgusMajorVersion(int);

extern int getArgusMinorVersion(void);
extern void setArgusMinorVersion(int);

extern int getArgusSnapLen(void);
extern void setArgusSnapLen(int);

extern int getArgusManReportInterval(void);
extern void setArgusManReportInterval(int);

extern int getArgusStatusReportInterval(void);
extern void setArgusStatusReportInterval(int);

extern int getArgusResponseStatus(void);
extern void setArgusResponseStatus(int value);

extern unsigned int getArgusID(void);
extern void setArgusID(unsigned int);

extern unsigned int getArgusIDType(void);
extern void setArgusIDType(unsigned int);

extern int getArgusIPTimeout(void);
extern void setArgusIPTimeout(int);

extern int getArgusTCPTimeout(void);
extern void setArgusTCPTimeout(int);

extern int getArgusICMPTimeout(void);
extern void setArgusICMPTimeout(int);

extern int getArgusIGMPTimeout(void);
extern void setArgusIGMPTimeout(int);

extern int getArgusFRAGTimeout(void);
extern void setArgusFRAGTimeout(int);

extern unsigned int getArgusLocalNet(void);
extern void setArgusLocalNet(unsigned int);

extern unsigned int getArgusNetMask(void);
extern void setArgusNetMask(unsigned int);

extern unsigned char getArgusInterfaceType(void);
extern void setArgusInterfaceType(unsigned char);

extern unsigned char getArgusInterfaceStatus(void);
extern void setArgusInterfaceStatus(unsigned char);

extern void ArgusSystemTimeout (void);


#endif /* #if defined(ArgusModeler) else */
#endif /* #ifndef ArgusModeler_h */
