/*
 * Copyright (c) 1987 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)getopt.c	4.13 (Berkeley) 2/23/91";
#endif /* LIBC_SCCS and not lint */

#include <stdio.h>
#include <string.h>

/*
 * get option letter from argument vector
 */
int	tiff_opterr = 1,		/* if error message should be printed */
	tiff_optind = 1,		/* index into parent argv vector */
	tiff_optopt;			/* character checked for validity */
char	*tiff_optarg;		/* argument associated with option */

#define	BADCH	(int)'?'
#define	EMSG	""

int
tiff_getopt(int nargc, char** nargv, char* ostr)
{
	static char *place = EMSG;		/* option letter processing */
	register char *oli;			/* option letter list index */
	char *p;

	if (!*place) {				/* update scanning pointer */
		if (tiff_optind >= nargc || *(place = nargv[tiff_optind]) != '-') {
			place = EMSG;
			return(EOF);
		}
		if (place[1] && *++place == '-') {	/* found "--" */
			++tiff_optind;
			place = EMSG;
			return(EOF);
		}
	}					/* option letter okay? */
	if ((tiff_optopt = (int)*place++) == (int)':' ||
	    !(oli = strchr(ostr, tiff_optopt))) {
		/*
		 * if the user didn't specify '-' as an option,
		 * assume it means EOF.
		 */
		if (tiff_optopt == (int)'-')
			return(EOF);
		if (!*place)
			++tiff_optind;
		if (tiff_opterr) {
			if (!(p = strrchr(*nargv, '/')))
				p = *nargv;
			else
				++p;
			(void)fprintf(stderr, "%s: illegal option -- %c\n",
			    p, tiff_optopt);
		}
		return(BADCH);
	}
	if (*++oli != ':') {			/* don't need argument */
		tiff_optarg = NULL;
		if (!*place)
			++tiff_optind;
	}
	else {					/* need an argument */
		if (*place)			/* no white space */
			tiff_optarg = place;
		else if (nargc <= ++tiff_optind) {	/* no arg */
			place = EMSG;
			if (!(p = strrchr(*nargv, '/')))
				p = *nargv;
			else
				++p;
			if (tiff_opterr)
				(void)fprintf(stderr,
				    "%s: option requires an argument -- %c\n",
				    p, tiff_optopt);
			return(BADCH);
		}
	 	else				/* white space */
			tiff_optarg = nargv[tiff_optind];
		place = EMSG;
		++tiff_optind;
	}
	return(tiff_optopt);				/* dump back option letter */
}
