#!/usr/bin/perl

#
# Copyright (C) 2001 Subhash Chandra <yschandra@yahoo.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

use strict;

my $Authors_File = "AUTHORS";
my $Header = "libyahoo-authors.h";
my @Author;
my @Email;
my $Authors_Count = 0;

read_authors_file();
generate_header();

sub read_authors_file {

	my @lines;
	my $i;

	open(INFILE, "<$Authors_File") || die "Could not open file $Authors_File\n";

	@lines = <INFILE>;
	close(INFILE);

	chomp(@lines);

	for ($i = 0; $i < @lines; ++$i) {

		if ($lines[$i] =~ m/([a-zA-Z\.\s]+)(<.*>)\s*$/) {
			push(@Author, $1);
			push(@Email, $2);
			++$Authors_Count;
		} elsif ($lines[$i + 1] =~ m/^-+\s*$/) {
			push(@Author, $lines[$i]);
			push(@Email, $lines[$i + 1]);
			++$i;
			$Authors_Count += 3;
		}
	}

	return;

}

sub generate_header {

	my $i;

	open(OUTFILE, ">$Header") || die "Could not open file $Header\n";

	select OUTFILE;

	print "#ifndef LIBYAHOO_AUTHORS_H\n";
	print "#define LIBYAHOO_AUTHORS_H\n\n";

	print "#define LIBYAHOO_AUTHORS_COUNT $Authors_Count\n\n";

	print "static gchar *libyahoo_authors[LIBYAHOO_AUTHORS_COUNT][2] = {\n";

	for ($i = 0; $i < @Author; ++$i) {

		if ($Email[$i] =~ m/^-+\s*$/) {

			if ($i != 0) {
				print "  {\"\", \"\"},\n";
			}
			print "  {\"$Author[$i]\", \"\"},\n";
			print "  {\"$Email[$i]\", \"\"},\n";

		} else {
			print "  {\"$Author[$i]\", \"$Email[$i]\"},\n";
		}

	}

	print "  {\"\", \"\"}\n";
	print "};\n\n";
	print "#endif /* LIBYAHOO_AUTHORS_H */\n\n";

	close(OUTFILE);

}
