// DragonLog.h: interface for the CDragonLog class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DRAGONLOG_H__9AD54BE1_82CD_4083_879E_3E00A81E50B7__INCLUDED_)
#define AFX_DRAGONLOG_H__9AD54BE1_82CD_4083_879E_3E00A81E50B7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "IDSLog.h"

#ifndef _WIN32
#include "config.h"
#endif

class CDragonLog : public CIDSLog  
{
public:
	CDragonLog();
	virtual ~CDragonLog();

private:
	void IDSVersion (char *sIDSProduct, int& nIDSID, int& nIDSMajor, int& nIDSMinor, char *sIDSRev) const;

	bool OpenLog (const char *filename);
	void SeekLog (double nDate);
	bool LastIncident ();
	bool ReadIncident ();
	void CloseLog ();
	double GetLastDate ();
	
	bool ParseField (char cField, const char *sField);
	double m_nTime;
	double m_nDate;
	int m_nPortscanLow;
	int m_nPortscanHigh;

	int m_nFileIndex;
	int m_nFileNum;
	int m_nNumFilesExist;
	int *m_pFilesExist;
	char *m_sPath;
	char m_sExportLogFormat[LOG_STRLEN + 1];
	char m_sExportLogFS[LOG_STRLEN + 1];

	FILE *m_pCurrentLogFile;
	double m_nStartDate;
	double m_nLastDate;

	static int *m_gFilesExist;
	static void addStuff (const char *fileName, int *pFilesExist);
#if !(defined HAVE_FTS_OPEN) && !(defined _WIN32)
	static int nftwCallback (const char *file, const struct stat *sb, int flag, struct FTW *s);
#endif

};

#endif // !defined(AFX_DRAGONLOG_H__9AD54BE1_82CD_4083_879E_3E00A81E50B7__INCLUDED_)
