-- $Id: arkhart.lua,v 1.4 2003/03/22 23:52:31 mrq Exp $
-- Arkhart RPG - An Ark-based roleplaying game.
-- Copyright (C) 2001 The Contributors of the Arkhart Project
-- Please see the file "AUTHORS" for a list of contributors
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

ark:require("{ai}/player.lua")
ark:require("{ai}/item.lua")
ark:require("{ai}/i18n.lua")
ark:require("{ai}/world.lua")

-- Called on startup
function ark.init ()
   ark.log ("\n==================================================");
   ark.log ("Initializing arkhart library");
   ark.log ("The Arkhart AI Library is free software, covered by the GNU "..
	    "General Public License, and you are welcome to change it "..
	    "and/or distribute \n copies of it under certain conditions");
   ark.log ("==================================================\n");
end;

function tr_entity_name(ent)
	ent:set_name(tr(ent:get_name()));
end;

-- Called after a world is loaded
function ark.main()
	-- Translate all entity names.
	ark.world:iterate_entities
		(function (ent)
			ent:set_name(tr(ent:get_name()))
		end);
end;


-- Called between each server frame.
function ark.nextframe ()
end;

