#! /bin/sh

[ -z "$1" ] && exit 1

tex=$1
name=`basename $1 .jpg`
mat=shaders/${name}.mat

echo "$tex -> $mat"

if [ -e $mat ]
then
	echo $mat already exists !
	exit 1
fi

cat >$mat <<EOF
// Ark Shader Def

"${name}"
{
	Ambient = {0.8, 0.8, 0.8, 1.0};
	Diffuse = {0.8, 1.0, 0.8, 1.0};
	Specular = {0.6, 0.6, 1.0, 1.0};

	Pass
	{
		Map = "{game}/data/${tex}";
		DepthFunc = LEqual;
		DepthWrite = True;
		Blending = (SrcAlpha, One);
		TextureGen = Linear ({0.0625, 0.0, 0.0, 0.0},
		                                    {0.0, 0.0, 0.0625, 0.0});
	}
}

EOF
