/* $Id: ArkFont.h,v 1.7 2003/03/20 17:23:25 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the ArkRPG Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARKFONT_H
#define ARKFONT_H

#include <Ark/ArkMath.h>

namespace Ark
{
	class Font;
	typedef Ptr<Font> FontPtr;

   /**
    * Alignment : anchor point of each character : center, top or bottom
    * at left, center or right..
    */
   enum FontAlignment
   {
      TOP_LEFT,
      TOP_CENTER,
      TOP_RIGHT,
      
      CENTER_LEFT,
      CENTER_CENTER,
      CENTER_RIGHT,
      
      BOTTOM_LEFT,
      BOTTOM_RIGHT,
      BOTTOM_CENTER,
   };


   //  =======================================================================
   /// Abstract interface for a font.
   //  =======================================================================
   class ARK_DLL_API Font : public Object
   {
      public:
	 /// Create an empty font with the specified name.
	 Font (const String &name);
	 
	 /// Destroy the font.
	 virtual ~Font ();

	 /**
	  * Get the width and the height a string will have on screen when
	  * rendered using this font and properties
	  */
	 virtual bool GetStringSize (const String &string, int *w, int *h) = 0;
	 
	 /// Get the bounds of a string using this font and properties.
	 virtual bool GetStringBounds (const String &string,
				       FontAlignment align,
				       int *min, int *max) = 0;

	 /// Draw a string using this font.
	 virtual bool DrawString (Renderer &render,
				  const String &string,
				  int x, int y,
				  FontAlignment align = CENTER_LEFT) = 0;
   };

}

#endif
