/* $Id: ArkLoaderMat.cpp,v 1.6 2001/10/27 20:22:26 zongo_fr Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) David Farrell <fdavid@cyberramp.net>
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <Ark/ArkParticle.h>
#include <Ark/ArkLoader.h>

namespace Ark
{
   class LoaderMat : public Loader
   {
      public:
	 /// Returns true if the file pointed to by \c name does really
	 /// contains a TEX texture file definition.
	 virtual bool CanLoad (ObjectType type, Stream &file,
			       const String &name, const String &args)
	 {
	    if (type != V_MATERIAL)
	       return false;
	    
	    String line;
	    std::getline (file, line);

	    if (name.find(".mat", 0) != String::npos)
	       return true;
	    
	    return false;
	 }
	 
	 /// Load the file pointed to by \c name, and read a object in it.
	 /// It will update the progress every \c granularity percents.
	 virtual bool Load (Object *vis, Stream &file, 
		 const String &name,
		 const String &args,
			    Cache *cache,
			    Progress *progress, int granularity)
	 {
	    if (vis == NULL || vis->Type() != V_MATERIAL)
	       return false;

	    ((Material*) vis)->Parse (name, file, *cache);
	    return true;
	 }
	 
	 /// Returns informations about the formats supported by this loader.
	 virtual String GetInformations()
	 {
	    return "Ark Material";
	 }
   };
   
   void ark_AddMatLoader (Loaders *loaders)
   {
      loaders->Add (new LoaderMat());
   }
}
