/* $Id: ArkSpline.h,v 1.4 2002/10/11 01:10:05 zongo Exp $
** 
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_SPLINE_H 
#define ARK_SPLINE_H

#include <Ark/Ark.h>
#include <Ark/ArkMath.h>

#include <vector>

namespace Ark
{
   typedef std::pair<scalar,Vector3> SplinePoint;
   typedef std::vector<SplinePoint> SplinePointList;

   class ARK_DLL_API Spline : public SplinePointList
   {
      protected:
	 SplinePointList m_Interp;
	 int m_CurPoint;
      public:
	 Spline();
	 bool Evaluate (scalar t, Vector3 &pos);

	 void Compute ();
	 bool IsGoalReached();
   };
};

#endif

