/* $Id: GLClient.h,v 1.12 2003/03/12 23:45:32 zongo Exp $
** 
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2003 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef CLIENT_GLCLIENT_H
#define CLIENT_GLCLIENT_H

#ifdef WIN32
 #include <windows.h>
#endif

#include <Client/Client.h>

#include <SDL.h>
#include <GL/gl.h>

// FIXME: Due to some NVIDIA includes, I had to add this for linux.
#ifndef WIN32
#undef GLAPIENTRY
#undef GLAPI
#define GLAPIENTRY
#define GLAPI
#endif
#include <GL/glu.h>

// When using windows, GL/gl.h includes windows.h, which defines min and max
// as macro. This might cause name clashes with the respective Ark functions.
#undef max
#undef min

namespace Client
{

   // Renderer-dependent client
   class GLClient : public Client
   {
      public:
	 int m_Width, m_Height;
	 scalar m_NearPlane, m_FarPlane;
	 bool m_Done;
	 UIRenderer *m_UI;

	 WidgetPtr m_TerrainWidget, m_SplashWidget, m_MenuWidget;
	 WidgetPtr m_CurWidget;

      public:
	 GLClient (int argc, char **argv);
	 ~GLClient ();

	 virtual int Loop ();
	 virtual bool ProcessEvents ();
	 virtual bool HandleEvent (SDL_Event *event);

	 ///
	 virtual void HandleKey (bool down, int mods, int key) {}
	 virtual void HandleMButton (bool down, int b, int x, int y) {}
	 virtual void HandleMotion (int state, int x, int y) {}
	 virtual bool Refresh ();

	 ///
	 inline void SetNearAndFarPlanes(scalar n, scalar f) { m_NearPlane = n; m_FarPlane = f; }

	 virtual void HandleMenuString(const Ark::String &str);

     protected:
	 float gamma_red,gamma_green,gamma_blue;
   };

}

#endif
